/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.alarms;

import cern.laser.client.data.Alarm;
import cern.laser.console.Comment;
import cern.laser.console.CommentedAlarm;
import cern.laser.console.CommentedAlarmMap;
import cern.laser.guiplatform.alarms.AlarmBean;
import cern.laser.guiplatform.alarms.AlarmNodeManager;
import cern.laser.guiplatform.alarms.NodeFactory;
import cern.laser.guiplatform.explorer.ACChildrenMap;
import cern.laser.guiplatform.util.LogFactory;
import java.beans.IntrospectionException;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class AlarmNodeManagerImpl
extends AlarmNodeManager {
    private static Logger logger = LogFactory.getLogger(AlarmNodeManagerImpl.class.getName());

    public AlarmNodeManagerImpl(String string, Collection collection) {
        super(string, collection);
    }

    public void initChildrenMap(ACChildrenMap aCChildrenMap) {
        try {
            this.root = NodeFactory.createNode(new Object(), (Children)aCChildrenMap);
            for (AlarmBean alarmBean : this.initList) {
                this.getMap().addNode(alarmBean.getAlarmId(), (Node)NodeFactory.createNode(alarmBean));
            }
        }
        catch (IntrospectionException introspectionException) {
            logger.error((Object)introspectionException, introspectionException.fillInStackTrace());
        }
    }

    private void customizeBean(AlarmBean alarmBean) {
        if (this.listName.equals("INHIBIT_LIST_LISTENER")) {
            alarmBean.setIsAlarmNodeInhibited(true);
        } else if (this.listName.equals("MASKED_LIST_LISTENER")) {
            alarmBean.setIsAlarmNodeMasked(true);
        } else if (this.listName.equals("AUTO_HIGHLITED_LIST_LISTENER")) {
            alarmBean.setIsAlarmNodeHighlightedAndKlaxon(true);
            alarmBean.setIsOnHighlightedList(true);
        }
    }

    @Override
    public void addAlarm(AlarmBean alarmBean) {
        try {
            if (this.getMap() != null) {
                this.getMap().addNode((Node)NodeFactory.createNode(alarmBean));
            }
        }
        catch (IntrospectionException introspectionException) {
            logger.error((Object)introspectionException, introspectionException.fillInStackTrace());
        }
    }

    @Override
    public void addAlarms(Collection collection) {
        Object[] objectArray = collection.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            AlarmBean alarmBean;
            logger.debug((Object)("addAlarms() - alarms[i]=" + objectArray[i]));
            if (objectArray[i] instanceof AlarmBean) {
                alarmBean = (AlarmBean)objectArray[i];
            } else {
                Comment comment = new Comment("", "");
                CommentedAlarm commentedAlarm = new CommentedAlarm((Alarm)objectArray[i], comment);
                alarmBean = new AlarmBean(commentedAlarm);
            }
            this.addAlarm(alarmBean);
            System.out.println("AlarmNodeManagerImpl: addAlarms() ");
            System.out.println("NodeCount = " + this.getMap().getNodesCount());
        }
    }

    @Override
    public void removeAlarm(AlarmBean alarmBean) {
        this.removeAlarm(alarmBean.getAlarmId());
    }

    @Override
    public void removeAlarm(String string) {
        this.getMap().removeNode(string);
    }

    @Override
    public void removeAlarms(Collection collection) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Override
    public void removeAllAlarms() {
        if (this.getMap() != null) {
            this.getMap().clear();
        }
    }

    @Override
    public void initNodeManager(Collection collection) {
        throw new UnsupportedOperationException("method should not be used, because is not needed");
    }

    @Override
    public void initNodeManager(Collection collection, CommentedAlarmMap commentedAlarmMap) {
        throw new UnsupportedOperationException("method should not be used, because is not needed");
    }
}

