/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.alarms;

import cern.laser.console.CommentedAlarmMap;
import cern.laser.guiplatform.alarms.AlarmBean;
import cern.laser.guiplatform.alarms.AlarmBeanNode;
import cern.laser.guiplatform.alarms.AlarmContainer;
import cern.laser.guiplatform.alarms.AlarmListener;
import cern.laser.guiplatform.alarms.NodeFactory;
import cern.laser.guiplatform.explorer.ACChildrenMap;
import cern.laser.guiplatform.util.LogFactory;
import java.beans.IntrospectionException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public abstract class AlarmNodeManager
implements AlarmListener,
ExplorerManager.Provider {
    protected static Logger logger = LogFactory.getLogger(AlarmNodeManager.class.getName());
    protected String listName = null;
    protected Collection initList = null;
    protected Node root = null;
    protected ExplorerManager explorerManager = null;

    protected AlarmNodeManager(String string, Collection collection) {
        this.listName = string;
        this.initList = collection;
        try {
            this.root = NodeFactory.createRootNode();
            this.addAlarms(collection);
            this.getExplorerManager().setRootContext(this.root);
        }
        catch (IntrospectionException introspectionException) {
            logger.error((Object)introspectionException.getMessage(), (Throwable)introspectionException);
        }
    }

    public abstract void removeAllAlarms();

    public abstract void initNodeManager(Collection var1);

    public abstract void initNodeManager(Collection var1, CommentedAlarmMap var2);

    public AlarmBean getAlarm(String string) {
        AlarmBeanNode alarmBeanNode = null;
        ACChildrenMap aCChildrenMap = this.getMap();
        if (aCChildrenMap != null && (alarmBeanNode = (AlarmBeanNode)aCChildrenMap.getNode(string)) != null) {
            return (AlarmBean)alarmBeanNode.getBean();
        }
        return null;
    }

    public Node getRootNode() {
        return this.root;
    }

    public void makeAlarmsNotNew() {
        ACChildrenMap aCChildrenMap = this.getMap();
        Set set = aCChildrenMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            AlarmBean alarmBean = (AlarmBean)((AlarmBeanNode)aCChildrenMap.getNode(iterator.next())).getBean();
            if (!alarmBean.isNew()) continue;
            alarmBean.setIsNew(false);
        }
    }

    public void fireFontChanged() {
        ACChildrenMap aCChildrenMap = this.getMap();
        Set set = aCChildrenMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            AlarmBean alarmBean = (AlarmBean)((AlarmBeanNode)aCChildrenMap.getNode(iterator.next())).getBean();
            alarmBean.fireFontChanged();
        }
    }

    public void programmagbleInitManager() {
        Children children = this.root.getChildren();
        children.getNodes();
        AlarmContainer.getDefault().attach(this.listName, this);
    }

    public ExplorerManager getExplorerManager() {
        if (this.explorerManager == null) {
            this.explorerManager = new ExplorerManager();
        }
        return this.explorerManager;
    }

    public ACChildrenMap getMap() {
        return (ACChildrenMap)this.root.getChildren();
    }
}

