/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.alarms;

import EDU.oswego.cs.dl.util.concurrent.Mutex;
import cern.laser.client.LaserException;
import cern.laser.client.data.Alarm;
import cern.laser.client.data.Category;
import cern.laser.client.services.browsing.AlarmBrowsingHandler;
import cern.laser.client.services.selection.AlarmSearchListener;
import cern.laser.client.services.selection.AlarmSelectionListener;
import cern.laser.client.services.selection.CategorySelection;
import cern.laser.client.services.selection.LaserSearchException;
import cern.laser.client.services.selection.LaserSelectionException;
import cern.laser.console.Behaviour;
import cern.laser.console.Comment;
import cern.laser.console.CommentedAlarm;
import cern.laser.console.CommentedAlarmMap;
import cern.laser.console.Configuration;
import cern.laser.console.LaserConsoleException;
import cern.laser.guiplatform.alarms.AlarmBean;
import cern.laser.guiplatform.alarms.AlarmBrowsingHandlerFactory;
import cern.laser.guiplatform.alarms.AlarmListener;
import cern.laser.guiplatform.alarms.AlarmNodeManager;
import cern.laser.guiplatform.alarms.AlarmNodeManagerFactory;
import cern.laser.guiplatform.alarms.AlarmSelectionOnExceptionListener;
import cern.laser.guiplatform.alarms.AlarmsNumberChangeListener;
import cern.laser.guiplatform.logging.TraceLogger;
import cern.laser.guiplatform.util.AppRegister;
import cern.laser.guiplatform.util.LogFactory;
import cern.laser.guiplatform.windowmanager.AcWindowManager;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AlarmContainer
implements AlarmSelectionListener,
AlarmSearchListener {
    private static Logger logger = LogFactory.getLogger(AlarmContainer.class.getName());
    private static AlarmContainer INSTANCE = null;
    private Map observers = null;
    private Map alarmNumberChangeObservers = null;
    private List onExceptionListeners = null;
    private Map nodeManagers = null;
    private final Mutex lock = new Mutex();
    private CommentedAlarmMap activeList = null;
    private CommentedAlarmMap inhibitList = null;
    private CommentedAlarmMap maskedList = null;
    private CommentedAlarmMap highlightedAndKlaxonList = null;
    private CommentedAlarmMap instantList = null;
    private CommentedAlarmMap highlightedList = null;
    private CommentedAlarmMap acknowledgedList = null;
    private CommentedAlarmMap notNewAlarmsList = null;

    private AlarmContainer() {
        this.observers = new HashMap();
        this.alarmNumberChangeObservers = new HashMap();
        this.onExceptionListeners = new ArrayList();
        this.activeList = new CommentedAlarmMap();
        this.inhibitList = new CommentedAlarmMap();
        this.maskedList = new CommentedAlarmMap();
        this.highlightedAndKlaxonList = new CommentedAlarmMap();
        this.instantList = new CommentedAlarmMap();
        this.highlightedList = new CommentedAlarmMap();
        this.acknowledgedList = new CommentedAlarmMap();
        this.notNewAlarmsList = new CommentedAlarmMap();
        this.nodeManagers = new HashMap();
    }

    public static AlarmContainer getDefault() {
        if (INSTANCE == null) {
            INSTANCE = new AlarmContainer();
        }
        return INSTANCE;
    }

    public void clearContainer() {
        this.observers.clear();
        this.observers = null;
        this.alarmNumberChangeObservers.clear();
        this.alarmNumberChangeObservers = null;
        this.onExceptionListeners.clear();
        this.onExceptionListeners = null;
        for (AlarmNodeManager alarmNodeManager : this.nodeManagers.values()) {
            alarmNodeManager.removeAllAlarms();
        }
        this.activeList.clear();
        this.activeList = null;
        this.inhibitList.clear();
        this.inhibitList = null;
        this.maskedList.clear();
        this.maskedList = null;
        this.highlightedAndKlaxonList.clear();
        this.highlightedAndKlaxonList = null;
        this.instantList.clear();
        this.instantList = null;
        this.highlightedList.clear();
        this.highlightedList = null;
        this.acknowledgedList.clear();
        this.acknowledgedList = null;
        this.notNewAlarmsList.clear();
        this.notNewAlarmsList = null;
        this.nodeManagers.clear();
        this.nodeManagers = null;
        INSTANCE = null;
    }

    public void attach(String string, AlarmListener alarmListener) {
        this.observers.put(string, alarmListener);
    }

    public void detach(String string) {
        this.observers.remove(string);
    }

    public void attach(String string, AlarmsNumberChangeListener alarmsNumberChangeListener) {
        this.alarmNumberChangeObservers.put(string, alarmsNumberChangeListener);
        alarmsNumberChangeListener.update(0, this.activeList.values().size());
        alarmsNumberChangeListener.update(2, this.inhibitList.values().size());
        alarmsNumberChangeListener.update(1, this.maskedList.values().size());
    }

    public void detachAlarmNumberChangeListener(String string) {
        this.alarmNumberChangeObservers.remove(string);
    }

    private CommentedAlarmMap getList(String string) {
        if (string.equals("INHIBIT_LIST_LISTENER")) {
            return this.inhibitList;
        }
        if (string.equals("MASKED_LIST_LISTENER")) {
            return this.maskedList;
        }
        if (string.equals("AUTO_HIGHLITED_LIST_LISTENER")) {
            return this.highlightedAndKlaxonList;
        }
        if (string.equals("INSTANT_LIST_LISTENER")) {
            return this.instantList;
        }
        return this.activeList;
    }

    public void addAlarmSelectionOnExceptionListener(AlarmSelectionOnExceptionListener alarmSelectionOnExceptionListener) {
        this.onExceptionListeners.add(alarmSelectionOnExceptionListener);
    }

    public void removeAlarmSelectionOnExceptionListener(AlarmSelectionOnExceptionListener alarmSelectionOnExceptionListener) {
        this.onExceptionListeners.remove(alarmSelectionOnExceptionListener);
    }

    public AlarmNodeManager getAlarmNodeManager(String string) {
        if (!(string.equals("ACTIVE_LIST_LISTENER") || string.equals("INHIBIT_LIST_LISTENER") || string.equals("AUTO_HIGHLITED_LIST_LISTENER") || string.equals("MASKED_LIST_LISTENER") || string.equals("INSTANT_LIST_LISTENER") || string.equals("SEARCH_LISTENER_KEY"))) {
            throw new IllegalArgumentException("Invalid alarm list name");
        }
        return (AlarmNodeManager)this.nodeManagers.get(string);
    }

    public void initContainer(Map map, Configuration configuration) throws LaserConsoleException {
        Object object;
        Object object2;
        Object object32;
        Object object4;
        Object object5;
        Object object62;
        Object object7;
        Object object82;
        Object object9;
        Object object102;
        logger.debug((Object)("initializing alarm container !!! with initList=" + map));
        this.inhibitList = configuration.getInhibited();
        this.maskedList = configuration.getMasked();
        this.highlightedAndKlaxonList = configuration.getAutoHighlighted();
        this.highlightedList = configuration.getHighlighted();
        this.acknowledgedList = configuration.getAcknowledged();
        this.notNewAlarmsList = configuration.getNewIndicator();
        logger.debug((Object)("inhibitList=" + this.inhibitList));
        logger.debug((Object)("maskedList=" + this.maskedList));
        logger.debug((Object)("highlightedAndKlaxon=" + this.highlightedAndKlaxonList));
        logger.debug((Object)("highlightedList=" + this.highlightedList));
        logger.debug((Object)("acknowledgedList=" + this.acknowledgedList));
        logger.debug((Object)("not new list=" + this.notNewAlarmsList));
        logger.debug((Object)("highlightedList size: " + this.highlightedList.size()));
        if (configuration.getActiveListFont() != null && configuration.getActiveListFont().equals(Boolean.TRUE)) {
            AppRegister.getInstance().setFontBig(true);
        } else {
            AppRegister.getInstance().setFontBig(false);
        }
        this.processList(map, this.inhibitList);
        this.processList(map, this.maskedList);
        for (Object object102 : map.values()) {
            object9 = new CommentedAlarm((Alarm)object102, null);
            this.activeList.put((CommentedAlarm)object9);
        }
        ArrayList arrayList = new ArrayList();
        object102 = new ArrayList();
        for (Object object82 : this.activeList.values()) {
            object7 = new AlarmBean((CommentedAlarm)object82);
            if (this.highlightedAndKlaxonList.containsKey(object82.getAlarm().getAlarmId())) {
                ((AlarmBean)object7).setIsAlarmNodeHighlightedAndKlaxon(true);
                object62 = this.highlightedAndKlaxonList.get(object82.getAlarm().getAlarmId());
                object5 = new AlarmBean((CommentedAlarm)object62);
                ((AlarmBean)object5).setIsAlarmNodeHighlightedAndKlaxon(true);
                ((AlarmBean)object5).setIsOnHighlightedList(true);
                ((AlarmBean)object5).registerPropertyChangeListener((PropertyChangeListener)object7);
                ((AlarmBean)object7).registerPropertyChangeListener((PropertyChangeListener)object5);
                arrayList.add(object5);
            }
            if (this.highlightedList.containsKey(object82.getAlarm().getAlarmId())) {
                ((AlarmBean)object7).setIsAlarmNodeHighlighted(true);
            }
            object102.add(object7);
        }
        logger.debug((Object)("acknowledgedList=" + this.acknowledgedList));
        object9 = object102.iterator();
        while (object9.hasNext()) {
            object82 = (AlarmBean)object9.next();
            logger.debug((Object)("set acknowledge, ab=" + object82));
            if (!this.acknowledgedList.containsKey(((AlarmBean)object82).getAlarmId())) continue;
            ((AlarmBean)object82).setIsAlarmNodeAcknowledged(true);
            logger.debug((Object)("--> Alarm acknowledged " + ((AlarmBean)object82).getAlarmId() + "state=" + ((AlarmBean)object82).isAlarmNodeAcknowledged()));
        }
        object9 = object102.iterator();
        while (object9.hasNext()) {
            object82 = (AlarmBean)object9.next();
            logger.debug((Object)("set not new, ab=" + object82));
            if (!this.notNewAlarmsList.containsKey(((AlarmBean)object82).getAlarmId())) continue;
            ((AlarmBean)object82).setIsNew(false);
            logger.debug((Object)("--> Alarm set as not new " + ((AlarmBean)object82).getAlarmId() + "state=" + ((AlarmBean)object82).isNew()));
        }
        object9 = AlarmNodeManagerFactory.createNodeManager("ACTIVE_LIST_LISTENER", (Collection)object102);
        ((AlarmNodeManager)object9).programmagbleInitManager();
        object82 = new ArrayList();
        for (Object object62 : this.inhibitList.values()) {
            object5 = new AlarmBean((CommentedAlarm)object62);
            if (this.highlightedAndKlaxonList.containsKey(object62.getAlarm().getAlarmId())) {
                ((AlarmBean)object5).setIsAlarmNodeHighlightedAndKlaxon(true);
                object4 = this.highlightedAndKlaxonList.get(object62.getAlarm().getAlarmId());
                object32 = new AlarmBean((CommentedAlarm)object4);
                ((AlarmBean)object32).setIsAlarmNodeHighlightedAndKlaxon(true);
                ((AlarmBean)object32).setIsOnHighlightedList(true);
                ((AlarmBean)object32).registerPropertyChangeListener((PropertyChangeListener)object5);
                ((AlarmBean)object5).registerPropertyChangeListener((PropertyChangeListener)object32);
                arrayList.add(object32);
            }
            ((AlarmBean)object5).setIsAlarmNodeInhibited(true);
            logger.debug((Object)("inhibit, alarmBean is " + object5));
            logger.debug((Object)("inhibit, active=" + ((AlarmBean)object5).isAlarmNodeActive()));
            logger.debug((Object)("inhibit, on highlighted list=" + ((AlarmBean)object5).isOnHighlightedList()));
            object82.add(object5);
        }
        object7 = AlarmNodeManagerFactory.createNodeManager("INHIBIT_LIST_LISTENER", (Collection)object82);
        ((AlarmNodeManager)object7).programmagbleInitManager();
        object62 = new ArrayList();
        object5 = this.maskedList.values().iterator();
        while (object5.hasNext()) {
            object4 = (CommentedAlarm)object5.next();
            object32 = new AlarmBean((CommentedAlarm)object4);
            if (this.highlightedAndKlaxonList.containsKey(object4.getAlarm().getAlarmId())) {
                ((AlarmBean)object32).setIsAlarmNodeHighlightedAndKlaxon(true);
                object2 = this.highlightedAndKlaxonList.get(object4.getAlarm().getAlarmId());
                object = new AlarmBean((CommentedAlarm)object2);
                ((AlarmBean)object).setIsAlarmNodeHighlightedAndKlaxon(true);
                ((AlarmBean)object).setIsOnHighlightedList(true);
                ((AlarmBean)object).registerPropertyChangeListener((PropertyChangeListener)object32);
                ((AlarmBean)object32).registerPropertyChangeListener((PropertyChangeListener)object);
                arrayList.add(object);
            }
            ((AlarmBean)object32).setIsAlarmNodeMasked(true);
            object2 = configuration.getSelection().getCategorySelection();
            if (this.belongsToSelectedCategories((AlarmBean)object32, (CategorySelection)object2)) {
                object62.add(object32);
                logger.debug((Object)"reload container: add alarm to mask list because it is in selection");
                continue;
            }
            object5.remove();
        }
        object5 = AlarmNodeManagerFactory.createNodeManager("MASKED_LIST_LISTENER", (Collection)object62);
        ((AlarmNodeManager)object5).programmagbleInitManager();
        for (Object object32 : this.highlightedAndKlaxonList.values()) {
            object2 = new AlarmBean((CommentedAlarm)object32);
            if (arrayList.contains(object2)) continue;
            ((AlarmBean)object2).setIsAlarmNodeHighlightedAndKlaxon(true);
            ((AlarmBean)object2).setIsOnHighlightedList(true);
            logger.debug((Object)(((AlarmBean)object2).getName() + " must be added to higlightedKlaxonTempList"));
            logger.debug((Object)("IsAlarmNodeHighlightedAndKlaxon: " + ((AlarmBean)object2).isAlarmNodeHighlightedAndKlaxon()));
            logger.debug((Object)("IsOnHighlightedList: " + ((AlarmBean)object2).isOnHighlightedList()));
            arrayList.add(object2);
        }
        object4 = AlarmNodeManagerFactory.createNodeManager("AUTO_HIGHLITED_LIST_LISTENER", arrayList);
        ((AlarmNodeManager)object4).programmagbleInitManager();
        object32 = AlarmNodeManagerFactory.createNodeManager("INSTANT_LIST_LISTENER", new ArrayList());
        ((AlarmNodeManager)object32).programmagbleInitManager();
        object2 = AlarmNodeManagerFactory.createNodeManager("SEARCH_LISTENER_KEY", new ArrayList());
        this.nodeManagers.put("ACTIVE_LIST_LISTENER", object9);
        this.nodeManagers.put("INHIBIT_LIST_LISTENER", object7);
        this.nodeManagers.put("MASKED_LIST_LISTENER", object5);
        this.nodeManagers.put("AUTO_HIGHLITED_LIST_LISTENER", object4);
        this.nodeManagers.put("INSTANT_LIST_LISTENER", object32);
        this.nodeManagers.put("SEARCH_LISTENER_KEY", object2);
        object = null;
        Iterator iterator = this.alarmNumberChangeObservers.keySet().iterator();
        while (iterator.hasNext()) {
            object = (AlarmsNumberChangeListener)this.alarmNumberChangeObservers.get(iterator.next());
            object.update(0, this.activeList.values().size());
            object.update(2, this.inhibitList.values().size());
            object.update(1, object62.size());
        }
    }

    public void clearNodeManagers() {
        for (Object object : this.nodeManagers.values()) {
            ((AlarmNodeManager)object).removeAllAlarms();
        }
        for (Object object : this.alarmNumberChangeObservers.values()) {
            object.update(0, 0L);
            object.update(2, 0L);
            object.update(1, 0L);
        }
        this.activeList.clear();
        this.inhibitList.clear();
        this.maskedList.clear();
        this.highlightedAndKlaxonList.clear();
        this.instantList.clear();
        this.highlightedList.clear();
        this.acknowledgedList.clear();
        this.notNewAlarmsList.clear();
    }

    public void reloadContainer(Map map, Configuration configuration) throws LaserConsoleException {
        Object object;
        Object object2;
        Object object32;
        Object object42;
        Object object5;
        Object object62;
        Object object7;
        Object object82;
        Object object9;
        Object object102;
        logger.debug((Object)("reloading  alarm container, new active list size: " + map.size()));
        this.inhibitList = configuration.getInhibited();
        this.maskedList = configuration.getMasked();
        this.highlightedAndKlaxonList = configuration.getAutoHighlighted();
        this.highlightedList = configuration.getHighlighted();
        this.acknowledgedList = configuration.getAcknowledged();
        this.notNewAlarmsList = configuration.getNewIndicator();
        if (configuration.getActiveListFont() != null && configuration.getActiveListFont().equals(Boolean.TRUE)) {
            AppRegister.getInstance().setFontBig(true);
        } else {
            AppRegister.getInstance().setFontBig(false);
        }
        this.processList(map, this.inhibitList);
        this.processList(map, this.maskedList);
        for (Object object102 : map.values()) {
            object9 = new CommentedAlarm((Alarm)object102, null);
            this.activeList.put((CommentedAlarm)object9);
        }
        ArrayList arrayList = new ArrayList();
        object102 = new ArrayList();
        for (Object object82 : this.activeList.values()) {
            object7 = new AlarmBean((CommentedAlarm)object82);
            if (this.highlightedAndKlaxonList.containsKey(object82.getAlarm().getAlarmId())) {
                ((AlarmBean)object7).setIsAlarmNodeHighlightedAndKlaxon(true);
                object62 = this.highlightedAndKlaxonList.get(object82.getAlarm().getAlarmId());
                object5 = new AlarmBean((CommentedAlarm)object62);
                ((AlarmBean)object5).setIsAlarmNodeHighlightedAndKlaxon(true);
                ((AlarmBean)object5).setIsOnHighlightedList(true);
                ((AlarmBean)object5).registerPropertyChangeListener((PropertyChangeListener)object7);
                ((AlarmBean)object7).registerPropertyChangeListener((PropertyChangeListener)object5);
                arrayList.add(object5);
            }
            if (this.highlightedList.containsKey(object82.getAlarm().getAlarmId())) {
                ((AlarmBean)object7).setIsAlarmNodeHighlighted(true);
            }
            object102.add(object7);
        }
        logger.debug((Object)("acknowledgedList=" + this.acknowledgedList));
        object9 = object102.iterator();
        while (object9.hasNext()) {
            object82 = (AlarmBean)object9.next();
            logger.debug((Object)("set acknowledge, ab=" + object82));
            if (!this.acknowledgedList.containsKey(((AlarmBean)object82).getAlarmId())) continue;
            ((AlarmBean)object82).setIsAlarmNodeAcknowledged(true);
            logger.debug((Object)("--> Alarm acknowledged " + ((AlarmBean)object82).getAlarmId() + "state=" + ((AlarmBean)object82).isAlarmNodeAcknowledged()));
        }
        object9 = object102.iterator();
        while (object9.hasNext()) {
            object82 = (AlarmBean)object9.next();
            logger.debug((Object)("set not new, ab=" + object82));
            if (!this.notNewAlarmsList.containsKey(((AlarmBean)object82).getAlarmId())) continue;
            ((AlarmBean)object82).setIsNew(false);
            logger.debug((Object)("--> Alarm set as not new " + ((AlarmBean)object82).getAlarmId() + "state=" + ((AlarmBean)object82).isNew()));
        }
        object9 = this.getAlarmNodeManager("ACTIVE_LIST_LISTENER");
        object82 = object102.iterator();
        while (object82.hasNext()) {
            object9.addAlarm((AlarmBean)object82.next());
        }
        object82 = new ArrayList();
        for (Object object62 : this.inhibitList.values()) {
            object5 = new AlarmBean((CommentedAlarm)object62);
            if (this.highlightedAndKlaxonList.containsKey(object62.getAlarm().getAlarmId())) {
                ((AlarmBean)object5).setIsAlarmNodeHighlightedAndKlaxon(true);
                object42 = this.highlightedAndKlaxonList.get(object62.getAlarm().getAlarmId());
                object32 = new AlarmBean((CommentedAlarm)object42);
                ((AlarmBean)object32).setIsAlarmNodeHighlightedAndKlaxon(true);
                ((AlarmBean)object32).setIsOnHighlightedList(true);
                ((AlarmBean)object32).registerPropertyChangeListener((PropertyChangeListener)object5);
                ((AlarmBean)object5).registerPropertyChangeListener((PropertyChangeListener)object32);
                arrayList.add(object32);
            }
            ((AlarmBean)object5).setIsAlarmNodeInhibited(true);
            object82.add(object5);
        }
        object7 = this.getAlarmNodeManager("INHIBIT_LIST_LISTENER");
        object62 = object82.iterator();
        while (object62.hasNext()) {
            object7.addAlarm((AlarmBean)object62.next());
        }
        object62 = new ArrayList();
        for (Object object42 : this.maskedList.values()) {
            object32 = new AlarmBean((CommentedAlarm)object42);
            if (this.highlightedAndKlaxonList.containsKey(object42.getAlarm().getAlarmId())) {
                ((AlarmBean)object32).setIsAlarmNodeHighlightedAndKlaxon(true);
                object2 = this.highlightedAndKlaxonList.get(object42.getAlarm().getAlarmId());
                object = new AlarmBean((CommentedAlarm)object2);
                ((AlarmBean)object).setIsAlarmNodeHighlightedAndKlaxon(true);
                ((AlarmBean)object).setIsOnHighlightedList(true);
                ((AlarmBean)object).registerPropertyChangeListener((PropertyChangeListener)object32);
                ((AlarmBean)object32).registerPropertyChangeListener((PropertyChangeListener)object);
                arrayList.add(object);
            }
            ((AlarmBean)object32).setIsAlarmNodeMasked(true);
            object2 = configuration.getSelection().getCategorySelection();
            if (!this.belongsToSelectedCategories((AlarmBean)object32, (CategorySelection)object2)) continue;
            object62.add(object32);
            logger.debug((Object)"reload container: add alarm to mask list because it is in selection");
        }
        object5 = this.getAlarmNodeManager("MASKED_LIST_LISTENER");
        object42 = object62.iterator();
        while (object42.hasNext()) {
            object5.addAlarm((AlarmBean)object42.next());
        }
        for (Object object32 : this.highlightedAndKlaxonList.values()) {
            object2 = new AlarmBean((CommentedAlarm)object32);
            if (arrayList.contains(object2)) continue;
            ((AlarmBean)object2).setIsAlarmNodeHighlightedAndKlaxon(true);
            ((AlarmBean)object2).setIsOnHighlightedList(true);
            arrayList.add(object2);
        }
        object42 = this.getAlarmNodeManager("AUTO_HIGHLITED_LIST_LISTENER");
        object32 = arrayList.iterator();
        while (object32.hasNext()) {
            object42.addAlarm((AlarmBean)object32.next());
        }
        object32 = null;
        object2 = null;
        object = this.alarmNumberChangeObservers.keySet().iterator();
        while (object.hasNext()) {
            object2 = (AlarmsNumberChangeListener)this.alarmNumberChangeObservers.get(object.next());
            object2.update(0, this.activeList.values().size());
            object2.update(2, this.inhibitList.values().size());
            object2.update(1, object62.size());
        }
    }

    private void processList(Map map, CommentedAlarmMap commentedAlarmMap) {
        Iterator iterator = commentedAlarmMap.values().iterator();
        while (iterator.hasNext()) {
            Alarm alarm = ((CommentedAlarm)iterator.next()).getAlarm();
            logger.debug((Object)alarm.getAlarmId());
            if (!map.containsKey(alarm.getAlarmId())) continue;
            Alarm alarm2 = (Alarm)map.remove(alarm.getAlarmId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inhibit(AlarmBean[] alarmBeanArray, Comment comment) {
        boolean bl = false;
        try {
            this.lock.acquire();
            try {
                CommentedAlarm[] commentedAlarmArray = new CommentedAlarm[alarmBeanArray.length];
                for (int i = 0; i < alarmBeanArray.length; ++i) {
                    commentedAlarmArray[i] = alarmBeanArray[i].getCommentedAlarm();
                    commentedAlarmArray[i].setComment(comment);
                }
                CommentedAlarmMap commentedAlarmMap = new CommentedAlarmMap();
                commentedAlarmMap.putAll(this.inhibitList);
                for (int i = 0; i < commentedAlarmArray.length; ++i) {
                    commentedAlarmMap.put(commentedAlarmArray[i]);
                }
                try {
                    int n;
                    Configuration configuration = AppRegister.getInstance().getLoadedConfiguration();
                    if (!AppRegister.getInstance().isGuestMode()) {
                        configuration.setInhibited(commentedAlarmMap);
                    }
                    for (n = 0; n < commentedAlarmArray.length; ++n) {
                        this.inhibitList.put(commentedAlarmArray[n]);
                    }
                    for (n = 0; n < commentedAlarmArray.length; ++n) {
                        this.activeList.remove(commentedAlarmArray[n].getAlarm().getAlarmId());
                    }
                    AlarmNodeManager alarmNodeManager = this.getAlarmNodeManager("ACTIVE_LIST_LISTENER");
                    AlarmNodeManager alarmNodeManager2 = this.getAlarmNodeManager("INHIBIT_LIST_LISTENER");
                    for (int i = 0; i < alarmBeanArray.length; ++i) {
                        alarmNodeManager.removeAlarm(alarmBeanArray[i]);
                        AlarmBean alarmBean = alarmBeanArray[i];
                        alarmBean.setIsAlarmNodeInhibited(true);
                        alarmNodeManager2.addAlarm(alarmBean);
                        this.updateAlarmNumberChangeListeners(0, 2);
                    }
                }
                catch (LaserConsoleException laserConsoleException) {
                    this.lock.release();
                    bl = true;
                    logger.error((Object)laserConsoleException, laserConsoleException.fillInStackTrace());
                    logger.error((Object)laserConsoleException.getRootCause(), laserConsoleException.getRootCause().fillInStackTrace());
                    TraceLogger.log(laserConsoleException.fillInStackTrace());
                    AcWindowManager.notifyError("Alarm can't be inhibited.\nInternal error.\nSee log files or contact console developers.");
                }
            }
            finally {
                if (!bl) {
                    this.lock.release();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)interruptedException, interruptedException.fillInStackTrace());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninhibit(AlarmBean[] alarmBeanArray) {
        boolean bl = false;
        Configuration configuration = AppRegister.getInstance().getLoadedConfiguration();
        CategorySelection categorySelection = AppRegister.getInstance().getSelection().getCategorySelection();
        boolean bl2 = AppRegister.getInstance().getBehaviour().isAlarmAutoTerminated();
        ArrayList<AlarmBean> arrayList = new ArrayList<AlarmBean>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        AlarmBrowsingHandler alarmBrowsingHandler = null;
        try {
            this.lock.acquire();
            try {
                CommentedAlarmMap commentedAlarmMap = new CommentedAlarmMap();
                commentedAlarmMap.putAll(this.inhibitList);
                try {
                    Object object4;
                    Object object2;
                    int n;
                    alarmBrowsingHandler = AlarmBrowsingHandlerFactory.getHandler();
                    for (n = 0; n < alarmBeanArray.length; ++n) {
                        String string = alarmBeanArray[n].getAlarmId();
                        object2 = commentedAlarmMap.remove(string);
                        object4 = alarmBrowsingHandler.getAlarmById(string);
                        boolean bl3 = false;
                        Collection collection = object4.getCategories();
                        Object object3 = collection.iterator();
                        while (object3.hasNext()) {
                            Category category = (Category)object3.next();
                            if (!categorySelection.contains(category)) continue;
                            bl3 = true;
                            break;
                        }
                        if (!bl3 || !object4.getStatus().isActive() && (object4.getStatus().isActive() || bl2)) continue;
                        object2.setAlarm((Alarm)object4);
                        arrayList2.add(object2);
                        arrayList.add(alarmBeanArray[n]);
                    }
                    if (!AppRegister.getInstance().isGuestMode()) {
                        configuration.setInhibited(commentedAlarmMap);
                    }
                    for (n = 0; n < alarmBeanArray.length; ++n) {
                        this.inhibitList.remove(alarmBeanArray[n].getAlarmId());
                    }
                    AlarmNodeManager alarmNodeManager = this.getAlarmNodeManager("INHIBIT_LIST_LISTENER");
                    for (int i = 0; i < alarmBeanArray.length; ++i) {
                        alarmNodeManager.removeAlarm(alarmBeanArray[i]);
                        for (Object object4 : this.alarmNumberChangeObservers.values()) {
                            object4.decreaseCounter(2);
                        }
                    }
                    AlarmNodeManager alarmNodeManager2 = this.getAlarmNodeManager("ACTIVE_LIST_LISTENER");
                    object2 = arrayList.iterator();
                    object4 = arrayList2.iterator();
                    while (object2.hasNext() && object4.hasNext()) {
                        AlarmBean alarmBean = (AlarmBean)object2.next();
                        alarmBean.setIsAlarmNodeActive();
                        this.activeList.put((CommentedAlarm)object4.next());
                        alarmNodeManager2.addAlarm(alarmBean);
                        for (Object object3 : this.alarmNumberChangeObservers.values()) {
                            object3.increaseCounter(0);
                        }
                    }
                }
                catch (LaserConsoleException laserConsoleException) {
                    this.lock.release();
                    bl = true;
                    logger.error((Object)laserConsoleException, laserConsoleException.fillInStackTrace());
                    logger.error((Object)laserConsoleException.getRootCause(), laserConsoleException.getRootCause().fillInStackTrace());
                    TraceLogger.log(laserConsoleException.fillInStackTrace());
                    AcWindowManager.notifyError("Alarms can't be uninhibited.\n Request can't be served");
                }
                catch (LaserException laserException) {
                    this.lock.release();
                    bl = true;
                    logger.error((Object)laserException, laserException.fillInStackTrace());
                    logger.error((Object)laserException.getRootCause(), laserException.getRootCause().fillInStackTrace());
                    AcWindowManager.notifyError("AlrmBrowsinHandler can't be found.\nCan't connect to database.");
                }
            }
            finally {
                if (!bl) {
                    this.lock.release();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)interruptedException, interruptedException.fillInStackTrace());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mask(AlarmBean[] alarmBeanArray, Comment comment) {
        boolean bl = false;
        try {
            this.lock.acquire();
            try {
                CommentedAlarm[] commentedAlarmArray = new CommentedAlarm[alarmBeanArray.length];
                for (int i = 0; i < alarmBeanArray.length; ++i) {
                    commentedAlarmArray[i] = alarmBeanArray[i].getCommentedAlarm();
                    commentedAlarmArray[i].setComment(comment);
                }
                CommentedAlarmMap commentedAlarmMap = new CommentedAlarmMap();
                commentedAlarmMap.putAll(this.maskedList);
                for (int i = 0; i < commentedAlarmArray.length; ++i) {
                    commentedAlarmMap.put(commentedAlarmArray[i]);
                }
                try {
                    int n;
                    Configuration configuration = AppRegister.getInstance().getLoadedConfiguration();
                    if (!AppRegister.getInstance().isGuestMode()) {
                        configuration.setMasked(commentedAlarmMap);
                    }
                    CommentedAlarmMap commentedAlarmMap2 = this.getList("MASKED_LIST_LISTENER");
                    for (n = 0; n < commentedAlarmArray.length; ++n) {
                        commentedAlarmMap2.put(commentedAlarmArray[n]);
                    }
                    for (n = 0; n < commentedAlarmArray.length; ++n) {
                        this.activeList.remove(commentedAlarmArray[n].getAlarm().getAlarmId());
                    }
                    AlarmNodeManager alarmNodeManager = this.getAlarmNodeManager("ACTIVE_LIST_LISTENER");
                    AlarmNodeManager alarmNodeManager2 = this.getAlarmNodeManager("MASKED_LIST_LISTENER");
                    for (int i = 0; i < alarmBeanArray.length; ++i) {
                        alarmNodeManager.removeAlarm(alarmBeanArray[i]);
                        AlarmBean alarmBean = alarmBeanArray[i];
                        alarmBean.setIsAlarmNodeMasked(true);
                        alarmNodeManager2.addAlarm(alarmBean);
                        this.updateAlarmNumberChangeListeners(0, 1);
                    }
                }
                catch (LaserConsoleException laserConsoleException) {
                    this.lock.release();
                    bl = true;
                    logger.error((Object)laserConsoleException, laserConsoleException.fillInStackTrace());
                    logger.error((Object)laserConsoleException.getRootCause(), laserConsoleException.getRootCause().fillInStackTrace());
                    TraceLogger.log(laserConsoleException.fillInStackTrace());
                    AcWindowManager.notifyError("Alarm can't be masked.\nInternal error.\nSee log files or contact console developers.");
                }
            }
            finally {
                if (!bl) {
                    this.lock.release();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)interruptedException, interruptedException.fillInStackTrace());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unmask(AlarmBean[] alarmBeanArray) {
        boolean bl = false;
        Configuration configuration = AppRegister.getInstance().getLoadedConfiguration();
        CategorySelection categorySelection = AppRegister.getInstance().getSelection().getCategorySelection();
        ArrayList<AlarmBean> arrayList = new ArrayList<AlarmBean>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        AlarmBrowsingHandler alarmBrowsingHandler = null;
        try {
            this.lock.acquire();
            try {
                CommentedAlarmMap commentedAlarmMap = new CommentedAlarmMap();
                commentedAlarmMap.putAll(this.maskedList);
                try {
                    Object object4;
                    Object object2;
                    int n;
                    alarmBrowsingHandler = AlarmBrowsingHandlerFactory.getHandler();
                    for (n = 0; n < alarmBeanArray.length; ++n) {
                        String string = alarmBeanArray[n].getAlarmId();
                        object2 = commentedAlarmMap.remove(string);
                        object4 = alarmBrowsingHandler.getAlarmById(string);
                        boolean bl2 = false;
                        Collection collection = object4.getCategories();
                        Object object3 = collection.iterator();
                        while (object3.hasNext()) {
                            Category category = (Category)object3.next();
                            if (!categorySelection.contains(category)) continue;
                            bl2 = true;
                            break;
                        }
                        if (!bl2) continue;
                        object2.setAlarm((Alarm)object4);
                        arrayList2.add(object2);
                        arrayList.add(alarmBeanArray[n]);
                    }
                    if (!AppRegister.getInstance().isGuestMode()) {
                        configuration.setInhibited(commentedAlarmMap);
                    }
                    for (n = 0; n < alarmBeanArray.length; ++n) {
                        this.maskedList.remove(alarmBeanArray[n].getAlarmId());
                    }
                    AlarmNodeManager alarmNodeManager = this.getAlarmNodeManager("MASKED_LIST_LISTENER");
                    for (int i = 0; i < alarmBeanArray.length; ++i) {
                        alarmNodeManager.removeAlarm(alarmBeanArray[i]);
                        for (Object object4 : this.alarmNumberChangeObservers.values()) {
                            object4.decreaseCounter(1);
                        }
                    }
                    AlarmNodeManager alarmNodeManager2 = this.getAlarmNodeManager("ACTIVE_LIST_LISTENER");
                    object2 = arrayList.iterator();
                    object4 = arrayList2.iterator();
                    while (object2.hasNext() && object4.hasNext()) {
                        AlarmBean alarmBean = (AlarmBean)object2.next();
                        alarmBean.setIsAlarmNodeActive();
                        this.activeList.put((CommentedAlarm)object4.next());
                        alarmNodeManager2.addAlarm(alarmBean);
                        for (Object object3 : this.alarmNumberChangeObservers.values()) {
                            object3.increaseCounter(0);
                        }
                    }
                }
                catch (LaserConsoleException laserConsoleException) {
                    this.lock.release();
                    bl = true;
                    logger.error((Object)laserConsoleException, laserConsoleException.fillInStackTrace());
                    logger.error((Object)laserConsoleException.getRootCause(), laserConsoleException.getRootCause().fillInStackTrace());
                    TraceLogger.log(laserConsoleException.fillInStackTrace());
                    AcWindowManager.notifyError("Alarms can't be unmasked.\n Request can't be served");
                }
                catch (LaserException laserException) {
                    this.lock.release();
                    bl = true;
                    logger.error((Object)laserException.getMessage(), (Throwable)laserException);
                    logger.error((Object)laserException.getRootCause().getMessage(), laserException.getRootCause());
                    AcWindowManager.notifyError("AlrmBrowsinHandler can't be found.\nCan't connect to database.");
                }
            }
            finally {
                if (!bl) {
                    this.lock.release();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)interruptedException, interruptedException.fillInStackTrace());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void highlightAndKlaxon(AlarmBean[] alarmBeanArray, Comment comment, int n) {
        boolean bl = false;
        try {
            this.lock.acquire();
            try {
                CommentedAlarm[] commentedAlarmArray = new CommentedAlarm[alarmBeanArray.length];
                for (int i = 0; i < alarmBeanArray.length; ++i) {
                    commentedAlarmArray[i] = alarmBeanArray[i].getCommentedAlarm();
                    commentedAlarmArray[i].setComment(comment);
                }
                CommentedAlarmMap commentedAlarmMap = new CommentedAlarmMap();
                commentedAlarmMap.putAll(this.highlightedAndKlaxonList);
                for (int i = 0; i < commentedAlarmArray.length; ++i) {
                    commentedAlarmMap.put(commentedAlarmArray[i]);
                }
                try {
                    Configuration configuration = AppRegister.getInstance().getLoadedConfiguration();
                    if (!AppRegister.getInstance().isGuestMode()) {
                        configuration.setAutoHighlighted(commentedAlarmMap);
                    }
                    CommentedAlarmMap commentedAlarmMap2 = this.getList("AUTO_HIGHLITED_LIST_LISTENER");
                    for (int i = 0; i < commentedAlarmArray.length; ++i) {
                        commentedAlarmMap2.put(commentedAlarmArray[i]);
                    }
                    AlarmNodeManager alarmNodeManager = this.getAlarmNodeManager("AUTO_HIGHLITED_LIST_LISTENER");
                    for (int i = 0; i < alarmBeanArray.length; ++i) {
                        alarmBeanArray[i].setIsAlarmNodeHighlightedAndKlaxon(true);
                        alarmBeanArray[i].setHighlightedOrKlaxon(n);
                        try {
                            AlarmBean alarmBean = (AlarmBean)alarmBeanArray[i].clone();
                            alarmBean.setIsOnHighlightedList(true);
                            alarmBean.registerPropertyChangeListener(alarmBeanArray[i]);
                            alarmBeanArray[i].registerPropertyChangeListener(alarmBean);
                            alarmNodeManager.addAlarm(alarmBean);
                            continue;
                        }
                        catch (CloneNotSupportedException cloneNotSupportedException) {
                            alarmBeanArray[i].setIsAlarmNodeHighlightedAndKlaxon(false);
                            commentedAlarmMap2.remove(alarmBeanArray[i].getAlarmId());
                            logger.error((Object)cloneNotSupportedException, cloneNotSupportedException.fillInStackTrace());
                        }
                    }
                }
                catch (LaserConsoleException laserConsoleException) {
                    this.lock.release();
                    bl = true;
                    logger.error((Object)laserConsoleException, laserConsoleException.fillInStackTrace());
                    logger.error((Object)laserConsoleException.getRootCause(), laserConsoleException.getRootCause().fillInStackTrace());
                    TraceLogger.log(laserConsoleException.fillInStackTrace());
                    AcWindowManager.notifyError("Alarm can't be highlighted and klaxoned.\nInternal error.\nSee log files or contact console developers.");
                }
            }
            finally {
                if (!bl) {
                    this.lock.release();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)interruptedException, interruptedException.fillInStackTrace());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unhighlightAndKlaxon(AlarmBean[] alarmBeanArray) {
        boolean bl = false;
        try {
            this.lock.acquire();
            try {
                CommentedAlarm[] commentedAlarmArray = new CommentedAlarm[alarmBeanArray.length];
                for (int i = 0; i < alarmBeanArray.length; ++i) {
                    commentedAlarmArray[i] = alarmBeanArray[i].getCommentedAlarm();
                }
                CommentedAlarmMap commentedAlarmMap = new CommentedAlarmMap();
                commentedAlarmMap.putAll(this.highlightedAndKlaxonList);
                for (int i = 0; i < commentedAlarmArray.length; ++i) {
                    commentedAlarmMap.remove(commentedAlarmArray[i].getAlarm().getAlarmId());
                }
                try {
                    Configuration configuration = AppRegister.getInstance().getLoadedConfiguration();
                    if (!AppRegister.getInstance().isGuestMode()) {
                        configuration.setAutoHighlighted(commentedAlarmMap);
                    }
                    for (int i = 0; i < commentedAlarmArray.length; ++i) {
                        this.highlightedAndKlaxonList.remove(commentedAlarmArray[i].getAlarm().getAlarmId());
                    }
                    AlarmNodeManager alarmNodeManager = this.getAlarmNodeManager("AUTO_HIGHLITED_LIST_LISTENER");
                    AlarmBean alarmBean = null;
                    for (int i = 0; i < alarmBeanArray.length; ++i) {
                        alarmBean = alarmBeanArray[i];
                        if (alarmBean.isOnHighlightedList()) {
                            alarmBean.setIsAlarmNodeHighlightedAndKlaxon(false);
                        } else {
                            alarmBean.setIsAlarmNodeHighlightedAndKlaxon(false);
                        }
                        alarmNodeManager.removeAlarm(alarmBean);
                    }
                }
                catch (LaserConsoleException laserConsoleException) {
                    this.lock.release();
                    bl = true;
                    logger.error((Object)laserConsoleException, laserConsoleException.fillInStackTrace());
                    logger.error((Object)laserConsoleException.getRootCause(), laserConsoleException.getRootCause().fillInStackTrace());
                    TraceLogger.log(laserConsoleException.fillInStackTrace());
                    AcWindowManager.notifyError("Alarm can't be unhighlighted.\nInternal error.\nSee log files or contact console developers.");
                }
            }
            finally {
                if (!bl) {
                    this.lock.release();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)interruptedException, interruptedException.fillInStackTrace());
        }
    }

    public void highlight(AlarmBean[] alarmBeanArray, boolean bl) {
        int n;
        CommentedAlarmMap commentedAlarmMap = new CommentedAlarmMap();
        commentedAlarmMap.putAll(this.highlightedList);
        if (bl) {
            for (n = 0; n < alarmBeanArray.length; ++n) {
                commentedAlarmMap.put(alarmBeanArray[n].getCommentedAlarm());
            }
        } else {
            for (n = 0; n < alarmBeanArray.length; ++n) {
                commentedAlarmMap.remove(alarmBeanArray[n].getAlarmId());
            }
        }
        Configuration configuration = AppRegister.getInstance().getLoadedConfiguration();
        try {
            if (!AppRegister.getInstance().isGuestMode()) {
                configuration.setHighlighted(commentedAlarmMap);
            }
            if (bl) {
                for (int i = 0; i < alarmBeanArray.length; ++i) {
                    alarmBeanArray[i].setIsAlarmNodeHighlighted(bl);
                    this.highlightedList.put(alarmBeanArray[i].getCommentedAlarm());
                }
            } else {
                for (int i = 0; i < alarmBeanArray.length; ++i) {
                    alarmBeanArray[i].setIsAlarmNodeHighlighted(bl);
                    this.highlightedList.remove(alarmBeanArray[i].getAlarmId());
                }
            }
        }
        catch (LaserConsoleException laserConsoleException) {
            logger.error((Object)laserConsoleException, laserConsoleException.fillInStackTrace());
            logger.error((Object)laserConsoleException.getRootCause(), laserConsoleException.getRootCause().fillInStackTrace());
            TraceLogger.log(laserConsoleException.fillInStackTrace());
            AcWindowManager.notifyError("Alarms can't be highlighted");
        }
    }

    public void acknowledge(AlarmBean[] alarmBeanArray, boolean bl, Comment comment) {
        if (bl) {
            this.acknowledge(alarmBeanArray, comment);
        } else {
            this.unacknowledge(alarmBeanArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acknowledge(AlarmBean[] alarmBeanArray, Comment comment) {
        boolean bl = false;
        ArrayList<AlarmBean> arrayList = new ArrayList<AlarmBean>();
        ArrayList<AlarmBean> arrayList2 = new ArrayList<AlarmBean>();
        try {
            this.lock.acquire();
            try {
                for (int i = 0; i < alarmBeanArray.length; ++i) {
                    if (alarmBeanArray[i].isActive()) {
                        alarmBeanArray[i].getCommentedAlarm().setComment(comment);
                        arrayList2.add(alarmBeanArray[i]);
                        continue;
                    }
                    arrayList.add(alarmBeanArray[i]);
                }
                CommentedAlarmMap commentedAlarmMap = new CommentedAlarmMap();
                commentedAlarmMap.putAll(this.acknowledgedList);
                Configuration configuration = arrayList2.iterator();
                while (configuration.hasNext()) {
                    commentedAlarmMap.put(((AlarmBean)configuration.next()).getCommentedAlarm());
                }
                try {
                    AlarmBean alarmBean;
                    int n;
                    configuration = AppRegister.getInstance().getLoadedConfiguration();
                    if (!AppRegister.getInstance().isGuestMode()) {
                        configuration.setAcknowledged(commentedAlarmMap);
                    }
                    AlarmNodeManager alarmNodeManager = this.getAlarmNodeManager("ACTIVE_LIST_LISTENER");
                    for (n = 0; n < arrayList.size(); ++n) {
                        alarmBean = (AlarmBean)arrayList.get(n);
                        this.activeList.remove(alarmBean.getAlarmId());
                        alarmNodeManager.removeAlarm(alarmBean);
                        this.updateAlarmNoChangeListeners(0);
                    }
                    for (n = 0; n < arrayList2.size(); ++n) {
                        alarmBean = (AlarmBean)arrayList2.get(n);
                        this.acknowledgedList.put(alarmBean.getCommentedAlarm());
                        alarmBean.setIsAlarmNodeAcknowledged(true);
                    }
                }
                catch (LaserConsoleException laserConsoleException) {
                    this.lock.release();
                    bl = true;
                    logger.error((Object)laserConsoleException, laserConsoleException.fillInStackTrace());
                    logger.error((Object)laserConsoleException.getRootCause(), laserConsoleException.getRootCause().fillInStackTrace());
                    TraceLogger.log(laserConsoleException.fillInStackTrace());
                    AcWindowManager.notifyError("Alarms can't be acknowledged.\nInternal error.\nSee log files or contact console developers.");
                }
            }
            finally {
                if (!bl) {
                    this.lock.release();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)interruptedException, interruptedException.fillInStackTrace());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unacknowledge(AlarmBean[] alarmBeanArray) {
        boolean bl = false;
        try {
            this.lock.acquire();
            try {
                CommentedAlarmMap commentedAlarmMap = new CommentedAlarmMap();
                commentedAlarmMap.putAll(this.acknowledgedList);
                for (int i = 0; i < alarmBeanArray.length; ++i) {
                    commentedAlarmMap.remove(alarmBeanArray[i].getAlarmId());
                }
                try {
                    int n;
                    Configuration configuration = AppRegister.getInstance().getLoadedConfiguration();
                    if (!AppRegister.getInstance().isGuestMode()) {
                        configuration.setAcknowledged(commentedAlarmMap);
                    }
                    for (n = 0; n < alarmBeanArray.length; ++n) {
                        this.acknowledgedList.remove(alarmBeanArray[n].getAlarmId());
                    }
                    for (n = 0; n < alarmBeanArray.length; ++n) {
                        alarmBeanArray[n].setIsAlarmNodeAcknowledged(false);
                    }
                }
                catch (LaserConsoleException laserConsoleException) {
                    this.lock.release();
                    bl = true;
                    logger.error((Object)laserConsoleException, laserConsoleException.fillInStackTrace());
                    logger.error((Object)laserConsoleException.getRootCause(), laserConsoleException.getRootCause().fillInStackTrace());
                    TraceLogger.log(laserConsoleException.fillInStackTrace());
                    AcWindowManager.notifyError("Alarm can't be unhighlighted.\nInternal error.\nSee log files or contact console developers.");
                }
            }
            finally {
                if (!bl) {
                    this.lock.release();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)interruptedException, interruptedException.fillInStackTrace());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNewOrTerminatedAlarms(String string) {
        boolean bl = false;
        int n = string.equals("NEW") ? 1 : 2;
        String string2 = "ACTIVE_LIST_LISTENER";
        AlarmNodeManager alarmNodeManager = this.getAlarmNodeManager(string2);
        Collection collection = this.activeList.values();
        CommentedAlarmMap commentedAlarmMap = this.activeList;
        synchronized (commentedAlarmMap) {
            logger.debug((Object)"remove all new indicators inside synchronized block iter.remove()");
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                CommentedAlarm commentedAlarm = (CommentedAlarm)iterator.next();
                AlarmBean alarmBean = alarmNodeManager.getAlarm(commentedAlarm.getAlarm().getAlarmId());
                switch (n) {
                    case 1: {
                        bl = alarmBean.isNew();
                        break;
                    }
                    case 2: {
                        boolean bl2 = bl = !alarmBean.isActive();
                    }
                }
                if (bl) {
                    iterator.remove();
                    alarmNodeManager.removeAlarm(alarmBean);
                    for (AlarmsNumberChangeListener alarmsNumberChangeListener : this.alarmNumberChangeObservers.values()) {
                        alarmsNumberChangeListener.decreaseCounter(0);
                    }
                }
                bl = false;
            }
        }
    }

    public void makeAlarmNotNew() {
        AlarmNodeManager alarmNodeManager = this.getAlarmNodeManager("ACTIVE_LIST_LISTENER");
        alarmNodeManager.makeAlarmsNotNew();
    }

    public void fireFontChanged() {
        for (AlarmNodeManager alarmNodeManager : this.nodeManagers.values()) {
            if (alarmNodeManager == null) continue;
            alarmNodeManager.fireFontChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearInhibitList() {
        boolean bl = AppRegister.getInstance().getBehaviour().isAlarmAutoTerminated();
        Configuration configuration = AppRegister.getInstance().getLoadedConfiguration();
        CategorySelection categorySelection = AppRegister.getInstance().getSelection().getCategorySelection();
        String string = "INHIBIT_LIST_LISTENER";
        String string2 = "ACTIVE_LIST_LISTENER";
        AlarmNodeManager alarmNodeManager = this.getAlarmNodeManager(string2);
        AlarmNodeManager alarmNodeManager2 = this.getAlarmNodeManager(string);
        try {
            this.lock.acquire();
            try {
                Iterator iterator = this.inhibitList.values().iterator();
                while (iterator.hasNext()) {
                    CommentedAlarm commentedAlarm = (CommentedAlarm)iterator.next();
                    logger.debug((Object)("commAlarm=" + commentedAlarm));
                    Alarm alarm = commentedAlarm.getAlarm();
                    logger.debug((Object)("alarm=" + alarm));
                    iterator.remove();
                    AlarmBean alarmBean = alarmNodeManager2.getAlarm(commentedAlarm.getAlarm().getAlarmId());
                    logger.debug((Object)("alarmBean=" + alarmBean));
                    alarmNodeManager2.removeAlarm(alarmBean);
                    logger.debug((Object)"after manager.removeAlarm");
                    alarmBean.setIsAlarmNodeActive();
                    logger.debug((Object)("alarmBean=" + alarmBean));
                    if (alarm.getStatus().isActive() || !alarm.getStatus().isActive() && !bl) {
                        boolean bl2 = false;
                        Object object = commentedAlarm.getAlarm().getCategories();
                        Iterator iterator2 = object.iterator();
                        while (iterator2.hasNext()) {
                            Category category = (Category)iterator2.next();
                            if (!categorySelection.contains(category)) continue;
                            bl2 = true;
                            break;
                        }
                        if (!bl2) continue;
                        this.activeList.put(commentedAlarm);
                        alarmNodeManager.addAlarm(alarmBean);
                        this.updateAlarmNumberChangeListeners(2, 0);
                        continue;
                    }
                    for (Object object : this.alarmNumberChangeObservers.values()) {
                        object.decreaseCounter(2);
                    }
                }
            }
            finally {
                this.lock.release();
            }
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)interruptedException, interruptedException.fillInStackTrace());
        }
        try {
            configuration.setInhibited(this.inhibitList);
        }
        catch (LaserConsoleException laserConsoleException) {
            logger.error((Object)laserConsoleException, laserConsoleException.fillInStackTrace());
            logger.error((Object)laserConsoleException.getRootCause(), laserConsoleException.getRootCause().fillInStackTrace());
            TraceLogger.log(laserConsoleException.fillInStackTrace());
            AcWindowManager.notifyError("New inhibit list can't be persisted.");
        }
    }

    public void clearSearchList() {
        AlarmNodeManager alarmNodeManager = this.getAlarmNodeManager("SEARCH_LISTENER_KEY");
        alarmNodeManager.removeAllAlarms();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMaskList() {
        boolean bl = AppRegister.getInstance().getBehaviour().isAlarmAutoTerminated();
        Configuration configuration = AppRegister.getInstance().getLoadedConfiguration();
        CategorySelection categorySelection = AppRegister.getInstance().getSelection().getCategorySelection();
        String string = "MASKED_LIST_LISTENER";
        String string2 = "ACTIVE_LIST_LISTENER";
        AlarmNodeManager alarmNodeManager = this.getAlarmNodeManager(string2);
        AlarmNodeManager alarmNodeManager2 = this.getAlarmNodeManager(string);
        try {
            this.lock.acquire();
            try {
                Iterator iterator = this.maskedList.values().iterator();
                while (iterator.hasNext()) {
                    CommentedAlarm commentedAlarm = (CommentedAlarm)iterator.next();
                    Alarm alarm = commentedAlarm.getAlarm();
                    iterator.remove();
                    AlarmBean alarmBean = alarmNodeManager2.getAlarm(commentedAlarm.getAlarm().getAlarmId());
                    alarmNodeManager2.removeAlarm(alarmBean);
                    alarmBean.setIsAlarmNodeActive();
                    if (alarm.getStatus().isActive()) {
                        boolean bl2 = false;
                        Object object = commentedAlarm.getAlarm().getCategories();
                        Iterator iterator2 = object.iterator();
                        while (iterator2.hasNext()) {
                            Category category = (Category)iterator2.next();
                            if (!categorySelection.contains(category)) continue;
                            bl2 = true;
                            break;
                        }
                        if (!bl2) continue;
                        this.activeList.put(commentedAlarm);
                        alarmNodeManager.addAlarm(alarmBean);
                        this.updateAlarmNumberChangeListeners(1, 0);
                        continue;
                    }
                    for (Object object : this.alarmNumberChangeObservers.values()) {
                        object.decreaseCounter(1);
                    }
                }
            }
            finally {
                this.lock.release();
            }
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)interruptedException, interruptedException.fillInStackTrace());
        }
        try {
            configuration.setMasked(this.maskedList);
        }
        catch (LaserConsoleException laserConsoleException) {
            logger.error((Object)laserConsoleException, laserConsoleException.fillInStackTrace());
            logger.error((Object)laserConsoleException.getRootCause(), laserConsoleException.getRootCause().fillInStackTrace());
            TraceLogger.log(laserConsoleException.fillInStackTrace());
            AcWindowManager.notifyError("New mask list can't be persisted.\nTry do it later.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAutoHighlightedList() {
        Configuration configuration = AppRegister.getInstance().getLoadedConfiguration();
        String string = "AUTO_HIGHLITED_LIST_LISTENER";
        String string2 = "ACTIVE_LIST_LISTENER";
        AlarmNodeManager alarmNodeManager = this.getAlarmNodeManager(string2);
        AlarmNodeManager alarmNodeManager2 = this.getAlarmNodeManager(string);
        CommentedAlarmMap commentedAlarmMap = this.highlightedAndKlaxonList;
        synchronized (commentedAlarmMap) {
            Iterator iterator = this.highlightedAndKlaxonList.values().iterator();
            while (iterator.hasNext()) {
                CommentedAlarm commentedAlarm = (CommentedAlarm)iterator.next();
                iterator.remove();
                AlarmBean alarmBean = alarmNodeManager2.getAlarm(commentedAlarm.getAlarm().getAlarmId());
                alarmBean.setIsAlarmNodeHighlightedAndKlaxon(false);
                alarmNodeManager2.removeAlarm(alarmBean);
            }
        }
        try {
            configuration.setAutoHighlighted(this.highlightedAndKlaxonList);
        }
        catch (LaserConsoleException laserConsoleException) {
            logger.error((Object)laserConsoleException, laserConsoleException.fillInStackTrace());
            logger.error((Object)laserConsoleException.getRootCause(), laserConsoleException.getRootCause().fillInStackTrace());
            TraceLogger.log(laserConsoleException.fillInStackTrace());
            AcWindowManager.notifyError("New mask list can't be persisted.");
        }
    }

    private void updateAlarmNumberChangeListeners(int n, int n2) {
        Collection collection = this.alarmNumberChangeObservers.values();
        for (AlarmsNumberChangeListener alarmsNumberChangeListener : collection) {
            alarmsNumberChangeListener.moveAlarmNumber(n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAlarm(Alarm alarm) {
        String string = alarm.getAlarmId();
        String string2 = alarm.getTriplet().getFaultFamily();
        String string3 = alarm.getTriplet().getFaultMember();
        Integer n = alarm.getTriplet().getFaultCode();
        try {
            this.lock.acquire();
            try {
                if (this.inhibitList.containsKey(string)) {
                    this.updateAlarmOnInhibitList(alarm);
                } else if (this.maskedList.containsKey(string)) {
                    this.updateAlarmMaskedOnList(alarm);
                } else if (alarm.isInstant()) {
                    this.updateAlarmOnInstantList(alarm);
                } else if (this.activeList.containsKey(string)) {
                    this.updateAlarmOnActiveList(alarm);
                } else {
                    this.addAlarmToActiveList(alarm);
                }
            }
            finally {
                this.lock.release();
            }
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)interruptedException, interruptedException.fillInStackTrace());
        }
    }

    public void onException(LaserSelectionException laserSelectionException) {
        Iterator iterator = this.onExceptionListeners.iterator();
        while (iterator.hasNext()) {
            ((AlarmSelectionOnExceptionListener)iterator.next()).onException(laserSelectionException.getCode());
        }
    }

    private void updateAlarmOnInstantList(Alarm alarm) {
        CommentedAlarm commentedAlarm = null;
        commentedAlarm = this.instantList.get(alarm.getAlarmId());
        if (commentedAlarm == null) {
            commentedAlarm = new CommentedAlarm(alarm, null);
            this.instantList.put(commentedAlarm);
            AlarmNodeManager alarmNodeManager = this.getAlarmNodeManager("INSTANT_LIST_LISTENER");
            alarmNodeManager.addAlarm(new AlarmBean(commentedAlarm));
        } else {
            commentedAlarm.setAlarm(alarm);
            AlarmNodeManager alarmNodeManager = this.getAlarmNodeManager("INSTANT_LIST_LISTENER");
            AlarmBean alarmBean = alarmNodeManager.getAlarm(alarm.getAlarmId());
            alarmBean.setCommentedAlarm(commentedAlarm);
        }
    }

    private void updateAlarmOnActiveList(Alarm alarm) {
        String string = alarm.getTriplet().getFaultFamily();
        String string2 = alarm.getTriplet().getFaultMember();
        Integer n = alarm.getTriplet().getFaultCode();
        logger.debug((Object)("updateAlarmOnActiveList(" + string + " " + string2 + " " + n + ")"));
        Behaviour behaviour = AppRegister.getInstance().getBehaviour();
        if (alarm.getStatus().isActive() || !alarm.getStatus().isActive() && !behaviour.isAlarmAutoTerminated() && !this.acknowledgedList.containsKey(alarm.getAlarmId())) {
            CommentedAlarm commentedAlarm = this.activeList.get(alarm.getAlarmId());
            commentedAlarm.setAlarm(alarm);
            AlarmNodeManager alarmNodeManager = this.getAlarmNodeManager("ACTIVE_LIST_LISTENER");
            AlarmBean alarmBean = alarmNodeManager.getAlarm(alarm.getAlarmId());
            alarmBean.setCommentedAlarm(commentedAlarm);
        } else if (behaviour.isAlarmAutoTerminated()) {
            this.activeList.remove(alarm.getAlarmId());
            AlarmNodeManager alarmNodeManager = this.getAlarmNodeManager("ACTIVE_LIST_LISTENER");
            alarmNodeManager.removeAlarm(alarm.getAlarmId());
            this.updateAlarmNoChangeListeners(0);
        } else if (this.acknowledgedList.containsKey(alarm.getAlarmId())) {
            this.activeList.remove(alarm.getAlarmId());
            AlarmNodeManager alarmNodeManager = this.getAlarmNodeManager("ACTIVE_LIST_LISTENER");
            alarmNodeManager.removeAlarm(alarm.getAlarmId());
            this.updateAlarmNoChangeListeners(0);
            this.acknowledgedList.remove(alarm.getAlarmId());
        }
    }

    private void updateAlarmOnInhibitList(Alarm alarm) {
    }

    private void updateAlarmMaskedOnList(Alarm alarm) {
        if (!alarm.getStatus().isActive()) {
            try {
                CommentedAlarm commentedAlarm = this.maskedList.remove(alarm.getAlarmId());
                AlarmNodeManager alarmNodeManager = this.getAlarmNodeManager("MASKED_LIST_LISTENER");
                alarmNodeManager.removeAlarm(alarm.getAlarmId());
                CommentedAlarmMap commentedAlarmMap = AppRegister.getInstance().getLoadedConfiguration().getMasked();
                commentedAlarmMap.remove(commentedAlarm.getAlarm().getAlarmId());
                AppRegister.getInstance().getLoadedConfiguration().setMasked(commentedAlarmMap);
                for (AlarmsNumberChangeListener alarmsNumberChangeListener : this.alarmNumberChangeObservers.values()) {
                    alarmsNumberChangeListener.decreaseCounter(1);
                }
            }
            catch (LaserConsoleException laserConsoleException) {
                logger.error((Object)laserConsoleException, laserConsoleException.fillInStackTrace());
                logger.error((Object)laserConsoleException.getRootCause(), laserConsoleException.getRootCause().fillInStackTrace());
                TraceLogger.log(laserConsoleException.fillInStackTrace());
                AcWindowManager.notifyError("New mask list can't be persisted.");
            }
        }
    }

    private void addAlarmToActiveList(Alarm alarm) {
        Object object;
        CommentedAlarm commentedAlarm;
        Object object2;
        String string = alarm.getTriplet().getFaultFamily();
        String string2 = alarm.getTriplet().getFaultMember();
        Integer n = alarm.getTriplet().getFaultCode();
        logger.debug((Object)("addAlarmToActiveList(" + string + " " + string2 + " " + n + ")"));
        Behaviour behaviour = AppRegister.getInstance().getBehaviour();
        if (!alarm.getStatus().isActive() && behaviour.isAlarmAutoTerminated()) {
            return;
        }
        CommentedAlarm commentedAlarm2 = new CommentedAlarm(alarm, null);
        this.activeList.put(commentedAlarm2);
        AlarmListener alarmListener = (AlarmListener)this.observers.get("ACTIVE_LIST_LISTENER");
        if (alarmListener != null) {
            object2 = new AlarmBean(commentedAlarm2);
            commentedAlarm = null;
            commentedAlarm = this.highlightedAndKlaxonList.get(alarm.getAlarmId());
            if (commentedAlarm != null) {
                ((AlarmBean)object2).setIsAlarmNodeHighlightedAndKlaxon(true);
                object = this.getAlarmNodeManager("AUTO_HIGHLITED_LIST_LISTENER").getAlarm(alarm.getAlarmId());
                if (object != null) {
                    ((AlarmBean)object).registerPropertyChangeListener((PropertyChangeListener)object2);
                }
            }
            alarmListener.addAlarm((AlarmBean)object2);
        }
        object2 = this.alarmNumberChangeObservers.values();
        commentedAlarm = object2.iterator();
        while (commentedAlarm.hasNext()) {
            object = (AlarmsNumberChangeListener)commentedAlarm.next();
            object.increaseCounter(0);
        }
    }

    private void updateAlarmNoChangeListeners(int n) {
        for (AlarmsNumberChangeListener alarmsNumberChangeListener : this.alarmNumberChangeObservers.values()) {
            alarmsNumberChangeListener.decreaseCounter(n);
        }
    }

    private boolean belongsToSelectedCategories(AlarmBean alarmBean, CategorySelection categorySelection) {
        Collection collection = alarmBean.getCategories();
        for (Category category : collection) {
            logger.debug((Object)("reload container: category=" + category));
            if (!categorySelection.contains(category)) continue;
            logger.debug((Object)("reload container: alarm on current selection (alarm cat=" + category + "/selected cat=" + categorySelection + ")"));
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNewIndicator(AlarmBean[] alarmBeanArray) {
        boolean bl = false;
        try {
            this.lock.acquire();
            try {
                CommentedAlarmMap commentedAlarmMap = new CommentedAlarmMap();
                for (int i = 0; i < alarmBeanArray.length; ++i) {
                    if (alarmBeanArray[i] == null) continue;
                    commentedAlarmMap.put(alarmBeanArray[i].getCommentedAlarm());
                }
                try {
                    Configuration configuration = AppRegister.getInstance().getLoadedConfiguration();
                    if (!AppRegister.getInstance().isGuestMode()) {
                        logger.debug((Object)("status not new persisted, alarms=" + commentedAlarmMap));
                        configuration.setNewIndicator(commentedAlarmMap);
                    }
                }
                catch (LaserConsoleException laserConsoleException) {
                    this.lock.release();
                    bl = true;
                    logger.error((Object)laserConsoleException, laserConsoleException.fillInStackTrace());
                    logger.error((Object)laserConsoleException.getRootCause(), laserConsoleException.getRootCause().fillInStackTrace());
                    TraceLogger.log(laserConsoleException.fillInStackTrace());
                    AcWindowManager.notifyError("New indicator cannot be persisted.\nInternal error.\nSee log files or contact console developers.");
                }
            }
            finally {
                if (!bl) {
                    this.lock.release();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)interruptedException, interruptedException.fillInStackTrace());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActiveListFont(boolean bl) {
        boolean bl2 = false;
        try {
            this.lock.acquire();
            try {
                Configuration configuration = AppRegister.getInstance().getLoadedConfiguration();
                if (!AppRegister.getInstance().isGuestMode()) {
                    logger.debug((Object)("font size persisted, isBig=" + bl));
                    configuration.setActiveListFont(new Boolean(bl));
                    logger.debug((Object)("font size stored as:" + configuration.getActiveListFont()));
                }
            }
            catch (LaserConsoleException laserConsoleException) {
                this.lock.release();
                bl2 = true;
                logger.error((Object)laserConsoleException, laserConsoleException.fillInStackTrace());
                logger.error((Object)laserConsoleException.getRootCause(), laserConsoleException.getRootCause().fillInStackTrace());
                TraceLogger.log(laserConsoleException.fillInStackTrace());
                AcWindowManager.notifyError("Font Size cannot be persisted.\nInternal error.\nSee log files or contact console developers.");
            }
            finally {
                if (!bl2) {
                    this.lock.release();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)interruptedException, interruptedException.fillInStackTrace());
        }
    }

    public boolean isSearchCancelled() {
        return false;
    }

    public void onSearchAlarm(Alarm alarm) {
        AlarmNodeManager alarmNodeManager = this.getAlarmNodeManager("SEARCH_LISTENER_KEY");
        CommentedAlarm commentedAlarm = new CommentedAlarm(alarm, null);
        AlarmBean alarmBean = new AlarmBean(commentedAlarm);
        alarmNodeManager.addAlarm(alarmBean);
    }

    public void onSearchException(LaserSearchException laserSearchException) {
    }

    public void searchFinished() {
    }
}

