/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.alarms;

import cern.laser.guiplatform.actions.TestAction;
import cern.laser.guiplatform.alarms.AlarmBean;
import cern.laser.guiplatform.util.LogFactory;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.apache.log4j.Logger;
import org.openide.nodes.BeanNode;
import org.openide.nodes.Children;
import org.openide.util.actions.SystemAction;

public class AlarmBeanNode
extends BeanNode
implements PropertyChangeListener,
Comparable {
    private static final Logger logger = LogFactory.getLogger(AlarmBeanNode.class.getName());

    public AlarmBeanNode(Object object) throws IntrospectionException {
        super(object);
        this.registerPropertyChangeListener(object);
    }

    public AlarmBeanNode(Object object, Children children) throws IntrospectionException {
        super(object, children);
        this.registerPropertyChangeListener(object);
    }

    public SystemAction[] createActions() {
        try {
            AlarmBean alarmBean = (AlarmBean)this.getBean();
            return alarmBean.getActions();
        }
        catch (ClassCastException classCastException) {
            return new SystemAction[]{SystemAction.get(TestAction.class)};
        }
    }

    public String getName() {
        try {
            AlarmBean alarmBean = (AlarmBean)this.getBean();
            if (!this.isLeaf()) {
                return "Alarm";
            }
            return alarmBean.getDisplayName();
        }
        catch (ClassCastException classCastException) {
            return "Alarm";
        }
    }

    public Object getBean() {
        return super.getBean();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("name")) {
            super.fireNameChange(null, (String)propertyChangeEvent.getNewValue());
        } else {
            super.firePropertyChange(null, null, null);
        }
    }

    private void registerPropertyChangeListener(Object object) {
        try {
            ((AlarmBean)object).registerPropertyChangeListener(this);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public int compareTo(Object object) {
        AlarmBeanNode alarmBeanNode = (AlarmBeanNode)object;
        return ((AlarmBean)alarmBeanNode.getBean()).compareTo((AlarmBean)this.getBean());
    }
}

