/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.alarms;

import cern.laser.client.LaserException;
import cern.laser.client.data.Alarm;
import cern.laser.client.data.Location;
import cern.laser.client.data.ResponsiblePerson;
import cern.laser.client.data.Source;
import cern.laser.client.data.Triplet;
import cern.laser.client.services.browsing.AlarmBrowsingHandler;
import cern.laser.console.CommentedAlarm;
import cern.laser.guiplatform.actions.alarms.AcknowledgeAction;
import cern.laser.guiplatform.actions.alarms.DetailsAction;
import cern.laser.guiplatform.actions.alarms.HighlightAction;
import cern.laser.guiplatform.actions.alarms.HighlightedAndKlaxonAction;
import cern.laser.guiplatform.actions.alarms.InhibitAction;
import cern.laser.guiplatform.actions.alarms.MaskAction;
import cern.laser.guiplatform.actions.alarms.ShowActiveMultiplicityChildrenAction;
import cern.laser.guiplatform.actions.alarms.ShowActiveNodeChildrenAction;
import cern.laser.guiplatform.actions.alarms.ShowHelpUrlInBrowserAction;
import cern.laser.guiplatform.actions.alarms.ShowMultiplicityChildrenAction;
import cern.laser.guiplatform.actions.alarms.ShowNodeChildrenAction;
import cern.laser.guiplatform.actions.alarms.ShowTimestampsAction;
import cern.laser.guiplatform.actions.alarms.UnacknowledgeAction;
import cern.laser.guiplatform.actions.alarms.UnhighlightAction;
import cern.laser.guiplatform.actions.alarms.UnhighlightedAndKlaxonAction;
import cern.laser.guiplatform.actions.alarms.UninhibitAction;
import cern.laser.guiplatform.actions.alarms.UnmaskAction;
import cern.laser.guiplatform.alarms.AlarmBrowsingHandlerFactory;
import cern.laser.guiplatform.util.AppRegister;
import cern.laser.guiplatform.util.DateTimeUtils;
import cern.laser.guiplatform.util.LabelValueBean;
import cern.laser.guiplatform.util.LogFactory;
import cern.laser.guiplatform.windowmanager.AcWindowManager;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;

public class AlarmBean
implements PropertyChangeListener,
Cloneable,
Comparable {
    private static final Logger LOGGER = LogFactory.getLogger(AlarmBean.class.getName());
    protected String consoleTimeStamp = null;
    protected PropertyChangeListener propertyListener = null;
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);
    private static String[] NODE_ACTIONS = new String[]{UnacknowledgeAction.class.getName(), AcknowledgeAction.class.getName(), null, HighlightAction.class.getName(), UnhighlightAction.class.getName(), null, InhibitAction.class.getName(), UninhibitAction.class.getName(), null, MaskAction.class.getName(), UnmaskAction.class.getName(), null, HighlightedAndKlaxonAction.class.getName(), UnhighlightedAndKlaxonAction.class.getName(), null, DetailsAction.class.getName(), null, ShowTimestampsAction.class.getName(), null, ShowMultiplicityChildrenAction.class.getName(), ShowNodeChildrenAction.class.getName(), null, ShowHelpUrlInBrowserAction.class.getName()};
    protected String[] nodeActions = null;
    protected static final String[] INSTANT_NODE_ACTIONS = new String[]{DetailsAction.class.getName()};
    protected String[] instantNodeActions = null;
    protected static final String DEFAULT_ACTION_NAME = null;
    protected String defaultActionName = null;
    protected Color foregroundColor = Color.black;
    protected Color backgroundColor = new Color(70, 92, 113);
    protected boolean isAlarmNodeActive = true;
    protected boolean isAlarmNodeInhibited = false;
    protected boolean isAlarmNodeMasked = false;
    protected boolean isAlarmNodeHighlighted = false;
    protected boolean isAlarmNodeHighlightedAndKlaxon = false;
    protected boolean isAlarmNodeAcknowledged = false;
    protected int highlitedOrKlaxonOrBoth = 10;
    protected boolean isAlarmNodeInstant = false;
    protected boolean isNew = true;
    protected boolean infoMode = false;
    protected boolean isOnHighlightedList = false;
    protected CommentedAlarm commentedAlarm = null;

    public AlarmBean(CommentedAlarm commentedAlarm) {
        this.consoleTimeStamp = DateTimeUtils.getCurrentTimestamp();
        this.commentedAlarm = commentedAlarm;
        this.changeBackgroundForeground();
        this.nodeActions = NODE_ACTIONS;
        this.instantNodeActions = INSTANT_NODE_ACTIONS;
        this.defaultActionName = DEFAULT_ACTION_NAME;
    }

    public AlarmBean() {
        this.consoleTimeStamp = "";
    }

    public CommentedAlarm getCommentedAlarm() {
        return this.commentedAlarm;
    }

    public void setCommentedAlarm(CommentedAlarm commentedAlarm) {
        this.consoleTimeStamp = DateTimeUtils.getCurrentTimestamp();
        this.commentedAlarm = commentedAlarm;
        this.changeBackgroundForeground();
        this.changes.firePropertyChange("name", null, this.getName());
    }

    public boolean isAlarmNodeActive() {
        return this.isAlarmNodeActive;
    }

    public void setIsAlarmNodeActive() {
        this.isAlarmNodeActive = true;
        this.isAlarmNodeInstant = !this.isAlarmNodeActive;
        this.isAlarmNodeMasked = this.isAlarmNodeInstant;
        this.isAlarmNodeInhibited = this.isAlarmNodeInstant;
        this.changeBackgroundForeground();
    }

    public boolean isAlarmNodeInhibited() {
        return this.isAlarmNodeInhibited;
    }

    public void setIsAlarmNodeInhibited(boolean bl) {
        this.isAlarmNodeInhibited = bl;
        if (bl) {
            this.isAlarmNodeInstant = !this.isAlarmNodeInhibited;
            this.isAlarmNodeActive = this.isAlarmNodeInstant;
            this.isAlarmNodeMasked = this.isAlarmNodeInstant;
        } else {
            this.setIsAlarmNodeActive();
        }
        this.changeBackgroundForeground();
    }

    public boolean isAlarmNodeMasked() {
        return this.isAlarmNodeMasked;
    }

    public void setIsAlarmNodeMasked(boolean bl) {
        this.isAlarmNodeMasked = bl;
        if (bl) {
            this.isAlarmNodeInstant = !this.isAlarmNodeMasked;
            this.isAlarmNodeActive = this.isAlarmNodeInstant;
            this.isAlarmNodeInhibited = this.isAlarmNodeInstant;
        } else {
            this.setIsAlarmNodeActive();
        }
        this.changeBackgroundForeground();
    }

    public boolean isAlarmNodeHighlighted() {
        return this.isAlarmNodeHighlighted;
    }

    public void setIsAlarmNodeHighlighted(boolean bl) {
        this.isAlarmNodeHighlighted = bl;
        this.changeBackgroundForeground();
        this.changes.firePropertyChange("isAlarmNodeHighlighted", null, new Boolean(bl));
    }

    public boolean isAlarmNodeHighlightedAndKlaxon() {
        return this.isAlarmNodeHighlightedAndKlaxon;
    }

    public void setIsAlarmNodeHighlightedAndKlaxon(boolean bl) {
        this.isAlarmNodeHighlightedAndKlaxon = bl;
        this.changeBackgroundForeground();
        this.changes.firePropertyChange("isAlarmNodeHighlightedAndKlaxon", null, new Boolean(bl));
    }

    public int getHighlightedOrKlaxon() {
        return this.highlitedOrKlaxonOrBoth;
    }

    public void setHighlightedOrKlaxon(int n) {
        this.highlitedOrKlaxonOrBoth = n;
        this.changeBackgroundForeground();
    }

    public void setIsAlarmNodeAcknowledged(boolean bl) {
        LOGGER.debug((Object)("setIsAlarmNodeAcknowledged: " + bl));
        this.isAlarmNodeAcknowledged = bl;
        this.changeBackgroundForeground();
        this.changes.firePropertyChange("isAlarmNodeAcknowledged", null, new Boolean(bl));
    }

    public boolean isAlarmNodeAcknowledged() {
        return this.isAlarmNodeAcknowledged;
    }

    public boolean isAlarmNodeInstant() {
        return this.isAlarmNodeInstant;
    }

    public void setIsAlarmNodeInstant(boolean bl) {
        this.isAlarmNodeInstant = bl;
        if (bl) {
            this.isAlarmNodeMasked = !this.isAlarmNodeInstant;
            this.isAlarmNodeActive = this.isAlarmNodeMasked;
            this.isAlarmNodeInhibited = this.isAlarmNodeMasked;
        } else {
            this.setIsAlarmNodeActive();
        }
    }

    public boolean isOnHighlightedList() {
        return this.isOnHighlightedList;
    }

    public void setIsOnHighlightedList(boolean bl) {
        this.isOnHighlightedList = bl;
        this.changeBackgroundForeground();
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setIsNew(boolean bl) {
        this.isNew = bl;
        this.changeBackgroundForeground();
        this.changes.firePropertyChange("nodeIcon", null, this.getNodeIcon());
    }

    public void setInfoMode(boolean bl) {
        this.infoMode = bl;
    }

    public boolean infoMode() {
        return this.infoMode;
    }

    public String getAlarmId() {
        return this.commentedAlarm.getAlarm().getAlarmId();
    }

    public Integer getPriority() {
        return this.commentedAlarm.getAlarm().getPriority();
    }

    public Collection getCategories() {
        return this.commentedAlarm.getAlarm().getCategories();
    }

    public ResponsiblePerson getResponsiblePerson() {
        return this.commentedAlarm.getAlarm().getResponsiblePerson();
    }

    public Location getLocation() {
        return this.commentedAlarm.getAlarm().getLocation();
    }

    public String getProblemDescription() {
        return this.getPrefix() + " " + this.commentedAlarm.getAlarm().getProblemDescription() + " " + this.getSuffix();
    }

    public Source getSource() {
        return this.commentedAlarm.getAlarm().getSource();
    }

    public String getSourceName() {
        return this.commentedAlarm.getAlarm().getSource().getName();
    }

    public String getFaultFamily() {
        return this.commentedAlarm.getAlarm().getTriplet().getFaultFamily();
    }

    public String getFaultMember() {
        return this.commentedAlarm.getAlarm().getTriplet().getFaultMember();
    }

    public Integer getFaultCode() {
        return this.commentedAlarm.getAlarm().getTriplet().getFaultCode();
    }

    public String getTimestamp() {
        return this.commentedAlarm.getAlarm().getStatus().getSystemTimestamp().toString();
    }

    public String getSourceTimestamp() {
        return this.commentedAlarm.getAlarm().getStatus().getSourceTimestamp().toString();
    }

    public String getUserTimestamp() {
        return this.commentedAlarm.getAlarm().getStatus().getUserTimestamp().toString();
    }

    public Timestamp getTimestampForSorting() {
        return this.commentedAlarm.getAlarm().getStatus().getUserTimestamp();
    }

    public String getSourceHostName() {
        return this.commentedAlarm.getAlarm().getStatus().getSourceHostname();
    }

    public String getUserData() {
        return this.commentedAlarm.getAlarm().getStatus().getUserProperties().toString();
    }

    public String getIdentifier() {
        return this.commentedAlarm.getAlarm().getIdentifier();
    }

    public String getSystemName() {
        return this.commentedAlarm.getAlarm().getSystemName();
    }

    public boolean isActive() {
        boolean bl = true;
        boolean bl2 = false;
        if (AppRegister.getInstance().getSelection() != null) {
            bl2 = AppRegister.getInstance().getSelection().getReducedMaskedSelection();
        }
        boolean bl3 = this.commentedAlarm.getAlarm().getStatus().isMasked();
        boolean bl4 = this.commentedAlarm.getAlarm().getStatus().isReduced();
        boolean bl5 = this.commentedAlarm.getAlarm().getStatus().isActive();
        if (bl5) {
            if (bl2 && (bl3 || bl4)) {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean getIsActive() {
        return this.isActive();
    }

    public boolean isMasked() {
        return this.commentedAlarm.getAlarm().getStatus().isMasked();
    }

    public boolean isNodeChild() {
        return this.commentedAlarm.getAlarm().isNodeChild();
    }

    public boolean isNodeParent() {
        return this.commentedAlarm.getAlarm().isNodeParent();
    }

    public boolean isNodeReduced() {
        return this.commentedAlarm.getAlarm().getStatus().isReduced();
    }

    public boolean isMultiplicityParent() {
        return this.commentedAlarm.getAlarm().isMultiplicityParent();
    }

    public boolean isMultiplicityChild() {
        return this.commentedAlarm.getAlarm().isMultiplicityChild();
    }

    public boolean isReduced() {
        return this.commentedAlarm.getAlarm().getStatus().isReduced();
    }

    public List getTimestamps() {
        ArrayList<LabelValueBean> arrayList = new ArrayList<LabelValueBean>();
        arrayList.add(new LabelValueBean(NbBundle.getMessage(AlarmBean.class, (String)"ALARM_USER_TIMESTAMP_dispaly_name"), this.commentedAlarm.getAlarm().getStatus().getUserTimestamp().toString()));
        arrayList.add(new LabelValueBean(NbBundle.getMessage(AlarmBean.class, (String)"ALARM_API_TIMESTAMP_dispaly_name"), this.commentedAlarm.getAlarm().getStatus().getSourceTimestamp().toString()));
        arrayList.add(new LabelValueBean(NbBundle.getMessage(AlarmBean.class, (String)"ALARM_BUSINESS_LAYER_TIMESTAMP_dispaly_name"), this.commentedAlarm.getAlarm().getStatus().getSystemTimestamp().toString()));
        arrayList.add(new LabelValueBean(NbBundle.getMessage(AlarmBean.class, (String)"ALARM_CONSOLE_TIMESTAMP_dispaly_name"), this.consoleTimeStamp));
        LOGGER.debug((Object)("User=" + this.commentedAlarm.getAlarm().getStatus().getUserTimestamp().toString() + " nanos=" + this.commentedAlarm.getAlarm().getStatus().getUserTimestamp().getNanos()));
        LOGGER.debug((Object)("Source=" + this.commentedAlarm.getAlarm().getStatus().getSourceTimestamp().toString() + " nanos=" + this.commentedAlarm.getAlarm().getStatus().getSourceTimestamp().getNanos()));
        LOGGER.debug((Object)("System=" + this.commentedAlarm.getAlarm().getStatus().getSystemTimestamp().toString() + " nanos=" + this.commentedAlarm.getAlarm().getStatus().getSystemTimestamp().getNanos()));
        return arrayList;
    }

    public List getDynamicInfo(boolean bl) {
        ArrayList<LabelValueBean> arrayList = new ArrayList<LabelValueBean>();
        arrayList.add(new LabelValueBean(NbBundle.getMessage(AlarmBean.class, (String)"ALARM_ACTIVE_dispaly_name"), this.commentedAlarm.getAlarm().getStatus().isActive() ? "Yes" : "No"));
        this.addToList(arrayList, "Source hostname", this.commentedAlarm.getAlarm().getStatus().getSourceHostname(), bl);
        Properties properties = this.commentedAlarm.getAlarm().getStatus().getUserProperties();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.addToList(arrayList, string, (String)properties.get(string), bl);
        }
        return arrayList;
    }

    public List getStaticInfo(boolean bl) {
        ArrayList<LabelValueBean> arrayList = new ArrayList<LabelValueBean>();
        String string = null;
        URL uRL = null;
        arrayList.add(new LabelValueBean(NbBundle.getMessage(AlarmBean.class, (String)"ALARM_FAULT_FAMILY_dispaly_name"), this.getFaultFamily()));
        arrayList.add(new LabelValueBean(NbBundle.getMessage(AlarmBean.class, (String)"ALARM_FAULT_MEMBER_dispaly_name"), this.getFaultMember()));
        arrayList.add(new LabelValueBean(NbBundle.getMessage(AlarmBean.class, (String)"ALARM_FAULT_CODE_dispaly_name"), this.getFaultCode().toString()));
        arrayList.add(new LabelValueBean(NbBundle.getMessage(AlarmBean.class, (String)"ALARM_PROBLEM_DESC_dispaly_name"), this.commentedAlarm.getAlarm().getProblemDescription()));
        arrayList.add(new LabelValueBean(NbBundle.getMessage(AlarmBean.class, (String)"ALARM_PRIORITY_dispaly_name"), this.commentedAlarm.getAlarm().getPriority().toString()));
        arrayList.add(new LabelValueBean(NbBundle.getMessage(AlarmBean.class, (String)"ALARM_ACTION_TO_BE_TAKEN_dispaly_name"), this.commentedAlarm.getAlarm().getAction()));
        arrayList.add(new LabelValueBean(NbBundle.getMessage(AlarmBean.class, (String)"ALARM_CAUSE_OF_THE_PROBLEM_dispaly_name"), this.commentedAlarm.getAlarm().getCause()));
        arrayList.add(new LabelValueBean(NbBundle.getMessage(AlarmBean.class, (String)"ALARM_CONSEQUENCES_OF_THE_PROBLEM_dispaly_name"), this.commentedAlarm.getAlarm().getConsequence()));
        uRL = this.commentedAlarm.getAlarm().getHelpURL();
        string = uRL == null ? "" : uRL.toExternalForm();
        this.addToList(arrayList, NbBundle.getMessage(AlarmBean.class, (String)"ALARM_HELP_TEXT_URL_dispaly_name"), string, bl);
        this.addToList(arrayList, NbBundle.getMessage(AlarmBean.class, (String)"ALARM_PIQUET_GSM_DETAILS_dispaly_name"), this.commentedAlarm.getAlarm().getPiquetGSM() == null ? "" : this.commentedAlarm.getAlarm().getPiquetGSM(), bl);
        this.addToList(arrayList, NbBundle.getMessage(AlarmBean.class, (String)"ALARM_PIQUET_EMAIL_dispaly_name"), this.commentedAlarm.getAlarm().getPiquetEmail() == null ? "" : this.commentedAlarm.getAlarm().getPiquetEmail(), bl);
        arrayList.add(new LabelValueBean(NbBundle.getMessage(AlarmBean.class, (String)"ALARM_SITE_dispaly_name"), this.commentedAlarm.getAlarm().getLocation().getSite()));
        arrayList.add(new LabelValueBean(NbBundle.getMessage(AlarmBean.class, (String)"ALARM_BUILDING_NUMBER_dispaly_name"), this.commentedAlarm.getAlarm().getLocation().getBuilding()));
        this.addToList(arrayList, NbBundle.getMessage(AlarmBean.class, (String)"ALARM_BUILDING_MNEMONIC_dispaly_name"), this.commentedAlarm.getAlarm().getLocation().getMnemonic() == null ? "" : this.commentedAlarm.getAlarm().getLocation().getMnemonic(), bl);
        this.addToList(arrayList, NbBundle.getMessage(AlarmBean.class, (String)"ALARM_FLOOR_dispaly_name"), this.checkIfNull(this.commentedAlarm.getAlarm().getLocation().getFloor()), bl);
        this.addToList(arrayList, NbBundle.getMessage(AlarmBean.class, (String)"ALARM_ROOM_dispaly_name"), this.checkIfNull(this.commentedAlarm.getAlarm().getLocation().getRoom()), bl);
        this.addToList(arrayList, NbBundle.getMessage(AlarmBean.class, (String)"ALARM_POSITION_dispaly_name"), this.commentedAlarm.getAlarm().getLocation().getPosition() != null ? this.commentedAlarm.getAlarm().getLocation().getPosition() : "", bl);
        this.addToList(arrayList, NbBundle.getMessage(AlarmBean.class, (String)"ALARM_MAP_REFERENCE_dispaly_name"), this.commentedAlarm.getAlarm().getLocation().getMap() != null ? this.commentedAlarm.getAlarm().getLocation().getMap() : "", bl);
        this.addToList(arrayList, NbBundle.getMessage(AlarmBean.class, (String)"ALARM_SAFETY_ZONE_dispaly_name"), this.commentedAlarm.getAlarm().getLocation().getZone() != null ? this.commentedAlarm.getAlarm().getLocation().getZone().toString() : "", bl);
        this.addToList(arrayList, NbBundle.getMessage(AlarmBean.class, (String)"ALARM_RESPONSIBLE_PERSON_dispaly_name"), this.commentedAlarm.getAlarm().getResponsiblePerson().getFirstName() + this.commentedAlarm.getAlarm().getResponsiblePerson().getFamilyName(), bl);
        this.addToList(arrayList, NbBundle.getMessage(AlarmBean.class, (String)"ALARM_RESPONSIBLE_PERSON_GSM_DETAILS_dispaly_name"), this.checkIfNull(this.commentedAlarm.getAlarm().getResponsiblePerson().getGsmNumber()), bl);
        this.addToList(arrayList, NbBundle.getMessage(AlarmBean.class, (String)"ALARM_RESPONSIBLE_PERSON_PHONE_NUMBER_dispaly_name"), this.checkIfNull(this.commentedAlarm.getAlarm().getResponsiblePerson().getPhoneNumber()), bl);
        this.addToList(arrayList, NbBundle.getMessage(AlarmBean.class, (String)"ALARM_RESPONSIBLE_PERSON_EMAIL_CONTACT_dispaly_name"), this.checkIfNull(this.commentedAlarm.getAlarm().getResponsiblePerson().getEMail()), bl);
        arrayList.add(new LabelValueBean(NbBundle.getMessage(AlarmBean.class, (String)"ALARM_SOURCE_NAME_dispaly_name"), this.commentedAlarm.getAlarm().getSource().getName()));
        this.addToList(arrayList, NbBundle.getMessage(AlarmBean.class, (String)"ALARM_SOURCE_DESC_dispaly_name"), this.commentedAlarm.getAlarm().getSource().getDescription() == null ? "" : this.commentedAlarm.getAlarm().getSource().getDescription(), bl);
        ResponsiblePerson responsiblePerson = this.commentedAlarm.getAlarm().getSource().getResponsiblePerson();
        String string2 = null;
        string2 = responsiblePerson != null ? responsiblePerson.getFirstName() + responsiblePerson.getFamilyName() : "";
        this.addToList(arrayList, NbBundle.getMessage(AlarmBean.class, (String)"ALARM_SOURCE_RESPONSIBLE_PERSON_dispaly_name"), string2, bl);
        return arrayList;
    }

    private void addToList(List list, String string, String string2, boolean bl) {
        if (string2.length() > 0 || string2.length() == 0 && bl) {
            list.add(new LabelValueBean(string, string2));
        }
    }

    public String getName() {
        if (this.isAlarmNodeActive && !this.isOnHighlightedList) {
            return "";
        }
        Triplet triplet = this.commentedAlarm.getAlarm().getTriplet();
        return triplet.getFaultFamily() + " " + triplet.getFaultMember() + " " + triplet.getFaultCode();
    }

    public String getDisplayName() {
        return this.getName();
    }

    public String getDate() {
        String string = this.getUserTimestamp().substring(5, 10);
        String[] stringArray = string.split("-");
        if (stringArray.length == 2) {
            return stringArray[1] + "/" + stringArray[0];
        }
        return string.replace('-', '/');
    }

    public String getTime() {
        return this.getUserTimestamp().substring(11, 19);
    }

    public String getNodeDefaultAction() {
        return this.defaultActionName;
    }

    public Image getNewIcon() {
        Image image = null;
        switch (this.getPriority()) {
            case 0: {
                image = Utilities.loadImage((String)"cern/laser/guiplatform/images/alarm_gray24_24new.gif");
                break;
            }
            case 1: {
                image = Utilities.loadImage((String)"cern/laser/guiplatform/images/alarm_blue24_24new.gif");
                break;
            }
            case 2: {
                image = Utilities.loadImage((String)"cern/laser/guiplatform/images/alarm_yellow24_24new.gif");
                break;
            }
            case 3: {
                image = Utilities.loadImage((String)"cern/laser/guiplatform/images/alarm_red24_24new.gif");
            }
        }
        if (this.isNew()) {
            return image;
        }
        return null;
    }

    public Image getNodeIcon() {
        return this.getNodeIcon(false);
    }

    public Image getNodeIcon(boolean bl) {
        Image image = null;
        switch (this.getPriority()) {
            case 0: {
                if (bl) {
                    image = this.prepareIcon("cern/laser/guiplatform/images/alarm_gray24_24new.gif", "cern/laser/guiplatform/images/alarm_gray24_24sel.gif");
                    break;
                }
                image = this.prepareIcon("cern/laser/guiplatform/images/alarm_gray24_24new.gif", "cern/laser/guiplatform/images/alarm_24_24unselected.gif");
                break;
            }
            case 1: {
                if (bl) {
                    image = this.prepareIcon("cern/laser/guiplatform/images/alarm_blue24_24new.gif", "cern/laser/guiplatform/images/alarm_blue24_24sel.gif");
                    break;
                }
                image = this.prepareIcon("cern/laser/guiplatform/images/alarm_blue24_24new.gif", "cern/laser/guiplatform/images/alarm_24_24unselected.gif");
                break;
            }
            case 2: {
                if (bl) {
                    image = this.prepareIcon("cern/laser/guiplatform/images/alarm_yellow24_24new.gif", "cern/laser/guiplatform/images/alarm_yellow24_24sel.gif");
                    break;
                }
                image = this.prepareIcon("cern/laser/guiplatform/images/alarm_yellow24_24new.gif", "cern/laser/guiplatform/images/alarm_24_24unselected.gif");
                break;
            }
            case 3: {
                image = bl ? this.prepareIcon("cern/laser/guiplatform/images/alarm_red24_24new.gif", "cern/laser/guiplatform/images/alarm_red24_24sel.gif") : this.prepareIcon("cern/laser/guiplatform/images/alarm_red24_24new.gif", "cern/laser/guiplatform/images/alarm_24_24unselected.gif");
            }
        }
        return image;
    }

    private Image prepareIcon(String string, String string2) {
        Image image = null;
        if (this.commentedAlarm.getAlarm().isInstant() || this.isOnHighlightedList || this.isAlarmNodeInhibited || this.isAlarmNodeMasked || this.infoMode) {
            image = Utilities.loadImage((String)string2);
        } else {
            image = Utilities.loadImage((String)string2);
            if (this.getCommentedAlarm().getAlarm().getHelpURL() != null) {
                image = Utilities.mergeImages((Image)image, (Image)Utilities.loadImage((String)"cern/laser/guiplatform/images/url.gif"), (int)16, (int)0);
            }
            image = Utilities.mergeImages((Image)image, (Image)Utilities.loadImage((String)"cern/laser/guiplatform/images/empty_icon.png"), (int)16, (int)0);
            image = this.commentedAlarm.getAlarm().isMultiplicityParent() || this.commentedAlarm.getAlarm().isNodeParent() ? Utilities.mergeImages((Image)Utilities.loadImage((String)"cern/laser/guiplatform/images/multiplicity_icon.png"), (Image)image, (int)16, (int)0) : Utilities.mergeImages((Image)Utilities.loadImage((String)"cern/laser/guiplatform/images/empty_icon.png"), (Image)image, (int)16, (int)0);
        }
        return image;
    }

    public String[] getNodeActions() {
        if (!this.commentedAlarm.getAlarm().isInstant()) {
            return this.nodeActions;
        }
        return this.instantNodeActions;
    }

    public Color getBackgroundColor() {
        if (!this.isOnHighlightedList && (this.isAlarmNodeHighlighted() || this.isAlarmNodeHighlightedAndKlaxon() && this.getHighlightedOrKlaxon() == 10 || this.getHighlightedOrKlaxon() == 30)) {
            return this.foregroundColor;
        }
        return this.backgroundColor;
    }

    public Color getForegroundColor() {
        if (!this.isOnHighlightedList && (this.isAlarmNodeHighlighted() || this.isAlarmNodeHighlightedAndKlaxon() && this.getHighlightedOrKlaxon() == 10 || this.getHighlightedOrKlaxon() == 30)) {
            return this.backgroundColor;
        }
        return this.foregroundColor;
    }

    public Font getFont() {
        int n = 0;
        if (this.isAlarmNodeAcknowledged()) {
            n |= 2;
        }
        if (this.isMultiplicityParent() || this.isNodeParent()) {
            n |= 1;
        }
        return new Font(AppRegister.getInstance().getFontName(), n, AppRegister.getInstance().getFontSize());
    }

    private void changeBackgroundForeground() {
        if (this.isActive() || this.isOnHighlightedList || this.isAlarmNodeMasked || this.isAlarmNodeInhibited) {
            switch (this.getPriority()) {
                case 0: {
                    if (this.isAlarmNodeAcknowledged()) {
                        this.foregroundColor = new Color(177, 177, 177);
                        break;
                    }
                    this.foregroundColor = new Color(229, 229, 229);
                    break;
                }
                case 1: {
                    if (this.isAlarmNodeAcknowledged()) {
                        this.foregroundColor = new Color(0, 176, 176);
                        break;
                    }
                    this.foregroundColor = new Color(0, 255, 255);
                    break;
                }
                case 2: {
                    if (this.isAlarmNodeAcknowledged()) {
                        this.foregroundColor = new Color(193, 193, 0);
                        break;
                    }
                    this.foregroundColor = new Color(255, 255, 0);
                    break;
                }
                case 3: {
                    this.foregroundColor = this.isAlarmNodeAcknowledged() ? new Color(200, 91, 91) : new Color(255, 106, 106);
                }
            }
        } else {
            this.foregroundColor = new Color(33, 138, 33);
        }
    }

    private String getPrefix() {
        return this.commentedAlarm.getAlarm().getStatus().getUserProperties().getProperty("ASI_PREFIX") == null ? "" : this.commentedAlarm.getAlarm().getStatus().getUserProperties().getProperty("ASI_PREFIX");
    }

    private String getSuffix() {
        return this.commentedAlarm.getAlarm().getStatus().getUserProperties().getProperty("ASI_SUFFIX") == null ? "" : this.commentedAlarm.getAlarm().getStatus().getUserProperties().getProperty("ASI_SUFFIX");
    }

    public void details() {
        AcWindowManager.setStatusText("Show details for: " + this.getName() + " is running ....");
        AlarmBrowsingHandler alarmBrowsingHandler = null;
        try {
            alarmBrowsingHandler = AlarmBrowsingHandlerFactory.getHandler();
            Alarm alarm = alarmBrowsingHandler.getAlarmById(this.getAlarmId());
            AcWindowManager.showDetails(new AlarmBean(new CommentedAlarm(alarm, null)));
        }
        catch (LaserException laserException) {
            LOGGER.error((Object)laserException, laserException.fillInStackTrace());
            LOGGER.error((Object)laserException.getRootCause(), laserException.getRootCause().fillInStackTrace());
            AcWindowManager.notifyError("AlrmBrowsinHandler can't be found.\nCan't connect to database.");
        }
        AcWindowManager.setStatusText("Show details for: " + this.getName() + " finished");
    }

    public Object clone() throws CloneNotSupportedException {
        AlarmBean alarmBean = (AlarmBean)super.clone();
        alarmBean.commentedAlarm = (CommentedAlarm)this.commentedAlarm.clone();
        return alarmBean;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        LOGGER.debug((Object)(this.getName() + " propertyChange()"));
        LOGGER.debug((Object)("propertyName: " + propertyChangeEvent.getPropertyName()));
        if (propertyChangeEvent.getPropertyName().equals("isAlarmNodeHighlightedAndKlaxon")) {
            this.isAlarmNodeHighlightedAndKlaxon = (Boolean)propertyChangeEvent.getNewValue();
        } else if (propertyChangeEvent.getPropertyName().equals("isAlarmNodeHighlighted")) {
            this.isAlarmNodeHighlighted = (Boolean)propertyChangeEvent.getNewValue();
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof AlarmBean)) {
            return false;
        }
        AlarmBean alarmBean = (AlarmBean)object;
        return this.getAlarmId().equals(alarmBean.getAlarmId());
    }

    public int hashCode() {
        if (this.commentedAlarm != null && this.commentedAlarm.getAlarm() != null) {
            return this.commentedAlarm.getAlarm().hashCode();
        }
        return 0;
    }

    public void registerPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.propertyListener != null) {
            this.removePropertyChangeListener(this.propertyListener);
        }
        this.propertyListener = propertyChangeListener;
        this.addPropertyChangeListener(this.propertyListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    public String checkIfNull(String string) {
        return string == null ? "" : string;
    }

    public SystemAction[] getActions() {
        SystemAction[] systemActionArray = new SystemAction[]{SystemAction.get(UnacknowledgeAction.class), SystemAction.get(AcknowledgeAction.class), SystemAction.get(HighlightAction.class), SystemAction.get(UnhighlightAction.class), SystemAction.get(InhibitAction.class), SystemAction.get(UninhibitAction.class), SystemAction.get(MaskAction.class), SystemAction.get(UnmaskAction.class), SystemAction.get(HighlightedAndKlaxonAction.class), SystemAction.get(UnhighlightedAndKlaxonAction.class), SystemAction.get(DetailsAction.class), SystemAction.get(ShowTimestampsAction.class), SystemAction.get(ShowMultiplicityChildrenAction.class), SystemAction.get(ShowActiveMultiplicityChildrenAction.class), SystemAction.get(ShowNodeChildrenAction.class), SystemAction.get(ShowActiveNodeChildrenAction.class), SystemAction.get(ShowHelpUrlInBrowserAction.class)};
        return systemActionArray;
    }

    public int compareTo(Object object) {
        AlarmBean alarmBean = (AlarmBean)object;
        int n = alarmBean.getPriority().compareTo(this.getPriority());
        if (n == 0) {
            int n2 = alarmBean.getTimestampForSorting().compareTo(this.getTimestampForSorting());
            if (n2 == 0) {
                return alarmBean.getAlarmId().compareTo(this.getAlarmId());
            }
            return n2;
        }
        return n;
    }

    public void fireFontChanged() {
        this.changes.firePropertyChange("fontChanged", null, null);
    }

    public Color getStandardBackgroundColor() {
        return this.backgroundColor;
    }

    public Color getStandardForegroundColor() {
        return this.foregroundColor;
    }
}

