/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.actions.configuration;

import cern.gp.actions.support.NodeAction;
import cern.gp.nodes.GPNode;
import cern.laser.client.LaserException;
import cern.laser.console.Configuration;
import cern.laser.console.LaserConsoleException;
import cern.laser.console.User;
import cern.laser.guiplatform.configuration.ConfigurationBean;
import cern.laser.guiplatform.user.UserHandlerFactory;
import cern.laser.guiplatform.util.LogFactory;
import cern.laser.guiplatform.windowmanager.AcWindowManager;
import cern.laser.guiplatform.windows.configuration.ConsoleConfigurationWindow;
import java.beans.IntrospectionException;
import org.apache.log4j.Logger;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class ConfigurationLoadAction
extends NodeAction {
    static final Logger logger = LogFactory.getLogger(ConfigurationLoadAction.class.getName());
    private static final String loadStr = NbBundle.getMessage(ConfigurationLoadAction.class, (String)"LBL_ConfigurationLoadAction_name");

    public String getName() {
        return loadStr;
    }

    protected String iconResource() {
        return "org/openide/resources/actions/save.gif";
    }

    protected void performAction(GPNode[] gPNodeArray) {
        String string = gPNodeArray[0].getPeerNode().getParentNode().getName();
        String string2 = gPNodeArray[0].getName();
        try {
            User user = UserHandlerFactory.getHandler().getUser(string);
            Configuration configuration = user.getConfiguration(string2);
            TopComponent.Registry registry = TopComponent.getRegistry();
            ConsoleConfigurationWindow consoleConfigurationWindow = (ConsoleConfigurationWindow)registry.getActivated();
            if (consoleConfigurationWindow == null) {
                throw new NullPointerException("Configuratrion window not found");
            }
            try {
                consoleConfigurationWindow.updateConfigurationPanel(configuration, string);
                consoleConfigurationWindow.updateCategoryTreeExplorer();
            }
            catch (IntrospectionException introspectionException) {
                introspectionException.printStackTrace();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
            }
        }
        catch (LaserConsoleException laserConsoleException) {
            logger.error((Object)laserConsoleException, laserConsoleException.fillInStackTrace());
            AcWindowManager.notifyError("Internal error.\nSee log files or contact console developers.");
        }
        catch (LaserException laserException) {
            logger.error((Object)laserException, laserException.fillInStackTrace());
            AcWindowManager.notifyError("Internal error.\nSee log files or contact console developers.");
        }
    }

    protected boolean enable(Node[] nodeArray) {
        logger.debug((Object)" enable ");
        if (nodeArray.length > 0) {
            logger.debug((Object)nodeArray[0].getClass().toString());
            logger.debug((Object)("configuration cookie: " + nodeArray[0].getCookie(Configuration.class)));
            logger.debug((Object)("configuration bean cookie: " + nodeArray[0].getCookie(ConfigurationBean.class)));
        }
        return nodeArray.length == 1 && ((GPNode)nodeArray[0]).getBean() instanceof ConfigurationBean && super.enable(nodeArray);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}

