/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.actions.configuration;

import cern.gp.actions.support.NodeAction;
import cern.gp.nodes.GPNode;
import cern.laser.console.LaserConsoleException;
import cern.laser.console.User;
import cern.laser.guiplatform.util.AppRegister;
import cern.laser.guiplatform.util.LogFactory;
import cern.laser.guiplatform.windows.configuration.ConsoleConfigurationWindow;
import org.apache.log4j.Logger;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class ConfigurationDeleteAction
extends NodeAction {
    static final Logger logger = LogFactory.getLogger(ConfigurationDeleteAction.class.getName());
    private static final String deleteStr = NbBundle.getMessage(ConfigurationDeleteAction.class, (String)"LBL_ConfigurationDeleteAction_name");

    public String getName() {
        return deleteStr;
    }

    protected String iconResource() {
        return "org/openide/resources/actions/delete.gif";
    }

    protected void performAction(GPNode[] gPNodeArray) {
        User user = AppRegister.getInstance().getRegisteredUser();
        TopComponent.Registry registry = TopComponent.getRegistry();
        ConsoleConfigurationWindow consoleConfigurationWindow = (ConsoleConfigurationWindow)registry.getActivated();
        if (consoleConfigurationWindow == null) {
            throw new NullPointerException("Configuratrion window not found");
        }
        try {
            for (int i = 0; i < gPNodeArray.length; ++i) {
                user.removeConfiguration(gPNodeArray[i].getName());
                consoleConfigurationWindow.removeConfiguration(gPNodeArray[i]);
            }
        }
        catch (LaserConsoleException laserConsoleException) {
            logger.error((Object)laserConsoleException);
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)("This configuraion cannot be deleted" + laserConsoleException.toString()), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        }
    }

    protected boolean enable(Node[] nodeArray) {
        boolean bl = true;
        boolean bl2 = false;
        for (int i = 0; i < nodeArray.length; ++i) {
            Node node = nodeArray[i].getParentNode();
            if (node == null) continue;
            try {
                if (!node.getName().equals(AppRegister.getInstance().getRegisteredUser().getName())) {
                    bl = false;
                }
                if (!nodeArray[i].getName().equals(AppRegister.getInstance().getLoadedConfiguration().getName())) continue;
                bl2 = true;
                continue;
            }
            catch (LaserConsoleException laserConsoleException) {
                logger.error((Object)laserConsoleException);
            }
        }
        return bl && !bl2 && super.enable(nodeArray);
    }
}

