/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.actions.category;

import cern.gp.actions.support.NodeAction;
import cern.gp.nodes.GPNode;
import cern.laser.guiplatform.util.LogFactory;
import cern.laser.guiplatform.windows.configuration.ConsoleConfigurationWindow;
import cern.laser.guiplatform.windows.search.CategorySelectorWindow;
import java.beans.IntrospectionException;
import org.apache.log4j.Logger;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class AddSubCategoriesAction
extends NodeAction {
    protected static final Logger logger = LogFactory.getLogger(AddSubCategoriesAction.class.getName());
    private static final String label = NbBundle.getMessage(AddSubCategoriesAction.class, (String)"LBL_AddSubCategoriesAction_name");

    protected void performAction(GPNode[] gPNodeArray) {
        TopComponent.Registry registry = TopComponent.getRegistry();
        if (registry.getActivated() instanceof ConsoleConfigurationWindow) {
            ConsoleConfigurationWindow consoleConfigurationWindow = (ConsoleConfigurationWindow)registry.getActivated();
            logger.debug((Object)("confWindow=" + (Object)((Object)consoleConfigurationWindow)));
            if (consoleConfigurationWindow == null) {
                throw new NullPointerException("Configuratrion window not found");
            }
            for (int i = 0; i < gPNodeArray.length; ++i) {
                try {
                    GPNode gPNode = gPNodeArray[i];
                    consoleConfigurationWindow.addSubCategories(gPNode);
                    consoleConfigurationWindow.updateCategoryTreeExplorer();
                    continue;
                }
                catch (IntrospectionException introspectionException) {
                    introspectionException.printStackTrace();
                    continue;
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    cloneNotSupportedException.printStackTrace();
                }
            }
        } else if (registry.getActivated() instanceof CategorySelectorWindow) {
            CategorySelectorWindow categorySelectorWindow = (CategorySelectorWindow)registry.getActivated();
            logger.debug((Object)("selectionWindow=" + (Object)((Object)categorySelectorWindow)));
            if (categorySelectorWindow == null) {
                throw new NullPointerException("Configuratrion window not found");
            }
            for (int i = 0; i < gPNodeArray.length; ++i) {
                try {
                    GPNode gPNode = gPNodeArray[i];
                    categorySelectorWindow.addSubCategories(gPNode);
                    categorySelectorWindow.updateCategoryTreeExplorer();
                    continue;
                }
                catch (IntrospectionException introspectionException) {
                    introspectionException.printStackTrace();
                    continue;
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    cloneNotSupportedException.printStackTrace();
                }
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    protected boolean enable(Node[] nodeArray) {
        return super.enable(nodeArray);
    }

    public String getName() {
        return label;
    }

    protected String iconResource() {
        return "org/openide/resources/actions/saveAll.gif";
    }
}

