/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.actions.alarms;

import cern.gp.nodes.GPNode;
import cern.laser.client.LaserException;
import cern.laser.client.data.Alarm;
import cern.laser.client.services.reduction.AlarmReductionHandler;
import cern.laser.console.CommentedAlarm;
import cern.laser.guiplatform.actions.alarms.ShowNodeChildrenAction;
import cern.laser.guiplatform.alarms.AlarmBean;
import cern.laser.guiplatform.alarms.AlarmBeanNode;
import cern.laser.guiplatform.alarms.AlarmReductionHandlerFactory;
import cern.laser.guiplatform.alarms.InfoAlarmBean;
import cern.laser.guiplatform.util.Constants;
import cern.laser.guiplatform.util.LogFactory;
import cern.laser.guiplatform.windowmanager.AcWindowManager;
import cern.laser.guiplatform.windows.alarms.AlarmInfoExplorer;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.openide.windows.TopComponent;

public class ShowActiveNodeChildrenAction
extends NodeAction {
    private static final Logger logger = LogFactory.getLogger(ShowNodeChildrenAction.class.getName());

    protected void performAction(Node[] nodeArray) {
        AcWindowManager.setStatusText("Show active node children action is running .......");
        AlarmBean alarmBean = (AlarmBean)((AlarmBeanNode)nodeArray[0]).getBean();
        AlarmReductionHandler alarmReductionHandler = null;
        AlarmInfoExplorer alarmInfoExplorer = null;
        ArrayList<InfoAlarmBean> arrayList = new ArrayList<InfoAlarmBean>();
        try {
            alarmReductionHandler = AlarmReductionHandlerFactory.getHandler();
            Collection collection = alarmReductionHandler.getActiveNodeChildren(alarmBean.getAlarmId());
            GPNode[] gPNodeArray = new GPNode[collection.size()];
            boolean bl = false;
            for (Alarm alarm : collection) {
                CommentedAlarm commentedAlarm = new CommentedAlarm(alarm, null);
                InfoAlarmBean infoAlarmBean = new InfoAlarmBean(commentedAlarm);
                infoAlarmBean.setInfoMode(true);
                arrayList.add(infoAlarmBean);
            }
            TopComponent topComponent = AcWindowManager.findTopComponent(NbBundle.getMessage(AlarmInfoExplorer.class, (String)"LBL_AlarmInfoExplorer_component_name"));
            if (topComponent != null) {
                alarmInfoExplorer = (AlarmInfoExplorer)topComponent;
                alarmInfoExplorer.update(arrayList, alarmBean.getFaultFamily() + " active node children");
                logger.debug((Object)"expl found");
            } else {
                logger.debug((Object)"expl not found");
                alarmInfoExplorer = new AlarmInfoExplorer(arrayList, alarmBean.getFaultFamily() + " node children", Constants.getColumnsToDisplay());
                alarmInfoExplorer.open();
            }
            alarmInfoExplorer.requestFocus();
        }
        catch (LaserException laserException) {
            logger.error((Object)laserException.getMessage(), (Throwable)laserException);
            logger.error((Object)laserException.getRootCause().getMessage(), laserException.getRootCause());
            AcWindowManager.notifyError("Can't display alarms.\nAlrmReductionHandler can't be found.\nCan't connect to database.");
        }
        AcWindowManager.setStatusText("Show active node children action finished");
    }

    protected boolean enable(Node[] nodeArray) {
        return nodeArray.length == 1 && this.checkBean(nodeArray[0]);
    }

    public String getName() {
        return NbBundle.getMessage(ShowActiveNodeChildrenAction.class, (String)"LBL_ShowActiveNodeChildrenAction_action_name");
    }

    protected String iconResource() {
        return null;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    private boolean checkBean(Node node) {
        boolean bl = false;
        Node.Cookie cookie = null;
        cookie = node.getCookie(AlarmBean.class);
        if (cookie != null && ((AlarmBean)cookie).isNodeParent()) {
            bl = true;
        }
        return bl;
    }
}

