/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.actions.alarms;

import cern.laser.console.Comment;
import cern.laser.guiplatform.alarms.AlarmBean;
import cern.laser.guiplatform.alarms.AlarmBeanNode;
import cern.laser.guiplatform.alarms.AlarmContainer;
import cern.laser.guiplatform.util.AppRegister;
import cern.laser.guiplatform.util.LogFactory;
import cern.laser.guiplatform.windowmanager.AcWindowManager;
import cern.laser.guiplatform.windows.alarms.AlarmCommentPanel;
import org.apache.log4j.Logger;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class AcknowledgeAction
extends NodeAction {
    private static final String name = NbBundle.getMessage(AcknowledgeAction.class, (String)"LBL_AcknowledgeAction_action_name");
    private static final Logger logger = LogFactory.getLogger(AcknowledgeAction.class.getName());

    protected boolean enable(Node[] nodeArray) {
        if (nodeArray.length == 0) {
            return false;
        }
        boolean bl = true;
        for (int i = 0; i < nodeArray.length; ++i) {
            try {
                AlarmBean alarmBean = (AlarmBean)((AlarmBeanNode)nodeArray[i]).getBean();
                if (alarmBean.isAlarmNodeActive() && !alarmBean.isAlarmNodeAcknowledged() && !alarmBean.isOnHighlightedList()) continue;
                bl = false;
                break;
            }
            catch (ClassCastException classCastException) {
                logger.debug((Object)("ClassCastException obj=" + nodeArray[i]));
                return false;
            }
        }
        return bl;
    }

    public String getName() {
        return name;
    }

    protected String iconResource() {
        return null;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected void performAction(Node[] nodeArray) {
        String string = AppRegister.getInstance().getRegisteredUserName();
        String string2 = null;
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)new AlarmCommentPanel(string, string2), NbBundle.getMessage(AlarmCommentPanel.class, (String)"LBL_COMMENT_ON_ACKNOWLEDGED_ALARM_display_name"));
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor) != NotifyDescriptor.OK_OPTION) {
            return;
        }
        AcWindowManager.setStatusText("Acknowledge action is running .......");
        AlarmCommentPanel alarmCommentPanel = (AlarmCommentPanel)dialogDescriptor.getMessage();
        Comment comment = new Comment(alarmCommentPanel.getOperatorName(), alarmCommentPanel.getCommnet());
        AlarmBean[] alarmBeanArray = new AlarmBean[nodeArray.length];
        for (int i = 0; i < nodeArray.length; ++i) {
            alarmBeanArray[i] = (AlarmBean)((AlarmBeanNode)nodeArray[i]).getBean();
        }
        AlarmContainer.getDefault().acknowledge(alarmBeanArray, true, comment);
        AcWindowManager.setStatusText("Acknowledge action finished");
    }
}

