/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.actions;

import cern.laser.client.LaserException;
import cern.laser.client.services.selection.AlarmSelectionHandler;
import cern.laser.console.User;
import cern.laser.guiplatform.actions.support.CallableSystemAction;
import cern.laser.guiplatform.alarms.AlarmContainer;
import cern.laser.guiplatform.alarms.AlarmSelectionHandlerFactory;
import cern.laser.guiplatform.logging.TraceLogger;
import cern.laser.guiplatform.util.AppRegister;
import cern.laser.guiplatform.util.LogFactory;
import cern.laser.guiplatform.util.ProxyBuffer;
import cern.laser.guiplatform.windowmanager.AcWindowManager;
import org.apache.log4j.Logger;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class LogoutAction
extends CallableSystemAction {
    private Logger logger = LogFactory.getLogger(LogoutAction.class.getName());

    @Override
    public void performAction() {
        User user = AppRegister.getInstance().getRegisteredUser();
        try {
            this.logger.debug((Object)("user " + user.getName() + " has just logged out"));
            TraceLogger.log("user " + user.getName() + " has just logged out");
        }
        catch (LaserException laserException) {
            this.logger.error((Object)laserException.getRootCause());
            TraceLogger.log("User.getName() " + laserException.getRootCause());
        }
        AcWindowManager.closeAllTopComponents();
        try {
            AlarmSelectionHandler alarmSelectionHandler = AlarmSelectionHandlerFactory.getHandler();
            alarmSelectionHandler.resetSelection();
        }
        catch (LaserException laserException) {
            this.logger.error((Object)laserException, laserException.fillInStackTrace());
            this.logger.error((Object)laserException.getRootCause(), laserException.getRootCause().fillInStackTrace());
        }
        ProxyBuffer.getDefault().disable();
        ProxyBuffer.getDefault().close();
        AppRegister.getInstance().cleanRegister();
        AlarmContainer.getDefault().clearContainer();
        AppRegister.getInstance().unregisterUser();
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(LogoutAction.class, (String)"LBL_LogoutAction");
    }

    protected String iconResource() {
        return "cern/laser/guiplatform/images/exit.gif";
    }

    @Override
    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}

