/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.util.buffer;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.Properties;

public final class SynchroBufferConfig {
    private static Properties sbProperties = null;
    public static final String CONFIGURATION_PROPERTY = "synchrobuffer.config";
    public static final String CONFIGURATION_PROPERTY_FILE = "synchrobuffer-config.properties";
    public static final String CONFIGURATION_FILE = "synchrobuffer.properties";
    public static final String MIN_WINDOW_SIZE_PROPERTY = "synchrobuffer.minwindowsize";
    public static final String MAX_WINDOW_SIZE_PROPERTY = "synchrobuffer.maxwindowsize";
    public static final String WINDOW_GROWTH_FACTOR_PROPERTY = "synchrobuffer.windowgrowthfactor";
    public static final String DUPLICATE_POLICY_PROPERTY = "synchrobuffer.duplicatepolicy";
    private static final String DEFAULT_MIN_WINDOW_SIZE = "500";
    private static final String DEFAULT_MAX_WINDOW_SIZE = "5000";
    private static final String DEFAULT_WINDOW_GROWTH_FACTOR = "100";
    private static final String DEFAULT_DUPLICATE_POLICY = String.valueOf(1);

    public static Properties getProperties(ClassLoader classLoader) {
        if (sbProperties == null) {
            InputStream inputStream;
            sbProperties = new Properties();
            InputStream inputStream2 = null;
            try {
                inputStream2 = SynchroBufferConfig.getInputStream(classLoader, System.getProperty(CONFIGURATION_PROPERTY));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (inputStream2 == null) {
                try {
                    inputStream2 = SynchroBufferConfig.getInputStream(classLoader, CONFIGURATION_FILE);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (inputStream2 == null) {
                    try {
                        inputStream = SynchroBufferConfig.getInputStream(classLoader, CONFIGURATION_PROPERTY_FILE);
                        Properties properties = new Properties();
                        properties.load(inputStream);
                        inputStream2 = SynchroBufferConfig.getInputStream(classLoader, properties.getProperty(CONFIGURATION_PROPERTY));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (inputStream2 != null) {
                try {
                    inputStream = new BufferedInputStream(inputStream2);
                    sbProperties.load(inputStream);
                    inputStream2.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            SynchroBufferConfig.setProperties();
        }
        return sbProperties;
    }

    private static void setProperties() {
        sbProperties.setProperty(MIN_WINDOW_SIZE_PROPERTY, System.getProperty(MIN_WINDOW_SIZE_PROPERTY, sbProperties.getProperty(MIN_WINDOW_SIZE_PROPERTY, DEFAULT_MIN_WINDOW_SIZE)));
        sbProperties.setProperty(MAX_WINDOW_SIZE_PROPERTY, System.getProperty(MAX_WINDOW_SIZE_PROPERTY, sbProperties.getProperty(MAX_WINDOW_SIZE_PROPERTY, DEFAULT_MAX_WINDOW_SIZE)));
        sbProperties.setProperty(WINDOW_GROWTH_FACTOR_PROPERTY, System.getProperty(WINDOW_GROWTH_FACTOR_PROPERTY, sbProperties.getProperty(WINDOW_GROWTH_FACTOR_PROPERTY, DEFAULT_WINDOW_GROWTH_FACTOR)));
        sbProperties.setProperty(DUPLICATE_POLICY_PROPERTY, System.getProperty(DUPLICATE_POLICY_PROPERTY, sbProperties.getProperty(DUPLICATE_POLICY_PROPERTY, DEFAULT_DUPLICATE_POLICY)));
        StringWriter stringWriter = new StringWriter();
        sbProperties.list(new PrintWriter(stringWriter));
    }

    private static InputStream getInputStream(ClassLoader classLoader, String string) throws IOException {
        InputStream inputStream = null;
        if (classLoader != null) {
            inputStream = classLoader.getResourceAsStream(string);
        }
        if (inputStream == null) {
            try {
                URL uRL = new URL(string);
                inputStream = uRL.openStream();
            }
            catch (Exception exception) {
                try {
                    inputStream = new FileInputStream(string);
                }
                catch (Exception exception2) {
                    throw new IOException("unable to get the configuration");
                }
            }
        }
        return inputStream;
    }
}

