/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.util.buffer;

import cern.laser.util.buffer.PullEvent;
import cern.laser.util.buffer.PullException;
import cern.laser.util.buffer.SynchroBuffer;
import cern.laser.util.buffer.SynchroBufferListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class SynchroBufferAdapter {
    private static final Logger LOGGER = Logger.getLogger((String)SynchroBufferAdapter.class.getName());
    private List queue;
    private SynchroBuffer adaptee;
    private SynchroBufferListener listener;
    private Thread pullingThread;
    private Boolean enabled = Boolean.TRUE;
    private Boolean closed = Boolean.FALSE;
    private Boolean firing = Boolean.FALSE;
    private Boolean semaphore = Boolean.FALSE;

    public SynchroBufferAdapter(SynchroBufferListener synchroBufferListener, SynchroBuffer synchroBuffer) {
        this.listener = synchroBufferListener;
        this.adaptee = synchroBuffer;
        this.adaptee.setSynchroBufferListener(this.createSynchroBufferListener());
        this.queue = Collections.synchronizedList(new ArrayList());
        this.pullingThread = this.createPullingThread();
        this.pullingThread.start();
    }

    public void push(Object object) {
        this.adaptee.push(object);
    }

    public void push(Collection collection) {
        this.adaptee.push(collection);
    }

    public void enable() {
        this.adaptee.enable();
        this.setEnabled(true);
        LOGGER.debug((Object)"SynchroBufferAdapter listener enabled");
    }

    public void disable() {
        this.adaptee.disable();
        this.setEnabled(false);
        LOGGER.debug((Object)"SynchroBufferAdapter listener disabled");
    }

    private SynchroBufferListener createSynchroBufferListener() {
        return new SynchroBufferListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void pull(PullEvent pullEvent) throws PullException {
                List list = SynchroBufferAdapter.this.queue;
                synchronized (list) {
                    SynchroBufferAdapter.this.queue.add(pullEvent);
                    SynchroBufferAdapter.this.semNotify();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fire() {
        if (this.isEnabled()) {
            this.setFiring(true);
            while (!this.isEmpty() && this.isEnabled()) {
                ArrayList arrayList = new ArrayList();
                List list = this.queue;
                synchronized (list) {
                    for (int i = 0; i < this.queue.size(); ++i) {
                        arrayList.add(this.queue.get(i));
                    }
                    this.queue.clear();
                }
                for (PullEvent pullEvent : arrayList) {
                    try {
                        this.listener.pull(pullEvent);
                    }
                    catch (PullException pullException) {
                        pullException.printStackTrace();
                    }
                }
            }
            this.setFiring(false);
        }
    }

    private Thread createPullingThread() {
        return new Thread(){

            @Override
            public void run() {
                while (!SynchroBufferAdapter.this.isClosed() || !SynchroBufferAdapter.this.isEmpty() && SynchroBufferAdapter.this.isEnabled()) {
                    SynchroBufferAdapter.this.semWait();
                    SynchroBufferAdapter.this.fire();
                }
                System.out.println("SynchroBufferAdapter pulling thread exited");
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void semNotify() {
        Boolean bl = this.semaphore;
        synchronized (bl) {
            this.semaphore.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void semWait() {
        Boolean bl = this.semaphore;
        synchronized (bl) {
            try {
                this.semaphore.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEmpty() {
        List list = this.queue;
        synchronized (list) {
            return this.queue.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEnabled() {
        Boolean bl = this.enabled;
        synchronized (bl) {
            return this.enabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setEnabled(boolean bl) {
        Boolean bl2 = this.enabled;
        synchronized (bl2) {
            if (bl) {
                this.enabled = Boolean.TRUE;
                this.semNotify();
            } else {
                this.enabled = Boolean.FALSE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isClosed() {
        Boolean bl = this.closed;
        synchronized (bl) {
            return this.closed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setClosed(boolean bl) {
        Boolean bl2 = this.closed;
        synchronized (bl2) {
            this.closed = bl ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFiring(boolean bl) {
        Boolean bl2 = this.firing;
        synchronized (bl2) {
            this.firing = bl ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isFiring() {
        Boolean bl = this.firing;
        synchronized (bl) {
            return this.firing;
        }
    }

    public void close() {
        this.adaptee.close();
        this.setClosed(true);
        this.semNotify();
        while (!this.isEmpty() && this.isEnabled() || this.isFiring()) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {}
        }
        LOGGER.debug((Object)"SynchroBufferAdapter closed");
    }
}

