/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.util.buffer;

import cern.laser.util.buffer.PullEvent;
import cern.laser.util.buffer.PullException;
import cern.laser.util.buffer.SynchroBufferConfig;
import cern.laser.util.buffer.SynchroBufferListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class SynchroBuffer {
    private static final Logger LOGGER = Logger.getLogger((String)SynchroBuffer.class.getName());
    private long minWindowSize;
    private long maxWindowSize;
    private int windowGrowthFactor;
    private int duplicatePolicy;
    private Thread checkingThread;
    private Boolean closed = Boolean.FALSE;
    private Boolean firing = Boolean.FALSE;
    private Boolean enabled = Boolean.FALSE;
    private SynchroBufferListener listener = null;
    private List buffer = null;
    public static final int DUPLICATE_OK = 1;
    public static final int DUPLICATE_REPLACE = 2;
    public static final int DUPLICATE_DISCARD = 3;

    public SynchroBuffer(long l, long l2, int n, int n2) {
        this.init(l, l2, n, n2);
    }

    public SynchroBuffer() {
        Properties properties = SynchroBufferConfig.getProperties(this.getClass().getClassLoader());
        long l = Long.parseLong(properties.getProperty("synchrobuffer.minwindowsize"));
        long l2 = Long.parseLong(properties.getProperty("synchrobuffer.maxwindowsize"));
        int n = Integer.parseInt(properties.getProperty("synchrobuffer.windowgrowthfactor"));
        int n2 = Integer.parseInt(properties.getProperty("synchrobuffer.duplicatepolicy"));
        this.init(l, l2, n, n2);
    }

    private void init(long l, long l2, int n, int n2) {
        System.out.println("SynchroBuffer[minWindowSize=" + l + ",maxWindowSize=" + l2 + ",windowGrowthFactor=" + n + ",duplicatePolicy=" + (n2 == 3 ? "DUPLICATE_DISCARD" : (n2 == 2 ? "DUPLICATE_REPLACE" : "DUPLICATE_OK")) + "]");
        if (l <= 0L || l2 <= 0L || n <= 0) {
            throw new IllegalArgumentException("arguments must be greater than zero");
        }
        if (l2 <= l) {
            throw new IllegalArgumentException("maximum window size must be greater than minimum window size");
        }
        this.minWindowSize = l;
        this.maxWindowSize = l2;
        this.windowGrowthFactor = n;
        this.duplicatePolicy = n2;
        this.buffer = new ArrayList();
        this.checkingThread = this.createCheckingThread();
        this.checkingThread.start();
    }

    private Thread createCheckingThread() {
        return new Thread(){

            @Override
            public void run() {
                long l = 0L;
                long l2 = SynchroBuffer.this.minWindowSize;
                while (!SynchroBuffer.this.isClosed() || !SynchroBuffer.this.isEmpty() && SynchroBuffer.this.isEnabled()) {
                    if (SynchroBuffer.this.isEnabled()) {
                        float f = (long)(1000 * SynchroBuffer.this.buffer.size()) / (l2 + l);
                        long l3 = SynchroBuffer.this.minWindowSize + (long)((float)SynchroBuffer.this.windowGrowthFactor * f);
                        l2 = l3 < SynchroBuffer.this.maxWindowSize ? l3 : SynchroBuffer.this.maxWindowSize;
                        l = SynchroBuffer.this.fire();
                        try {
                            Thread.sleep(l2);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    try {
                        Thread.sleep(SynchroBuffer.this.maxWindowSize);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long fire() {
        this.setFiring(true);
        Collection collection = null;
        List list = this.buffer;
        synchronized (list) {
            collection = (Collection)((ArrayList)this.buffer).clone();
            this.buffer.clear();
        }
        long l = System.currentTimeMillis();
        if (this.listener != null && collection.size() > 0) {
            try {
                this.listener.pull(new PullEvent(this, collection));
            }
            catch (PullException pullException) {
                pullException.printStackTrace();
            }
        }
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        this.setFiring(false);
        return l3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(Object object) {
        if (this.isClosed()) {
            throw new IllegalArgumentException("buffer closed");
        }
        List list = this.buffer;
        synchronized (list) {
            switch (this.duplicatePolicy) {
                case 3: {
                    if (this.buffer.contains(object)) break;
                    this.buffer.add(object);
                    break;
                }
                case 2: {
                    int n = this.buffer.indexOf(object);
                    if (n == -1) {
                        this.buffer.add(object);
                        break;
                    }
                    this.buffer.set(n, object);
                    break;
                }
                default: {
                    this.buffer.add(object);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(Collection collection) {
        if (this.isClosed()) {
            throw new IllegalArgumentException("buffer closed");
        }
        if (collection != null && collection.size() != 0) {
            List list = this.buffer;
            synchronized (list) {
                if (this.duplicatePolicy != 3 && this.duplicatePolicy != 2) {
                    this.buffer.addAll(collection);
                } else {
                    Iterator iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        this.push(iterator.next());
                    }
                }
            }
        }
    }

    public void setSynchroBufferListener(SynchroBufferListener synchroBufferListener) {
        this.listener = synchroBufferListener;
    }

    public void enable() {
        this.setEnabled(true);
    }

    public void disable() {
        this.setEnabled(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isClosed() {
        Boolean bl = this.closed;
        synchronized (bl) {
            return this.closed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setClosed(boolean bl) {
        Boolean bl2 = this.closed;
        synchronized (bl2) {
            this.closed = bl ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFiring(boolean bl) {
        Boolean bl2 = this.firing;
        synchronized (bl2) {
            this.firing = bl ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isFiring() {
        Boolean bl = this.firing;
        synchronized (bl) {
            return this.firing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEmpty() {
        List list = this.buffer;
        synchronized (list) {
            return this.buffer.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEnabled() {
        Boolean bl = this.enabled;
        synchronized (bl) {
            return this.enabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setEnabled(boolean bl) {
        Boolean bl2 = this.enabled;
        synchronized (bl2) {
            this.enabled = bl ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    public void close() {
        this.setClosed(true);
        while (!this.isEmpty() && this.isEnabled() || this.isFiring()) {
            try {
                Thread.sleep(this.minWindowSize);
            }
            catch (Exception exception) {}
        }
    }
}

