/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;

public class UUIDGenerator {
    private SecureRandom seeder;
    private String midValue;
    private static UUIDGenerator generator = null;

    private UUIDGenerator() throws UnknownHostException {
        InetAddress inetAddress = InetAddress.getLocalHost();
        byte[] byArray = inetAddress.getAddress();
        String string = UUIDGenerator.hexFormat(this.getInt(byArray), 8);
        String string2 = UUIDGenerator.hexFormat(System.identityHashCode(this), 8);
        this.midValue = string + string2;
        this.seeder = new SecureRandom();
        int n = this.seeder.nextInt();
    }

    public static final UUIDGenerator getInstance() throws UnknownHostException {
        if (generator == null) {
            generator = new UUIDGenerator();
        }
        return generator;
    }

    public Integer getUUID() {
        long l = System.currentTimeMillis();
        int n = (int)l & 0xFFFFFFFF;
        int n2 = this.seeder.nextInt();
        String string = UUIDGenerator.hexFormat(n, 8) + this.midValue + UUIDGenerator.hexFormat(n2, 8);
        return new Integer(string.hashCode());
    }

    private int getInt(byte[] byArray) {
        int n = 0;
        int n2 = 24;
        int n3 = 0;
        while (n2 >= 0) {
            int n4 = byArray[n3] & 0xFF;
            n += n4 << n2;
            n2 -= 8;
            ++n3;
        }
        return n;
    }

    private static String hexFormat(int n, int n2) {
        String string = Integer.toHexString(n);
        return UUIDGenerator.padHex(string, n2) + string;
    }

    private static String padHex(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string.length() < n) {
            for (int i = 0; i < n - string.length(); ++i) {
                stringBuffer.append('0');
            }
        }
        return stringBuffer.toString();
    }
}

