/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.util;

import oracle.xml.util.OraURIException;
import oracle.xml.util.OraURIUtil;

public class OraURI {
    public static final short ABS_NOTSET = 0;
    public static final short IS_ABS = 1;
    public static final short ISNOT_ABS = 2;
    short absolute = 0;
    String uri = null;
    String scheme = null;
    String userinfo = null;
    String host = null;
    int port = -1;
    String regAuthority = null;
    String path = null;
    String queryString = null;
    String fragment = null;
    private static final byte[] allowedChars = new byte[128];
    private static final int RESERVED_CHARACTERS = 1;
    private static final int MARK_CHARACTERS = 2;
    private static final int SCHEME_CHARACTERS = 4;
    private static final int USERINFO_CHARACTERS = 8;
    private static final int ASCII_ALPHA_CHARACTERS = 16;
    private static final int ASCII_DIGIT_CHARACTERS = 32;
    private static final int ASCII_HEX_CHARACTERS = 64;
    private static final int PATH_CHARACTERS = 128;
    private static final int MASK_ALPHA_NUMERIC = 48;
    private static final int MASK_UNRESERVED_MASK = 50;
    private static final int MASK_URI_CHARACTER = 51;
    private static final int MASK_SCHEME_CHARACTER = 52;
    private static final int MASK_USERINFO_CHARACTER = 58;
    private static final int MASK_PATH_CHARACTER = 178;

    public OraURI(String string) throws OraURIException {
        this.uri = string;
        this.parseURI();
    }

    void parseURI() throws OraURIException {
        int n;
        int n2;
        int n3 = this.uri != null ? this.uri.length() : 0;
        int n4 = 0;
        int n5 = this.uri.indexOf(58);
        if (n5 != -1) {
            n2 = n5 - 1;
            n = this.uri.lastIndexOf(47, n2);
            int n6 = this.uri.lastIndexOf(63, n2);
            int n7 = this.uri.lastIndexOf(35, n2);
            if (n5 > -1 && (n5 < 2 || n != -1 || n6 != -1 || n7 != -1)) {
                if (n5 == 0 || n7 != 0) {
                    throw new OraURIException(23007);
                }
            } else {
                this.parseScheme();
                n4 = this.scheme.length() + 1;
                if (n5 == n3 - 1 || this.uri.charAt(n5 + 1) == '#') {
                    throw new OraURIException(23008);
                }
            }
        }
        if (n4 + 1 < n3 && this.uri.charAt(n4) == '/' && this.uri.charAt(n4 + 1) == '/') {
            n2 = n4 += 2;
            n = 0;
            while (n4 < n3 && (n = (int)this.uri.charAt(n4)) != 47 && n != 63 && n != 35) {
                ++n4;
            }
            if (n4 > n2) {
                if (!this.parseAuthority(this.uri.substring(n2, n4))) {
                    n4 = n2 - 2;
                }
            } else {
                this.host = "";
            }
        }
        this.parsePath(n4);
    }

    private void parseScheme() throws OraURIException {
        int n;
        int n2 = this.uri.length();
        String string = null;
        char c = '\u0000';
        for (n = 0; n < n2 && (c = this.uri.charAt(n)) != ':' && c != '/' && c != '?' && c != '#'; ++n) {
        }
        string = this.uri.substring(0, n);
        if (string.length() == 0) {
            throw new OraURIException(23007);
        }
        this.setScheme(string);
    }

    private boolean parseAuthority(String string) {
        int n;
        int n2 = 0;
        int n3 = string.length();
        char c = '\u0000';
        this.userinfo = null;
        if (string.indexOf(64, n2) != -1) {
            for (n = 0; n < n3 && (c = string.charAt(n)) != '@'; ++n) {
            }
            this.userinfo = string.substring(n2, n);
            ++n;
        }
        this.host = null;
        n2 = n;
        boolean bl = false;
        if (n < n3) {
            int n4;
            if (string.charAt(n2) == '[') {
                n4 = string.indexOf(93, n2);
                int n5 = n = n4 != -1 ? n4 : n3;
                if (n + 1 < n3 && string.charAt(n + 1) == ':') {
                    ++n;
                    bl = true;
                } else {
                    n = n3;
                }
            } else {
                n4 = string.lastIndexOf(58, n3);
                n = n4 > n2 ? n4 : n3;
                bl = n != n3;
            }
        }
        this.host = string.substring(n2, n);
        this.port = -1;
        if (this.host.length() > 0 && bl) {
            n2 = ++n;
            while (n < n3) {
                ++n;
            }
            String string2 = string.substring(n2, n);
            if (string2.length() > 0) {
                try {
                    this.port = Integer.parseInt(string2);
                    if (this.port == -1) {
                        --this.port;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.port = -2;
                }
            }
        }
        if (this.isServer()) {
            return true;
        }
        if (this.isRegistry(string)) {
            this.regAuthority = string;
            return true;
        }
        return false;
    }

    private boolean isServer() {
        int n;
        char c;
        int n2;
        if (this.userinfo != null) {
            n2 = this.userinfo.length();
            c = '\u0000';
            for (n = 0; n < n2; ++n) {
                c = this.userinfo.charAt(n);
                if (c == '%') {
                    if (n + 2 >= n2 || !OraURI.isHex(this.userinfo.charAt(n + 1)) || !OraURI.isHex(this.userinfo.charAt(n + 2))) {
                        return false;
                    }
                    n += 2;
                    continue;
                }
                if (OraURI.isUserinfoCharacter(c)) continue;
                return false;
            }
        }
        if (this.host == null) {
            return false;
        }
        n2 = this.host.length();
        if (n2 == 0) {
            return false;
        }
        if (this.host.startsWith("[") && !OraURI.isIPv6Compatible(this.host)) {
            return false;
        }
        if (!this.host.startsWith("[")) {
            if (this.host.startsWith(".") || this.host.startsWith("-") || this.host.endsWith("-")) {
                return false;
            }
            n = this.host.lastIndexOf(46);
            if (this.host.endsWith(".")) {
                n = this.host.substring(0, n).lastIndexOf(46);
            }
            if (n + 1 < n2 && OraURI.isDigit(this.host.charAt(n + 1))) {
                return this.parseIPv4Address(this.host);
            }
            if (n2 > 255) {
                return false;
            }
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                c = this.host.charAt(i);
                if (c == '.') {
                    if (!OraURI.isAlphanum(this.host.charAt(i - 1))) {
                        return false;
                    }
                    if (i + 1 < n2 && !OraURI.isAlphanum(this.host.charAt(i + 1))) {
                        return false;
                    }
                    n3 = 0;
                    continue;
                }
                if (!OraURI.isAlphanum(c) && c != '-') {
                    return false;
                }
                if (++n3 <= 63) continue;
                return false;
            }
        }
        return this.isLegalPort(this.port);
    }

    private boolean isLegalPort(int n) {
        return n >= -1 && n <= 65535;
    }

    private boolean isRegistry(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '%') {
                if (i + 2 >= n || !OraURI.isHex(string.charAt(i + 1)) || !OraURI.isHex(string.charAt(i + 2))) {
                    return false;
                }
                i += 2;
                continue;
            }
            if (OraURI.isPathCharacter(c)) continue;
            return false;
        }
        return true;
    }

    private void parsePath(int n) throws OraURIException {
        int n2;
        int n3 = n;
        int n4 = this.uri.length();
        char c = '\u0000';
        if (n3 < n4) {
            if (this.getScheme() == null || this.uri.charAt(n3) == '/') {
                for (n2 = n; n2 < n4; ++n2) {
                    c = this.uri.charAt(n2);
                    if (c == '%') {
                        if (n2 + 2 >= n4 || !OraURI.isHex(this.uri.charAt(n2 + 1)) || !OraURI.isHex(this.uri.charAt(n2 + 2))) {
                            throw new OraURIException(23011);
                        }
                        n2 += 2;
                        continue;
                    }
                    if (OraURI.isPathCharacter(c)) continue;
                    if (c != '?' && c != '#') {
                        throw new OraURIException(23010, String.valueOf(c));
                    }
                    break;
                }
            } else {
                while (n2 < n4 && (c = this.uri.charAt(n2)) != '?' && c != '#') {
                    if (c == '%') {
                        if (n2 + 2 >= n4 || !OraURI.isHex(this.uri.charAt(n2 + 1)) || !OraURI.isHex(this.uri.charAt(n2 + 2))) {
                            throw new OraURIException(23011);
                        }
                        n2 += 2;
                    } else if (!OraURI.isURICharacter(c)) {
                        throw new OraURIException(23010, String.valueOf(c));
                    }
                    ++n2;
                }
            }
        }
        this.path = this.uri.substring(n3, n2);
        if (c == '?') {
            n3 = ++n2;
            while (n2 < n4 && (c = this.uri.charAt(n2)) != '#') {
                if (c == '%') {
                    if (n2 + 2 >= n4 || !OraURI.isHex(this.uri.charAt(n2 + 1)) || !OraURI.isHex(this.uri.charAt(n2 + 2))) {
                        throw new OraURIException(23011);
                    }
                    n2 += 2;
                } else if (!OraURI.isURICharacter(c)) {
                    throw new OraURIException(23010, String.valueOf(c));
                }
                ++n2;
            }
            this.queryString = this.uri.substring(n3, n2);
        }
        if (c == '#') {
            n3 = ++n2;
            while (n2 < n4) {
                c = this.uri.charAt(n2);
                if (c == '%') {
                    if (n2 + 2 >= n4 || !OraURI.isHex(this.uri.charAt(n2 + 1)) || !OraURI.isHex(this.uri.charAt(n2 + 2))) {
                        throw new OraURIException(23011);
                    }
                    n2 += 2;
                } else if (!OraURI.isURICharacter(c)) {
                    throw new OraURIException(23010, String.valueOf(c));
                }
                ++n2;
            }
            this.fragment = this.uri.substring(n3, n2);
        }
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getUserinfo() {
        return this.userinfo;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getRegistryBasedAuthority() {
        return this.regAuthority;
    }

    public String getPath() {
        return this.path;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getFragment() {
        return this.fragment;
    }

    public void setScheme(String string) throws OraURIException {
        if (string == null || string.trim().length() == 0 || !OraURI.isAlpha(string.charAt(0))) {
            throw new OraURIException(23009);
        }
        int n = string.length();
        for (int i = 1; i < n; ++i) {
            char c = string.charAt(i);
            if (OraURI.isSchemeCharacter(c)) continue;
            throw new OraURIException(23009);
        }
        this.scheme = string.toLowerCase();
    }

    public boolean parseIPv4Address(String string) {
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (OraURI.isDigit(c)) {
                if (++n3 > 3) {
                    return false;
                }
                if (n3 != 3) continue;
                String string2 = string.substring(i - 2, i);
                try {
                    Integer n4 = new Integer(string2);
                    if (n4 <= 255) continue;
                    return false;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            if (c == '.') {
                if (++n2 > 3) {
                    return false;
                }
                if (i > 0 && !OraURI.isDigit(string.charAt(i - 1)) || i + 1 < n && !OraURI.isDigit(string.charAt(i + 1))) {
                    return false;
                }
                n3 = 0;
                continue;
            }
            return false;
        }
        return n2 == 3;
    }

    public static boolean isIPv6Compatible(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        if (n <= 2 || string.charAt(0) != '[' || string.charAt(n - 1) != ']') {
            return false;
        }
        return OraURIUtil.parseIPv6ToBytes(string = string.substring(1, n - 1)) != null;
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isHex(char c) {
        return c <= 'f' && (allowedChars[c] & 0x40) != 0;
    }

    private static boolean isAlpha(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private static boolean isAlphanum(char c) {
        return c <= 'z' && (allowedChars[c] & 0x30) != 0;
    }

    private static boolean isReservedCharacter(char c) {
        return c <= ']' && (allowedChars[c] & 1) != 0;
    }

    private static boolean isUnreservedCharacter(char c) {
        return c <= '~' && (allowedChars[c] & 0x32) != 0;
    }

    private static boolean isURICharacter(char c) {
        return c <= '~' && (allowedChars[c] & 0x33) != 0;
    }

    private static boolean isSchemeCharacter(char c) {
        return c <= 'z' && (allowedChars[c] & 0x34) != 0;
    }

    private static boolean isUserinfoCharacter(char c) {
        return c <= 'z' && (allowedChars[c] & 0x3A) != 0;
    }

    private static boolean isPathCharacter(char c) {
        return c <= '~' && (allowedChars[c] & 0xB2) != 0;
    }

    public boolean isAbsolute() {
        return this.scheme != null;
    }

    public OraURI resolve(OraURI oraURI) {
        if (oraURI != null) {
            int n;
            if (oraURI.getPath().length() == 0 && oraURI.getScheme() == null && oraURI.getHost() == null && oraURI.getRegistryBasedAuthority() == null) {
                if (oraURI.getQueryString() != null || oraURI.getFragment() != null) {
                    this.queryString = oraURI.getQueryString();
                    this.fragment = oraURI.getFragment();
                }
            } else {
                this.queryString = oraURI.getQueryString();
                this.fragment = oraURI.getFragment();
            }
            if (oraURI.getScheme() != null) {
                this.path = oraURI.getPath();
                this.scheme = oraURI.getScheme();
                this.host = oraURI.getHost();
                this.port = oraURI.getPort();
                this.userinfo = oraURI.getUserinfo();
                this.regAuthority = oraURI.getRegistryBasedAuthority();
                this.queryString = oraURI.getQueryString();
                this.fragment = oraURI.getFragment();
                return this;
            }
            if (oraURI.getHost() != null || oraURI.getRegistryBasedAuthority() != null) {
                this.host = oraURI.getHost();
                this.regAuthority = oraURI.getRegistryBasedAuthority();
                this.path = oraURI.getPath();
                return this;
            }
            if (oraURI.getPath().length() > 0 && oraURI.getPath().startsWith("/")) {
                this.path = oraURI.getPath();
                return this;
            }
            String string = "";
            String string2 = this.path;
            if (string2 != null && string2.length() > 0) {
                n = string2.lastIndexOf(47);
                if (n != -1) {
                    string = string2.substring(0, n + 1);
                }
            } else if (string.length() > 0) {
                string = "/";
            }
            string = string.concat(oraURI.getPath());
            n = -1;
            while ((n = string.indexOf("/./")) != -1) {
                string = string.substring(0, n + 1).concat(string.substring(n + 3));
            }
            if (string.endsWith("/.")) {
                string = string.substring(0, string.length() - 1);
            }
            n = 1;
            int n2 = -1;
            String string3 = null;
            while ((n = string.indexOf("/../", n)) > 0) {
                string3 = string.substring(0, string.indexOf("/../"));
                n2 = string3.lastIndexOf(47);
                if (n2 != -1) {
                    if (!string3.substring(n2).equals("..")) {
                        string = string.substring(0, n2 + 1).concat(string.substring(n + 4));
                        n = n2;
                        continue;
                    }
                    n += 4;
                    continue;
                }
                n += 4;
            }
            if (string.endsWith("/..") && (n2 = (string3 = string.substring(0, string.length() - 3)).lastIndexOf(47)) != -1) {
                string = string.substring(0, n2 + 1);
            }
            this.path = string;
        }
        return this;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.scheme != null) {
            stringBuffer.append(this.scheme);
            stringBuffer.append(':');
        }
        if (this.host != null || this.regAuthority != null) {
            stringBuffer.append("//");
            if (this.host != null) {
                if (this.userinfo != null) {
                    stringBuffer.append(this.userinfo);
                    stringBuffer.append('@');
                }
                stringBuffer.append(this.host);
                if (this.port != -1) {
                    stringBuffer.append(':');
                    stringBuffer.append(this.port);
                }
            } else {
                stringBuffer.append(this.regAuthority);
            }
        }
        if (this.path != null) {
            stringBuffer.append(this.path);
        }
        if (this.queryString != null) {
            stringBuffer.append('?');
            stringBuffer.append(this.queryString);
        }
        if (this.fragment != null) {
            stringBuffer.append('#');
            stringBuffer.append(this.fragment);
        }
        this.uri = stringBuffer.toString();
        return this.uri;
    }

    static {
        int n = 48;
        while (n <= 57) {
            int n2 = n++;
            allowedChars[n2] = (byte)(allowedChars[n2] | 0x60);
        }
        for (n = 65; n <= 70; ++n) {
            int n3 = n;
            allowedChars[n3] = (byte)(allowedChars[n3] | 0x50);
            int n4 = n + 32;
            allowedChars[n4] = (byte)(allowedChars[n4] | 0x50);
        }
        for (n = 71; n <= 90; ++n) {
            int n5 = n;
            allowedChars[n5] = (byte)(allowedChars[n5] | 0x10);
            int n6 = n + 32;
            allowedChars[n6] = (byte)(allowedChars[n6] | 0x10);
        }
        allowedChars[59] = (byte)(allowedChars[59] | 1);
        allowedChars[47] = (byte)(allowedChars[47] | 1);
        allowedChars[63] = (byte)(allowedChars[63] | 1);
        allowedChars[58] = (byte)(allowedChars[58] | 1);
        allowedChars[64] = (byte)(allowedChars[64] | 1);
        allowedChars[38] = (byte)(allowedChars[38] | 1);
        allowedChars[61] = (byte)(allowedChars[61] | 1);
        allowedChars[43] = (byte)(allowedChars[43] | 1);
        allowedChars[36] = (byte)(allowedChars[36] | 1);
        allowedChars[44] = (byte)(allowedChars[44] | 1);
        allowedChars[91] = (byte)(allowedChars[91] | 1);
        allowedChars[93] = (byte)(allowedChars[93] | 1);
        allowedChars[45] = (byte)(allowedChars[45] | 2);
        allowedChars[95] = (byte)(allowedChars[95] | 2);
        allowedChars[46] = (byte)(allowedChars[46] | 2);
        allowedChars[33] = (byte)(allowedChars[33] | 2);
        allowedChars[126] = (byte)(allowedChars[126] | 2);
        allowedChars[42] = (byte)(allowedChars[42] | 2);
        allowedChars[39] = (byte)(allowedChars[39] | 2);
        allowedChars[40] = (byte)(allowedChars[40] | 2);
        allowedChars[41] = (byte)(allowedChars[41] | 2);
        allowedChars[43] = (byte)(allowedChars[43] | 4);
        allowedChars[45] = (byte)(allowedChars[45] | 4);
        allowedChars[46] = (byte)(allowedChars[46] | 4);
        allowedChars[59] = (byte)(allowedChars[59] | 8);
        allowedChars[58] = (byte)(allowedChars[58] | 8);
        allowedChars[38] = (byte)(allowedChars[38] | 8);
        allowedChars[61] = (byte)(allowedChars[61] | 8);
        allowedChars[43] = (byte)(allowedChars[43] | 8);
        allowedChars[36] = (byte)(allowedChars[36] | 8);
        allowedChars[44] = (byte)(allowedChars[44] | 8);
        allowedChars[59] = (byte)(allowedChars[59] | 0x80);
        allowedChars[47] = (byte)(allowedChars[47] | 0x80);
        allowedChars[58] = (byte)(allowedChars[58] | 0x80);
        allowedChars[64] = (byte)(allowedChars[64] | 0x80);
        allowedChars[38] = (byte)(allowedChars[38] | 0x80);
        allowedChars[61] = (byte)(allowedChars[61] | 0x80);
        allowedChars[43] = (byte)(allowedChars[43] | 0x80);
        allowedChars[36] = (byte)(allowedChars[36] | 0x80);
        allowedChars[44] = (byte)(allowedChars[44] | 0x80);
    }
}

