/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.jdwp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import oracle.xml.jdwp.XSLJDWPConstants;
import oracle.xml.jdwp.XSLJDWPDebugger;
import oracle.xml.jdwp.XSLJDWPPacket;

class XSLJDWPSocketConn
implements XSLJDWPConstants {
    Object receiveLock = new Object();
    Object sendLock = new Object();
    Socket socket;
    BufferedInputStream socketIn;
    BufferedOutputStream socketOut;

    XSLJDWPSocketConn(Socket socket) throws IOException {
        this.socket = socket;
        this.socket.setTcpNoDelay(true);
        this.socket.setSoTimeout(300);
        this.socketIn = new BufferedInputStream(this.socket.getInputStream());
        this.socketOut = new BufferedOutputStream(this.socket.getOutputStream());
    }

    void close() throws IOException {
        this.socketOut.flush();
        this.socketOut.close();
        this.socketIn.close();
        this.socket.close();
    }

    String receiveHandshake() throws IOException, InterruptedException {
        int n = "JDWP-Handshake".length();
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            this.socketIn.read(byArray, i, 1);
        }
        return new String(byArray, "US-ASCII");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XSLJDWPPacket receivePacket(boolean bl) throws IOException {
        Object object = this.receiveLock;
        synchronized (object) {
            int n;
            XSLJDWPPacket xSLJDWPPacket = new XSLJDWPPacket();
            int n2 = this.socketIn.read();
            int n3 = this.socketIn.read();
            int n4 = this.socketIn.read();
            int n5 = this.socketIn.read();
            if (n2 < 0 || n3 < 0 || n4 < 0 || n5 < 0) {
                throw new EOFException();
            }
            int n6 = (n2 << 24) + (n3 << 16) + (n4 << 8) + n5;
            n2 = this.socketIn.read();
            n3 = this.socketIn.read();
            n4 = this.socketIn.read();
            n5 = this.socketIn.read();
            if (n2 < 0 || n3 < 0 || n4 < 0 || n5 < 0) {
                throw new EOFException();
            }
            xSLJDWPPacket.id = (n2 << 24) + (n3 << 16) + (n4 << 8) + n5;
            xSLJDWPPacket.flags = (short)this.socketIn.read();
            if (xSLJDWPPacket.flags < 0) {
                throw new EOFException();
            }
            if ((xSLJDWPPacket.flags & 0x80) == 0) {
                xSLJDWPPacket.cmdSet = (short)this.socketIn.read();
                xSLJDWPPacket.cmd = (short)this.socketIn.read();
                if (xSLJDWPPacket.cmdSet < 0 || xSLJDWPPacket.cmd < 0) {
                    throw new EOFException();
                }
            } else {
                n2 = this.socketIn.read();
                n3 = this.socketIn.read();
                if (n2 < 0 || n3 < 0) {
                    throw new EOFException();
                }
                xSLJDWPPacket.errorCode = (short)((n2 << 8) + n3);
            }
            if ((n6 -= 11) < 0) {
                System.err.println("length is " + n6);
                System.err.println("Read is " + this.socketIn.read());
            }
            xSLJDWPPacket.data = new byte[n6];
            for (int i = 0; i < xSLJDWPPacket.data.length; i += n) {
                n = this.socketIn.read(xSLJDWPPacket.data, i, xSLJDWPPacket.data.length - i);
                if (n >= 0) continue;
                throw new EOFException();
            }
            if (bl) {
                XSLJDWPDebugger.dumpPacket(xSLJDWPPacket, false);
            }
            return xSLJDWPPacket;
        }
    }

    void sendHandshake() throws IOException {
        this.socketOut.write("JDWP-Handshake".getBytes(), 0, "JDWP-Handshake".length());
        this.socketOut.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendPacket(XSLJDWPPacket xSLJDWPPacket, boolean bl) throws IOException {
        Object object = this.sendLock;
        synchronized (object) {
            if (bl) {
                XSLJDWPDebugger.dumpPacket(xSLJDWPPacket, true);
            }
            int n = xSLJDWPPacket.data.length + 11;
            this.socketOut.write(n >>> 24 & 0xFF);
            this.socketOut.write(n >>> 16 & 0xFF);
            this.socketOut.write(n >>> 8 & 0xFF);
            this.socketOut.write(n & 0xFF);
            this.socketOut.write(xSLJDWPPacket.id >>> 24 & 0xFF);
            this.socketOut.write(xSLJDWPPacket.id >>> 16 & 0xFF);
            this.socketOut.write(xSLJDWPPacket.id >>> 8 & 0xFF);
            this.socketOut.write(xSLJDWPPacket.id & 0xFF);
            this.socketOut.write(xSLJDWPPacket.flags);
            if ((xSLJDWPPacket.flags & 0x80) == 0) {
                this.socketOut.write(xSLJDWPPacket.cmdSet);
                this.socketOut.write(xSLJDWPPacket.cmd);
            } else {
                this.socketOut.write(xSLJDWPPacket.errorCode >>> 8 & 0xFF);
                this.socketOut.write(xSLJDWPPacket.errorCode & 0xFF);
            }
            this.socketOut.write(xSLJDWPPacket.data);
            this.socketOut.flush();
        }
    }
}

