/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.jdwp;

import java.io.IOException;
import java.util.LinkedList;
import oracle.xml.jdwp.XSLJDWPConstants;
import oracle.xml.jdwp.XSLJDWPDebugger;
import oracle.xml.jdwp.XSLJDWPEvent;
import oracle.xml.jdwp.XSLJDWPOutQueue;
import oracle.xml.jdwp.XSLJDWPPacket;
import oracle.xml.jdwp.XSLJDWPPacketStream;
import oracle.xml.xslt.XSLStylesheet;

public class XSLJDWPEvents
implements XSLJDWPConstants {
    byte suspendPolicy = (byte)2;
    int events;
    LinkedList group;
    XSLStylesheet xss;
    boolean done = false;

    XSLJDWPEvents(XSLStylesheet xSLStylesheet) {
        this.xss = xSLStylesheet;
        this.init();
    }

    private void init() {
        this.events = 0;
        this.group = new LinkedList();
    }

    void add() {
        this.addToOutQueue();
    }

    void add(XSLJDWPEvent xSLJDWPEvent) {
        this.group.add(xSLJDWPEvent);
        ++this.events;
    }

    void setSuspendPolicy(byte by) {
        this.suspendPolicy = by;
    }

    byte getSuspendPolicy() {
        return this.suspendPolicy;
    }

    int getEvents() {
        return this.events;
    }

    XSLJDWPEvent getEvent(int n) {
        if (n >= this.events) {
            return null;
        }
        return (XSLJDWPEvent)this.group.get(n);
    }

    void setCompositeDone() {
        this.done = true;
    }

    void reset() {
        this.done = false;
        this.events = 0;
        this.group.clear();
    }

    private boolean canPickupEventGroup() {
        return this.done;
    }

    private void addToOutQueue() {
        XSLJDWPOutQueue xSLJDWPOutQueue = this.xss.getJDWPOutQueue();
        if (xSLJDWPOutQueue == null) {
            return;
        }
        if (this.group.size() == 0) {
            return;
        }
        XSLJDWPPacket xSLJDWPPacket = null;
        byte by = ((XSLJDWPEvent)this.group.getLast()).getEventKind();
        if (by == 90 || by == 99 || by == 6 || by == 7) {
            XSLJDWPPacketStream xSLJDWPPacketStream = ((XSLJDWPEvent)this.group.getLast()).getPacketStream();
            xSLJDWPPacketStream.writeByte(this.getSuspendPolicy());
            xSLJDWPPacketStream.writeInt(1);
            XSLJDWPEvent xSLJDWPEvent = (XSLJDWPEvent)this.group.removeLast();
            xSLJDWPPacket = xSLJDWPEvent.generatePacket();
            if (xSLJDWPEvent.getEventKind() == 90) {
                XSLJDWPDebugger xSLJDWPDebugger = this.xss.getJDWPDebugger();
                try {
                    xSLJDWPDebugger.sockconn.sendPacket(xSLJDWPPacket, true);
                }
                catch (IOException iOException) {}
            } else {
                xSLJDWPOutQueue.add(xSLJDWPPacket);
            }
            this.reset();
        } else if (by == 8) {
            XSLJDWPPacketStream xSLJDWPPacketStream = ((XSLJDWPEvent)this.group.getLast()).getPacketStream();
            xSLJDWPPacketStream.writeByte(this.getSuspendPolicy());
            xSLJDWPPacketStream.writeInt(1);
            XSLJDWPEvent xSLJDWPEvent = (XSLJDWPEvent)this.group.getLast();
            xSLJDWPPacket = xSLJDWPEvent.generatePacket();
            xSLJDWPOutQueue.add(xSLJDWPPacket);
        } else if (this.canPickupEventGroup()) {
            XSLJDWPPacketStream xSLJDWPPacketStream = ((XSLJDWPEvent)this.group.getLast()).getPacketStream();
            xSLJDWPPacketStream.writeByte(this.getSuspendPolicy());
            xSLJDWPPacketStream.writeInt(this.group.size());
            for (int i = 0; i < this.group.size(); ++i) {
                XSLJDWPEvent xSLJDWPEvent = (XSLJDWPEvent)this.group.get(i);
                xSLJDWPEvent.appendPacketStream(xSLJDWPPacketStream);
            }
            xSLJDWPPacketStream.close();
            xSLJDWPPacket = xSLJDWPPacketStream.packet();
            xSLJDWPOutQueue.add(xSLJDWPPacket);
        }
    }
}

