/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.compat;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import javax.net.ServerSocketFactory;
import org.apache.tomcat.util.compat.JdkCompat;

public class Jdk14Compat
extends JdkCompat {
    protected Jdk14Compat() {
    }

    public URL getURI(File file) throws MalformedURLException {
        File realFile = file;
        try {
            realFile = realFile.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return realFile.toURI().toURL();
    }

    public long getMaxMemory() {
        return Runtime.getRuntime().maxMemory();
    }

    public String getPartialServletStackTrace(Throwable t) {
        int i;
        StringBuffer trace = new StringBuffer();
        trace.append(t.toString()).append('\n');
        StackTraceElement[] elements = t.getStackTrace();
        int pos = elements.length;
        for (i = 0; i < elements.length; ++i) {
            if (!elements[i].getClassName().startsWith("org.apache.catalina.core.ApplicationFilterChain") || !elements[i].getMethodName().equals("internalDoFilter")) continue;
            pos = i;
        }
        for (i = 0; i < pos; ++i) {
            if (elements[i].getClassName().startsWith("org.apache.catalina.core.")) continue;
            trace.append('\t').append(elements[i].toString()).append('\n');
        }
        return trace.toString();
    }

    public String[] split(String path, String pat) {
        return path.split(pat);
    }

    public void chainException(Throwable wrapper, Throwable wrapped) {
        wrapper.initCause(wrapped);
    }

    public ServerSocket getUnboundSocket(ServerSocketFactory ssf) throws IOException {
        return ssf.createServerSocket();
    }
}

