/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util.regexp;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.util.ClasspathUtils;
import org.apache.tools.ant.util.JavaEnvUtils;
import org.apache.tools.ant.util.regexp.RegexpMatcher;

public class RegexpMatcherFactory {
    public RegexpMatcher newRegexpMatcher() throws BuildException {
        return this.newRegexpMatcher(null);
    }

    public RegexpMatcher newRegexpMatcher(Project project) throws BuildException {
        String string = null;
        string = project == null ? System.getProperty("ant.regexp.regexpimpl") : project.getProperty("ant.regexp.regexpimpl");
        if (string != null) {
            return this.createInstance(string);
        }
        Throwable throwable = null;
        try {
            this.testAvailability("java.util.regex.Matcher");
            return this.createInstance("org.apache.tools.ant.util.regexp.Jdk14RegexpMatcher");
        }
        catch (BuildException buildException) {
            throwable = RegexpMatcherFactory.orCause(throwable, buildException, JavaEnvUtils.getJavaVersionNumber() < 14);
            try {
                this.testAvailability("org.apache.oro.text.regex.Pattern");
                return this.createInstance("org.apache.tools.ant.util.regexp.JakartaOroMatcher");
            }
            catch (BuildException buildException2) {
                throwable = RegexpMatcherFactory.orCause(throwable, buildException2, true);
                try {
                    this.testAvailability("org.apache.regexp.RE");
                    return this.createInstance("org.apache.tools.ant.util.regexp.JakartaRegexpMatcher");
                }
                catch (BuildException buildException3) {
                    throwable = RegexpMatcherFactory.orCause(throwable, buildException3, true);
                    throw new BuildException("No supported regular expression matcher found" + (throwable != null ? ": " + throwable : ""), throwable);
                }
            }
        }
    }

    static Throwable orCause(Throwable throwable, BuildException buildException, boolean bl) {
        if (throwable != null) {
            return throwable;
        }
        Throwable throwable2 = buildException.getException();
        return bl && throwable2 instanceof ClassNotFoundException ? null : throwable2;
    }

    protected RegexpMatcher createInstance(String string) throws BuildException {
        return (RegexpMatcher)ClasspathUtils.newInstance(string, RegexpMatcherFactory.class.getClassLoader(), RegexpMatcher.class);
    }

    protected void testAvailability(String string) throws BuildException {
        try {
            Class.forName(string);
        }
        catch (Throwable throwable) {
            throw new BuildException(throwable);
        }
    }

    public static boolean regexpMatcherPresent(Project project) {
        try {
            new RegexpMatcherFactory().newRegexpMatcher(project);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }
}

