/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util.regexp;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.util.ClasspathUtils;
import org.apache.tools.ant.util.JavaEnvUtils;
import org.apache.tools.ant.util.regexp.Regexp;
import org.apache.tools.ant.util.regexp.RegexpMatcherFactory;

public class RegexpFactory
extends RegexpMatcherFactory {
    public Regexp newRegexp() throws BuildException {
        return this.newRegexp(null);
    }

    public Regexp newRegexp(Project project) throws BuildException {
        String string = null;
        string = project == null ? System.getProperty("ant.regexp.regexpimpl") : project.getProperty("ant.regexp.regexpimpl");
        if (string != null) {
            return this.createRegexpInstance(string);
        }
        Throwable throwable = null;
        try {
            this.testAvailability("java.util.regex.Matcher");
            return this.createRegexpInstance("org.apache.tools.ant.util.regexp.Jdk14RegexpRegexp");
        }
        catch (BuildException buildException) {
            throwable = RegexpFactory.orCause(throwable, buildException, JavaEnvUtils.getJavaVersionNumber() < 14);
            try {
                this.testAvailability("org.apache.oro.text.regex.Pattern");
                return this.createRegexpInstance("org.apache.tools.ant.util.regexp.JakartaOroRegexp");
            }
            catch (BuildException buildException2) {
                throwable = RegexpFactory.orCause(throwable, buildException2, true);
                try {
                    this.testAvailability("org.apache.regexp.RE");
                    return this.createRegexpInstance("org.apache.tools.ant.util.regexp.JakartaRegexpRegexp");
                }
                catch (BuildException buildException3) {
                    throwable = RegexpFactory.orCause(throwable, buildException3, true);
                    throw new BuildException("No supported regular expression matcher found" + (throwable != null ? ": " + throwable : ""), throwable);
                }
            }
        }
    }

    protected Regexp createRegexpInstance(String string) throws BuildException {
        return (Regexp)ClasspathUtils.newInstance(string, RegexpFactory.class.getClassLoader(), Regexp.class);
    }
}

