/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Vector;

public final class StringUtils {
    private static final long KILOBYTE = 1024L;
    private static final long MEGABYTE = 0x100000L;
    private static final long GIGABYTE = 0x40000000L;
    private static final long TERABYTE = 0x10000000000L;
    private static final long PETABYTE = 0x4000000000000L;
    public static final String LINE_SEP = System.getProperty("line.separator");

    private StringUtils() {
    }

    public static Vector lineSplit(String string) {
        return StringUtils.split(string, 10);
    }

    public static Vector split(String string, int n) {
        Vector<String> vector = new Vector<String>();
        int n2 = -1;
        int n3 = 0;
        while ((n2 = string.indexOf(n, n3)) != -1) {
            String string2 = string.substring(n3, n2);
            vector.addElement(string2);
            n3 = n2 + 1;
        }
        vector.addElement(string.substring(n3));
        return vector;
    }

    public static String replace(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = -1;
        int n2 = 0;
        while ((n = string.indexOf(string2, n2)) != -1) {
            stringBuffer.append(string.substring(n2, n)).append(string3);
            n2 = n + string2.length();
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        printWriter.close();
        return stringWriter.toString();
    }

    public static boolean endsWith(StringBuffer stringBuffer, String string) {
        if (string.length() > stringBuffer.length()) {
            return false;
        }
        int n = stringBuffer.length() - 1;
        for (int i = string.length() - 1; i >= 0; --i) {
            if (stringBuffer.charAt(n) != string.charAt(i)) {
                return false;
            }
            --n;
        }
        return true;
    }

    public static String resolveBackSlash(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!bl) {
                if (c == '\\') {
                    bl = true;
                    continue;
                }
                stringBuffer.append(c);
                continue;
            }
            switch (c) {
                case '\\': {
                    stringBuffer.append('\\');
                    break;
                }
                case 'n': {
                    stringBuffer.append('\n');
                    break;
                }
                case 'r': {
                    stringBuffer.append('\r');
                    break;
                }
                case 't': {
                    stringBuffer.append('\t');
                    break;
                }
                case 'f': {
                    stringBuffer.append('\f');
                    break;
                }
                case 's': {
                    stringBuffer.append(" \t\n\r\f");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            bl = false;
        }
        return stringBuffer.toString();
    }

    public static long parseHumanSizes(String string) throws Exception {
        long l = 1L;
        char c = string.charAt(0);
        switch (c) {
            case '+': {
                string = string.substring(1);
                break;
            }
            case '-': {
                l = -1L;
                string = string.substring(1);
                break;
            }
        }
        char c2 = string.charAt(string.length() - 1);
        if (!Character.isDigit(c2)) {
            int n = 1;
            switch (c2) {
                case 'K': {
                    l *= 1024L;
                    break;
                }
                case 'M': {
                    l *= 0x100000L;
                    break;
                }
                case 'G': {
                    l *= 0x40000000L;
                    break;
                }
                case 'T': {
                    l *= 0x10000000000L;
                    break;
                }
                case 'P': {
                    l *= 0x4000000000000L;
                    break;
                }
                default: {
                    n = 0;
                }
            }
            string = string.substring(0, string.length() - n);
        }
        return l * Long.parseLong(string);
    }

    public static String removeSuffix(String string, String string2) {
        if (string.endsWith(string2)) {
            return string.substring(0, string.length() - string2.length());
        }
        return string;
    }

    public static String removePrefix(String string, String string2) {
        if (string.startsWith(string2)) {
            return string.substring(string2.length());
        }
        return string;
    }
}

