/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.filters.util.ChainReaderHelper;
import org.apache.tools.ant.types.FilterSetCollection;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.ResourceFactory;
import org.apache.tools.ant.types.TimeComparison;
import org.apache.tools.ant.types.resources.Resources;
import org.apache.tools.ant.types.resources.Restrict;
import org.apache.tools.ant.types.resources.Touchable;
import org.apache.tools.ant.types.resources.Union;
import org.apache.tools.ant.types.resources.selectors.Date;
import org.apache.tools.ant.types.resources.selectors.Exists;
import org.apache.tools.ant.types.resources.selectors.Not;
import org.apache.tools.ant.types.resources.selectors.ResourceSelector;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.LineTokenizer;

public class ResourceUtils {
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private static final ResourceSelector NOT_EXISTS = new Not(new Exists());

    public static Resource[] selectOutOfDateSources(ProjectComponent projectComponent, Resource[] resourceArray, FileNameMapper fileNameMapper, ResourceFactory resourceFactory) {
        return ResourceUtils.selectOutOfDateSources(projectComponent, resourceArray, fileNameMapper, resourceFactory, FILE_UTILS.getFileTimestampGranularity());
    }

    public static Resource[] selectOutOfDateSources(ProjectComponent projectComponent, Resource[] resourceArray, FileNameMapper fileNameMapper, ResourceFactory resourceFactory, long l) {
        Union union = new Union();
        union.addAll(Arrays.asList(resourceArray));
        ResourceCollection resourceCollection = ResourceUtils.selectOutOfDateSources(projectComponent, union, fileNameMapper, resourceFactory, l);
        return resourceCollection.size() == 0 ? new Resource[]{} : ((Union)resourceCollection).listResources();
    }

    public static ResourceCollection selectOutOfDateSources(ProjectComponent projectComponent, ResourceCollection resourceCollection, FileNameMapper fileNameMapper, ResourceFactory resourceFactory, final long l) {
        if (resourceCollection.size() == 0) {
            projectComponent.log("No sources found.", 3);
            return Resources.NONE;
        }
        resourceCollection = Union.getInstance(resourceCollection);
        ResourceUtils.logFuture(projectComponent, resourceCollection, l);
        Union union = new Union();
        Iterator iterator = resourceCollection.iterator();
        while (iterator.hasNext()) {
            final Resource resource = (Resource)iterator.next();
            String string = resource.getName();
            string = string == null ? string : string.replace('/', File.separatorChar);
            String[] stringArray = null;
            try {
                stringArray = fileNameMapper.mapFileName(string);
            }
            catch (Exception exception) {
                projectComponent.log("Caught " + exception + " mapping resource " + resource, 3);
            }
            if (stringArray == null || stringArray.length == 0) {
                projectComponent.log(resource + " skipped - don't know how to handle it", 3);
                continue;
            }
            Union union2 = new Union();
            for (int i = 0; i < stringArray.length; ++i) {
                union2.add(resourceFactory.getResource(stringArray[i].replace(File.separatorChar, '/')));
            }
            Restrict restrict = new Restrict();
            restrict.add(new ResourceSelector(){

                @Override
                public boolean isSelected(Resource resource2) {
                    return SelectorUtils.isOutOfDate(resource, resource2, l);
                }
            });
            restrict.add(union2);
            if (restrict.size() > 0) {
                union.add(resource);
                Resource resource2 = (Resource)restrict.iterator().next();
                projectComponent.log(resource.getName() + " added as " + resource2.getName() + (resource2.isExists() ? " is outdated." : " doesn't exist."), 3);
                continue;
            }
            projectComponent.log(resource.getName() + " omitted as " + union2.toString() + (union2.size() == 1 ? " is" : " are ") + " up to date.", 3);
        }
        return union;
    }

    public static void copyResource(Resource resource, Resource resource2) throws IOException {
        ResourceUtils.copyResource(resource, resource2, null);
    }

    public static void copyResource(Resource resource, Resource resource2, Project project) throws IOException {
        ResourceUtils.copyResource(resource, resource2, null, null, false, false, null, null, project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyResource(Resource resource, Resource resource2, FilterSetCollection filterSetCollection, Vector vector, boolean bl, boolean bl2, String string, String string2, Project project) throws IOException {
        block17: {
            block18: {
                boolean bl3;
                block16: {
                    if (!bl) {
                        long l = resource.getLastModified();
                        if (resource2.isExists() && l != 0L && resource2.getLastModified() > l) {
                            return;
                        }
                    }
                    boolean bl4 = filterSetCollection != null && filterSetCollection.hasFilters();
                    boolean bl5 = bl3 = vector != null && vector.size() > 0;
                    if (!bl4) break block16;
                    BufferedReader bufferedReader = null;
                    BufferedWriter bufferedWriter = null;
                    try {
                        Object object;
                        Object object2;
                        InputStreamReader inputStreamReader = null;
                        inputStreamReader = string == null ? new InputStreamReader(resource.getInputStream()) : new InputStreamReader(resource.getInputStream(), string);
                        bufferedReader = new BufferedReader(inputStreamReader);
                        OutputStreamWriter outputStreamWriter = null;
                        outputStreamWriter = string2 == null ? new OutputStreamWriter(resource2.getOutputStream()) : new OutputStreamWriter(resource2.getOutputStream(), string2);
                        bufferedWriter = new BufferedWriter(outputStreamWriter);
                        if (bl3) {
                            object2 = new ChainReaderHelper();
                            ((ChainReaderHelper)object2).setBufferSize(8192);
                            ((ChainReaderHelper)object2).setPrimaryReader(bufferedReader);
                            ((ChainReaderHelper)object2).setFilterChains(vector);
                            ((ChainReaderHelper)object2).setProject(project);
                            object = ((ChainReaderHelper)object2).getAssembledReader();
                            bufferedReader = new BufferedReader((Reader)object);
                        }
                        object2 = new LineTokenizer();
                        ((LineTokenizer)object2).setIncludeDelims(true);
                        object = null;
                        String string3 = ((LineTokenizer)object2).getToken(bufferedReader);
                        while (string3 != null) {
                            if (string3.length() == 0) {
                                bufferedWriter.newLine();
                            } else {
                                object = filterSetCollection.replaceTokens(string3);
                                bufferedWriter.write((String)object);
                            }
                            string3 = ((LineTokenizer)object2).getToken(bufferedReader);
                        }
                    }
                    catch (Throwable throwable) {
                        FileUtils.close(bufferedWriter);
                        FileUtils.close(bufferedReader);
                        throw throwable;
                    }
                    FileUtils.close(bufferedWriter);
                    FileUtils.close(bufferedReader);
                    break block17;
                }
                if (!bl3 && (string == null || string.equals(string2)) && (string != null || string2 == null)) break block18;
                BufferedReader bufferedReader = null;
                BufferedWriter bufferedWriter = null;
                try {
                    int n;
                    Object object;
                    InputStreamReader inputStreamReader = null;
                    inputStreamReader = string == null ? new InputStreamReader(resource.getInputStream()) : new InputStreamReader(resource.getInputStream(), string);
                    bufferedReader = new BufferedReader(inputStreamReader);
                    OutputStreamWriter outputStreamWriter = null;
                    outputStreamWriter = string2 == null ? new OutputStreamWriter(resource2.getOutputStream()) : new OutputStreamWriter(resource2.getOutputStream(), string2);
                    bufferedWriter = new BufferedWriter(outputStreamWriter);
                    if (bl3) {
                        object = new ChainReaderHelper();
                        ((ChainReaderHelper)object).setBufferSize(8192);
                        ((ChainReaderHelper)object).setPrimaryReader(bufferedReader);
                        ((ChainReaderHelper)object).setFilterChains(vector);
                        ((ChainReaderHelper)object).setProject(project);
                        Reader reader = ((ChainReaderHelper)object).getAssembledReader();
                        bufferedReader = new BufferedReader(reader);
                    }
                    object = new char[8192];
                    while ((n = bufferedReader.read((char[])object, 0, ((Object)object).length)) != -1) {
                        bufferedWriter.write((char[])object, 0, n);
                    }
                }
                catch (Throwable throwable) {
                    FileUtils.close(bufferedWriter);
                    FileUtils.close(bufferedReader);
                    throw throwable;
                }
                FileUtils.close(bufferedWriter);
                FileUtils.close(bufferedReader);
                break block17;
            }
            InputStream inputStream = null;
            OutputStream outputStream = null;
            try {
                inputStream = resource.getInputStream();
                outputStream = resource2.getOutputStream();
                byte[] byArray = new byte[8192];
                int n = 0;
                do {
                    outputStream.write(byArray, 0, n);
                } while ((n = inputStream.read(byArray, 0, byArray.length)) != -1);
            }
            catch (Throwable throwable) {
                FileUtils.close(outputStream);
                FileUtils.close(inputStream);
                throw throwable;
            }
            FileUtils.close(outputStream);
            FileUtils.close(inputStream);
        }
        if (bl2 && resource2 instanceof Touchable) {
            ResourceUtils.setLastModified((Touchable)((Object)resource2), resource.getLastModified());
        }
    }

    public static void setLastModified(Touchable touchable, long l) {
        touchable.touch(l < 0L ? System.currentTimeMillis() : l);
    }

    public static boolean contentEquals(Resource resource, Resource resource2, boolean bl) throws IOException {
        if (resource.isExists() != resource2.isExists()) {
            return false;
        }
        if (!resource.isExists()) {
            return true;
        }
        if (resource.isDirectory() || resource2.isDirectory()) {
            return false;
        }
        if (resource.equals(resource2)) {
            return true;
        }
        if (!bl) {
            long l = resource.getSize();
            long l2 = resource2.getSize();
            if (l != -1L && l2 != -1L && l != l2) {
                return false;
            }
        }
        return ResourceUtils.compareContent(resource, resource2, bl) == 0;
    }

    public static int compareContent(Resource resource, Resource resource2, boolean bl) throws IOException {
        if (resource.equals(resource2)) {
            return 0;
        }
        boolean bl2 = resource.isExists();
        boolean bl3 = resource2.isExists();
        if (!bl2 && !bl3) {
            return 0;
        }
        if (bl2 != bl3) {
            return bl2 ? 1 : -1;
        }
        boolean bl4 = resource.isDirectory();
        boolean bl5 = resource2.isDirectory();
        if (bl4 && bl5) {
            return 0;
        }
        if (bl4 || bl5) {
            return bl4 ? -1 : 1;
        }
        return bl ? ResourceUtils.textCompare(resource, resource2) : ResourceUtils.binaryCompare(resource, resource2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int binaryCompare(Resource var0, Resource var1_1) throws IOException {
        block5: {
            var2_2 = null;
            var3_3 = null;
            try {
                var2_2 = new BufferedInputStream(var0.getInputStream());
                var3_3 = new BufferedInputStream(var1_1.getInputStream());
                var4_4 = var2_2.read();
lbl7:
                // 2 sources

                while (var4_4 != -1) {
                    var5_5 = var3_3.read();
                    if (var4_4 != var5_5) {
                        var6_6 = var4_4 > var5_5 ? 1 : -1;
                        break block5;
                    }
                    ** GOTO lbl-1000
                }
                ** GOTO lbl24
            }
            catch (Throwable var7_7) {
                FileUtils.close(var2_2);
                FileUtils.close(var3_3);
                throw var7_7;
            }
        }
        FileUtils.close(var2_2);
        FileUtils.close(var3_3);
        return var6_6;
lbl-1000:
        // 1 sources

        {
            var4_4 = var2_2.read();
            ** GOTO lbl7
lbl24:
            // 1 sources

            var4_4 = var3_3.read() == -1 ? 0 : -1;
        }
        FileUtils.close(var2_2);
        FileUtils.close(var3_3);
        return var4_4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int textCompare(Resource resource, Resource resource2) throws IOException {
        int n;
        BufferedReader bufferedReader;
        BufferedReader bufferedReader2;
        block5: {
            int n2;
            bufferedReader2 = null;
            bufferedReader = null;
            try {
                bufferedReader2 = new BufferedReader(new InputStreamReader(resource.getInputStream()));
                bufferedReader = new BufferedReader(new InputStreamReader(resource2.getInputStream()));
                String string = bufferedReader2.readLine();
                while (string != null) {
                    String string2 = bufferedReader.readLine();
                    if (!string.equals(string2)) {
                        n = string.compareTo(string2);
                        break block5;
                    }
                    string = bufferedReader2.readLine();
                }
                n2 = bufferedReader.readLine() == null ? 0 : -1;
            }
            catch (Throwable throwable) {
                FileUtils.close(bufferedReader2);
                FileUtils.close(bufferedReader);
                throw throwable;
            }
            FileUtils.close(bufferedReader2);
            FileUtils.close(bufferedReader);
            return n2;
        }
        FileUtils.close(bufferedReader2);
        FileUtils.close(bufferedReader);
        return n;
    }

    private static void logFuture(ProjectComponent projectComponent, ResourceCollection resourceCollection, long l) {
        long l2 = System.currentTimeMillis() + l;
        Date date = new Date();
        date.setMillis(l2);
        date.setWhen(TimeComparison.AFTER);
        Restrict restrict = new Restrict();
        restrict.add(date);
        restrict.add(resourceCollection);
        Iterator iterator = restrict.iterator();
        while (iterator.hasNext()) {
            projectComponent.log("Warning: " + ((Resource)iterator.next()).getName() + " modified in the future.", 1);
        }
    }
}

