/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.PathTokenizer;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.launch.Locator;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.types.FilterSetCollection;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.util.ResourceUtils;
import org.apache.tools.ant.util.StringUtils;

public class FileUtils {
    private static final int EXPAND_SPACE = 50;
    private static final FileUtils PRIMARY_INSTANCE = new FileUtils();
    private static Random rand = new Random(System.currentTimeMillis() + Runtime.getRuntime().freeMemory());
    private static final boolean ON_NETWARE = Os.isFamily("netware");
    private static final boolean ON_DOS = Os.isFamily("dos");
    private static final boolean ON_WIN9X = Os.isFamily("win9x");
    private static final boolean ON_WINDOWS = Os.isFamily("windows");
    static final int BUF_SIZE = 8192;
    public static final long FAT_FILE_TIMESTAMP_GRANULARITY = 2000L;
    public static final long UNIX_FILE_TIMESTAMP_GRANULARITY = 1000L;
    public static final long NTFS_FILE_TIMESTAMP_GRANULARITY = 1L;
    private Object cacheFromUriLock = new Object();
    private String cacheFromUriRequest = null;
    private String cacheFromUriResponse = null;

    public static FileUtils newFileUtils() {
        return new FileUtils();
    }

    public static FileUtils getFileUtils() {
        return PRIMARY_INSTANCE;
    }

    protected FileUtils() {
    }

    public URL getFileURL(File file) throws MalformedURLException {
        return new URL(this.toURI(file.getAbsolutePath()));
    }

    public void copyFile(String string, String string2) throws IOException {
        this.copyFile(new File(string), new File(string2), null, false, false);
    }

    public void copyFile(String string, String string2, FilterSetCollection filterSetCollection) throws IOException {
        this.copyFile(new File(string), new File(string2), filterSetCollection, false, false);
    }

    public void copyFile(String string, String string2, FilterSetCollection filterSetCollection, boolean bl) throws IOException {
        this.copyFile(new File(string), new File(string2), filterSetCollection, bl, false);
    }

    public void copyFile(String string, String string2, FilterSetCollection filterSetCollection, boolean bl, boolean bl2) throws IOException {
        this.copyFile(new File(string), new File(string2), filterSetCollection, bl, bl2);
    }

    public void copyFile(String string, String string2, FilterSetCollection filterSetCollection, boolean bl, boolean bl2, String string3) throws IOException {
        this.copyFile(new File(string), new File(string2), filterSetCollection, bl, bl2, string3);
    }

    public void copyFile(String string, String string2, FilterSetCollection filterSetCollection, Vector vector, boolean bl, boolean bl2, String string3, Project project) throws IOException {
        this.copyFile(new File(string), new File(string2), filterSetCollection, vector, bl, bl2, string3, project);
    }

    public void copyFile(String string, String string2, FilterSetCollection filterSetCollection, Vector vector, boolean bl, boolean bl2, String string3, String string4, Project project) throws IOException {
        this.copyFile(new File(string), new File(string2), filterSetCollection, vector, bl, bl2, string3, string4, project);
    }

    public void copyFile(File file, File file2) throws IOException {
        this.copyFile(file, file2, null, false, false);
    }

    public void copyFile(File file, File file2, FilterSetCollection filterSetCollection) throws IOException {
        this.copyFile(file, file2, filterSetCollection, false, false);
    }

    public void copyFile(File file, File file2, FilterSetCollection filterSetCollection, boolean bl) throws IOException {
        this.copyFile(file, file2, filterSetCollection, bl, false);
    }

    public void copyFile(File file, File file2, FilterSetCollection filterSetCollection, boolean bl, boolean bl2) throws IOException {
        this.copyFile(file, file2, filterSetCollection, bl, bl2, null);
    }

    public void copyFile(File file, File file2, FilterSetCollection filterSetCollection, boolean bl, boolean bl2, String string) throws IOException {
        this.copyFile(file, file2, filterSetCollection, null, bl, bl2, string, null);
    }

    public void copyFile(File file, File file2, FilterSetCollection filterSetCollection, Vector vector, boolean bl, boolean bl2, String string, Project project) throws IOException {
        this.copyFile(file, file2, filterSetCollection, vector, bl, bl2, string, string, project);
    }

    public void copyFile(File file, File file2, FilterSetCollection filterSetCollection, Vector vector, boolean bl, boolean bl2, String string, String string2, Project project) throws IOException {
        ResourceUtils.copyResource(new FileResource(file), new FileResource(file2), filterSetCollection, vector, bl, bl2, string, string2, project);
    }

    public void setFileLastModified(File file, long l) {
        ResourceUtils.setLastModified(new FileResource(file), l);
    }

    public File resolveFile(File file, String string) {
        if (!FileUtils.isAbsolutePath(string)) {
            char c = File.separatorChar;
            if (FileUtils.isContextRelativePath(string = string.replace('/', c).replace('\\', c))) {
                file = null;
                String string2 = System.getProperty("user.dir");
                if (string.charAt(0) == c && string2.charAt(0) == c) {
                    string = this.dissect(string2)[0] + string.substring(1);
                }
            }
            string = new File(file, string).getAbsolutePath();
        }
        return this.normalize(string);
    }

    public static boolean isContextRelativePath(String string) {
        if (!ON_DOS && !ON_NETWARE || string.length() == 0) {
            return false;
        }
        char c = File.separatorChar;
        string = string.replace('/', c).replace('\\', c);
        char c2 = string.charAt(0);
        int n = string.length();
        return c2 == c && (n == 1 || string.charAt(1) != c) || Character.isLetter(c2) && n > 1 && string.indexOf(58) == 1 && (n == 2 || string.charAt(2) != c);
    }

    public static boolean isAbsolutePath(String string) {
        int n = string.length();
        if (n == 0) {
            return false;
        }
        char c = File.separatorChar;
        string = string.replace('/', c).replace('\\', c);
        char c2 = string.charAt(0);
        if (!ON_DOS && !ON_NETWARE) {
            return c2 == c;
        }
        if (c2 == c) {
            if (!ON_DOS || n <= 4 || string.charAt(1) != c) {
                return false;
            }
            int n2 = string.indexOf(c, 2);
            return n2 > 2 && n2 + 1 < n;
        }
        int n3 = string.indexOf(58);
        return Character.isLetter(c2) && n3 == 1 && string.length() > 2 && string.charAt(2) == c || ON_NETWARE && n3 > 0;
    }

    public static String translatePath(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 50);
        PathTokenizer pathTokenizer = new PathTokenizer(string);
        while (pathTokenizer.hasMoreTokens()) {
            String string2 = pathTokenizer.nextToken();
            string2 = string2.replace('/', File.separatorChar);
            string2 = string2.replace('\\', File.separatorChar);
            if (stringBuffer.length() != 0) {
                stringBuffer.append(File.pathSeparatorChar);
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public File normalize(String string) {
        CharSequence charSequence;
        Stack<CharSequence> stack = new Stack<CharSequence>();
        String[] stringArray = this.dissect(string);
        stack.push(stringArray[0]);
        StringTokenizer stringTokenizer = new StringTokenizer(stringArray[1], File.separator);
        while (stringTokenizer.hasMoreTokens()) {
            charSequence = stringTokenizer.nextToken();
            if (".".equals(charSequence)) continue;
            if ("..".equals(charSequence)) {
                if (stack.size() < 2) {
                    return new File(string);
                }
                stack.pop();
                continue;
            }
            stack.push(charSequence);
        }
        charSequence = new StringBuffer();
        for (int i = 0; i < stack.size(); ++i) {
            if (i > 1) {
                ((StringBuffer)charSequence).append(File.separatorChar);
            }
            ((StringBuffer)charSequence).append(stack.elementAt(i));
        }
        return new File(((StringBuffer)charSequence).toString());
    }

    public String[] dissect(String string) {
        char c = File.separatorChar;
        if (!FileUtils.isAbsolutePath(string = string.replace('/', c).replace('\\', c))) {
            throw new BuildException(string + " is not an absolute path");
        }
        String string2 = null;
        int n = string.indexOf(58);
        if (n > 0 && (ON_DOS || ON_NETWARE)) {
            int n2 = n + 1;
            string2 = string.substring(0, n2);
            char[] cArray = string.toCharArray();
            string2 = string2 + c;
            n2 = cArray[n2] == c ? n2 + 1 : n2;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = n2; i < cArray.length; ++i) {
                if (cArray[i] == c && cArray[i - 1] == c) continue;
                stringBuffer.append(cArray[i]);
            }
            string = stringBuffer.toString();
        } else if (string.length() > 1 && string.charAt(1) == c) {
            int n3 = string.indexOf(c, 2);
            string2 = (n3 = string.indexOf(c, n3 + 1)) > 2 ? string.substring(0, n3 + 1) : string;
            string = string.substring(string2.length());
        } else {
            string2 = File.separator;
            string = string.substring(1);
        }
        return new String[]{string2, string};
    }

    public String toVMSPath(File file) {
        String string = this.normalize(file.getAbsolutePath()).getPath();
        String string2 = file.getName();
        boolean bl = string.charAt(0) == File.separatorChar;
        boolean bl2 = file.isDirectory() && !string2.regionMatches(true, string2.length() - 4, ".DIR", 0, 4);
        String string3 = null;
        StringBuffer stringBuffer = null;
        String string4 = null;
        int n = 0;
        if (bl) {
            n = string.indexOf(File.separatorChar, 1);
            if (n == -1) {
                return string.substring(1) + ":[000000]";
            }
            string3 = string.substring(1, n++);
        }
        if (bl2) {
            stringBuffer = new StringBuffer(string.substring(n).replace(File.separatorChar, '.'));
        } else {
            int n2 = string.lastIndexOf(File.separatorChar, string.length());
            if (n2 == -1 || n2 < n) {
                string4 = string.substring(n);
            } else {
                stringBuffer = new StringBuffer(string.substring(n, n2).replace(File.separatorChar, '.'));
                n = n2 + 1;
                if (string.length() > n) {
                    string4 = string.substring(n);
                }
            }
        }
        if (!bl && stringBuffer != null) {
            stringBuffer.insert(0, '.');
        }
        String string5 = (string3 != null ? string3 + ":" : "") + (stringBuffer != null ? "[" + stringBuffer + "]" : "") + (string4 != null ? string4 : "");
        return string5;
    }

    public File createTempFile(String string, String string2, File file) {
        return this.createTempFile(string, string2, file, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File createTempFile(String string, String string2, File file, boolean bl, boolean bl2) {
        String string3;
        File file2 = null;
        String string4 = string3 = file == null ? System.getProperty("java.io.tmpdir") : file.getPath();
        if (bl2) {
            try {
                file2 = File.createTempFile(string, string2, new File(string3));
            }
            catch (IOException iOException) {
                throw new BuildException("Could not create tempfile in " + string3, iOException);
            }
        }
        DecimalFormat decimalFormat = new DecimalFormat("#####");
        Random random = rand;
        synchronized (random) {
            while ((file2 = new File(string3, string + decimalFormat.format(Math.abs(rand.nextInt())) + string2)).exists()) {
            }
        }
        if (bl) {
            file2.deleteOnExit();
        }
        return file2;
    }

    public File createTempFile(String string, String string2, File file, boolean bl) {
        return this.createTempFile(string, string2, file, bl, false);
    }

    public boolean contentEquals(File file, File file2) throws IOException {
        return this.contentEquals(file, file2, false);
    }

    public boolean contentEquals(File file, File file2, boolean bl) throws IOException {
        return ResourceUtils.contentEquals(new FileResource(file), new FileResource(file2), bl);
    }

    public File getParentFile(File file) {
        return file == null ? null : file.getParentFile();
    }

    public static String readFully(Reader reader) throws IOException {
        return FileUtils.readFully(reader, 8192);
    }

    public static String readFully(Reader reader, int n) throws IOException {
        if (n <= 0) {
            throw new IllegalArgumentException("Buffer size must be greater than 0");
        }
        char[] cArray = new char[n];
        int n2 = 0;
        StringBuffer stringBuffer = null;
        while (n2 != -1) {
            n2 = reader.read(cArray);
            if (n2 <= 0) continue;
            stringBuffer = stringBuffer == null ? new StringBuffer() : stringBuffer;
            stringBuffer.append(new String(cArray, 0, n2));
        }
        return stringBuffer == null ? null : stringBuffer.toString();
    }

    public static String safeReadFully(Reader reader) throws IOException {
        String string = FileUtils.readFully(reader);
        return string == null ? "" : string;
    }

    public boolean createNewFile(File file) throws IOException {
        return file.createNewFile();
    }

    public boolean createNewFile(File file, boolean bl) throws IOException {
        File file2 = file.getParentFile();
        if (bl && !file2.exists()) {
            file2.mkdirs();
        }
        return file.createNewFile();
    }

    public boolean isSymbolicLink(File file, String string) throws IOException {
        File file2;
        if (file == null) {
            file2 = new File(string);
            file = file2.getParentFile();
            string = file2.getName();
        }
        return !(file2 = new File(file.getCanonicalPath(), string)).getAbsolutePath().equals(file2.getCanonicalPath());
    }

    public String removeLeadingPath(File file, File file2) {
        String string;
        String string2 = this.normalize(file.getAbsolutePath()).getAbsolutePath();
        if (string2.equals(string = this.normalize(file2.getAbsolutePath()).getAbsolutePath())) {
            return "";
        }
        if (!string2.endsWith(File.separator)) {
            string2 = string2 + File.separator;
        }
        return string.startsWith(string2) ? string.substring(string2.length()) : string;
    }

    public boolean isLeadingPath(File file, File file2) {
        String string;
        String string2 = this.normalize(file.getAbsolutePath()).getAbsolutePath();
        if (string2.equals(string = this.normalize(file2.getAbsolutePath()).getAbsolutePath())) {
            return true;
        }
        if (!string2.endsWith(File.separator)) {
            string2 = string2 + File.separator;
        }
        return string.startsWith(string2);
    }

    public String toURI(String string) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("java.net.URI");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz != null) {
            try {
                File file = new File(string).getAbsoluteFile();
                Method method = File.class.getMethod("toURI", new Class[0]);
                Object object = method.invoke((Object)file, new Object[0]);
                Method method2 = clazz.getMethod("toASCIIString", new Class[0]);
                return (String)method2.invoke(object, new Object[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        boolean bl = new File(string).isDirectory();
        StringBuffer stringBuffer = new StringBuffer("file:");
        string = this.resolveFile(null, string).getPath();
        stringBuffer.append("//");
        if (!string.startsWith(File.separator)) {
            stringBuffer.append("/");
        }
        string = string.replace('\\', '/');
        try {
            stringBuffer.append(Locator.encodeURI((String)string));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new BuildException(unsupportedEncodingException);
        }
        if (bl && !string.endsWith("/")) {
            stringBuffer.append('/');
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String fromURI(String string) {
        Object object = this.cacheFromUriLock;
        synchronized (object) {
            if (string.equals(this.cacheFromUriRequest)) {
                return this.cacheFromUriResponse;
            }
            String string2 = Locator.fromURI((String)string);
            String string3 = FileUtils.isAbsolutePath(string2) ? this.normalize(string2).getAbsolutePath() : string2;
            this.cacheFromUriRequest = string;
            this.cacheFromUriResponse = string3;
            return string3;
        }
    }

    public boolean fileNameEquals(File file, File file2) {
        return this.normalize(file.getAbsolutePath()).getAbsolutePath().equals(this.normalize(file2.getAbsolutePath()).getAbsolutePath());
    }

    public void rename(File file, File file2) throws IOException {
        file = this.normalize(file.getAbsolutePath()).getCanonicalFile();
        file2 = this.normalize(file2.getAbsolutePath());
        if (!file.exists()) {
            System.err.println("Cannot rename nonexistent file " + file);
            return;
        }
        if (file.equals(file2)) {
            System.err.println("Rename of " + file + " to " + file2 + " is a no-op.");
            return;
        }
        if (file2.exists() && !file.equals(file2.getCanonicalFile()) && !file2.delete()) {
            throw new IOException("Failed to delete " + file2 + " while trying to rename " + file);
        }
        File file3 = file2.getParentFile();
        if (file3 != null && !file3.exists() && !file3.mkdirs()) {
            throw new IOException("Failed to create directory " + file3 + " while trying to rename " + file);
        }
        if (!file.renameTo(file2)) {
            this.copyFile(file, file2);
            if (!file.delete()) {
                throw new IOException("Failed to delete " + file + " while trying to rename it.");
            }
        }
    }

    public long getFileTimestampGranularity() {
        if (ON_WIN9X) {
            return 2000L;
        }
        if (ON_WINDOWS) {
            return 1L;
        }
        if (ON_DOS) {
            return 2000L;
        }
        return 1000L;
    }

    public boolean hasErrorInCase(File file) {
        if (!(file = this.normalize(file.getAbsolutePath())).exists()) {
            return false;
        }
        final String string = file.getName();
        FilenameFilter filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String string2) {
                return string2.equalsIgnoreCase(string) && !string2.equals(string);
            }
        };
        String[] stringArray = file.getParentFile().list(filenameFilter);
        return stringArray != null && stringArray.length == 1;
    }

    public boolean isUpToDate(File file, File file2, long l) {
        if (!file2.exists()) {
            return false;
        }
        long l2 = file.lastModified();
        long l3 = file2.lastModified();
        return this.isUpToDate(l2, l3, l);
    }

    public boolean isUpToDate(File file, File file2) {
        return this.isUpToDate(file, file2, this.getFileTimestampGranularity());
    }

    public boolean isUpToDate(long l, long l2, long l3) {
        return l2 != -1L && l2 >= l + l3;
    }

    public boolean isUpToDate(long l, long l2) {
        return this.isUpToDate(l, l2, this.getFileTimestampGranularity());
    }

    public static void close(Writer writer) {
        if (null != writer) {
            try {
                writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(Reader reader) {
        if (null != reader) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(OutputStream outputStream) {
        if (null != outputStream) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(InputStream inputStream) {
        if (null != inputStream) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void delete(File file) {
        if (file != null) {
            file.delete();
        }
    }

    public static String getRelativePath(File file, File file2) throws Exception {
        int n;
        String string = file.getCanonicalPath();
        String string2 = file2.getCanonicalPath();
        String[] stringArray = FileUtils.getPathStack(string);
        String[] stringArray2 = FileUtils.getPathStack(string2);
        if (0 < stringArray2.length && 0 < stringArray.length) {
            if (!stringArray[0].equals(stringArray2[0])) {
                return FileUtils.getPath(Arrays.asList(stringArray2));
            }
        } else {
            return FileUtils.getPath(Arrays.asList(stringArray2));
        }
        int n2 = Math.min(stringArray.length, stringArray2.length);
        for (int i = 1; i < n2 && stringArray[i].equals(stringArray2[i]); ++i) {
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = i; n < stringArray.length; ++n) {
            arrayList.add("..");
        }
        for (n = i; n < stringArray2.length; ++n) {
            arrayList.add(stringArray2[n]);
        }
        return FileUtils.getPath(arrayList);
    }

    public static String[] getPathStack(String string) {
        String string2 = string.replace(File.separatorChar, '/');
        Object[] objectArray = StringUtils.split(string2, 47).toArray();
        String[] stringArray = new String[objectArray.length];
        System.arraycopy(objectArray, 0, stringArray, 0, objectArray.length);
        return stringArray;
    }

    public static String getPath(List list) {
        return FileUtils.getPath(list, '/');
    }

    public static String getPath(List list, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = list.iterator();
        if (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
        }
        while (iterator.hasNext()) {
            stringBuffer.append(c);
            stringBuffer.append(iterator.next());
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDefaultEncoding() {
        InputStreamReader inputStreamReader = new InputStreamReader(new InputStream(){

            @Override
            public int read() {
                return -1;
            }
        });
        try {
            String string = inputStreamReader.getEncoding();
            return string;
        }
        finally {
            FileUtils.close(inputStreamReader);
        }
    }
}

