/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.util.StringTokenizer;

public class DeweyDecimal {
    private int[] components;

    public DeweyDecimal(int[] nArray) {
        this.components = new int[nArray.length];
        System.arraycopy(nArray, 0, this.components, 0, nArray.length);
    }

    public DeweyDecimal(String string) throws NumberFormatException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", true);
        int n = stringTokenizer.countTokens();
        this.components = new int[(n + 1) / 2];
        for (int i = 0; i < this.components.length; ++i) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("")) {
                throw new NumberFormatException("Empty component in string");
            }
            this.components[i] = Integer.parseInt(string2);
            if (!stringTokenizer.hasMoreTokens()) continue;
            stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) continue;
            throw new NumberFormatException("DeweyDecimal ended in a '.'");
        }
    }

    public int getSize() {
        return this.components.length;
    }

    public int get(int n) {
        return this.components[n];
    }

    public boolean isEqual(DeweyDecimal deweyDecimal) {
        int n = Math.max(deweyDecimal.components.length, this.components.length);
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = i < this.components.length ? this.components[i] : 0;
            int n4 = n2 = i < deweyDecimal.components.length ? deweyDecimal.components[i] : 0;
            if (n2 == n3) continue;
            return false;
        }
        return true;
    }

    public boolean isLessThan(DeweyDecimal deweyDecimal) {
        return !this.isGreaterThanOrEqual(deweyDecimal);
    }

    public boolean isLessThanOrEqual(DeweyDecimal deweyDecimal) {
        return !this.isGreaterThan(deweyDecimal);
    }

    public boolean isGreaterThan(DeweyDecimal deweyDecimal) {
        int n = Math.max(deweyDecimal.components.length, this.components.length);
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = i < this.components.length ? this.components[i] : 0;
            int n4 = n2 = i < deweyDecimal.components.length ? deweyDecimal.components[i] : 0;
            if (n2 > n3) {
                return false;
            }
            if (n2 >= n3) continue;
            return true;
        }
        return false;
    }

    public boolean isGreaterThanOrEqual(DeweyDecimal deweyDecimal) {
        int n = Math.max(deweyDecimal.components.length, this.components.length);
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = i < this.components.length ? this.components[i] : 0;
            int n4 = n2 = i < deweyDecimal.components.length ? deweyDecimal.components[i] : 0;
            if (n2 > n3) {
                return false;
            }
            if (n2 >= n3) continue;
            return true;
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.components.length; ++i) {
            if (i != 0) {
                stringBuffer.append('.');
            }
            stringBuffer.append(this.components[i]);
        }
        return stringBuffer.toString();
    }
}

