/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DOMElementWriter {
    private static final int HEX = 16;
    private static final String NS = "ns";
    private boolean xmlDeclaration = true;
    private XmlNamespacePolicy namespacePolicy = XmlNamespacePolicy.IGNORE;
    private HashMap nsPrefixMap = new HashMap();
    private int nextPrefix = 0;
    private HashMap nsURIByElement = new HashMap();
    private static String lSep = System.getProperty("line.separator");
    protected String[] knownEntities = new String[]{"gt", "amp", "lt", "apos", "quot"};

    public DOMElementWriter() {
    }

    public DOMElementWriter(boolean bl) {
        this(bl, XmlNamespacePolicy.IGNORE);
    }

    public DOMElementWriter(boolean bl, XmlNamespacePolicy xmlNamespacePolicy) {
        this.xmlDeclaration = bl;
        this.namespacePolicy = xmlNamespacePolicy;
    }

    public void write(Element element, OutputStream outputStream) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF8");
        this.writeXMLDeclaration(outputStreamWriter);
        this.write(element, outputStreamWriter, 0, "  ");
        ((Writer)outputStreamWriter).flush();
    }

    public void writeXMLDeclaration(Writer writer) throws IOException {
        if (this.xmlDeclaration) {
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        }
    }

    public void write(Element element, Writer writer, int n, String string) throws IOException {
        NodeList nodeList = element.getChildNodes();
        boolean bl = nodeList.getLength() > 0;
        boolean bl2 = false;
        this.openElement(element, writer, n, string, bl);
        if (bl) {
            block8: for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                switch (node.getNodeType()) {
                    case 1: {
                        bl2 = true;
                        if (i == 0) {
                            writer.write(lSep);
                        }
                        this.write((Element)node, writer, n + 1, string);
                        continue block8;
                    }
                    case 3: {
                        writer.write(this.encode(node.getNodeValue()));
                        continue block8;
                    }
                    case 8: {
                        writer.write("<!--");
                        writer.write(this.encode(node.getNodeValue()));
                        writer.write("-->");
                        continue block8;
                    }
                    case 4: {
                        writer.write("<![CDATA[");
                        writer.write(this.encodedata(((Text)node).getData()));
                        writer.write("]]>");
                        continue block8;
                    }
                    case 5: {
                        writer.write(38);
                        writer.write(node.getNodeName());
                        writer.write(59);
                        continue block8;
                    }
                    case 7: {
                        writer.write("<?");
                        writer.write(node.getNodeName());
                        String string2 = node.getNodeValue();
                        if (string2 != null && string2.length() > 0) {
                            writer.write(32);
                            writer.write(string2);
                        }
                        writer.write("?>");
                        continue block8;
                    }
                }
            }
            this.closeElement(element, writer, n, string, bl2);
        }
    }

    public void openElement(Element element, Writer writer, int n, String string) throws IOException {
        this.openElement(element, writer, n, string, true);
    }

    public void openElement(Element element, Writer writer, int n, String string, boolean bl) throws IOException {
        String string2;
        for (int i = 0; i < n; ++i) {
            writer.write(string);
        }
        writer.write("<");
        if (this.namespacePolicy.qualifyElements) {
            String string3 = DOMElementWriter.getNamespaceURI(element);
            String string4 = (String)this.nsPrefixMap.get(string3);
            if (string4 == null) {
                string4 = this.nsPrefixMap.isEmpty() ? "" : NS + this.nextPrefix++;
                this.nsPrefixMap.put(string3, string4);
                this.addNSDefinition(element, string3);
            }
            if (!"".equals(string4)) {
                writer.write(string4);
                writer.write(":");
            }
        }
        writer.write(element.getTagName());
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            writer.write(" ");
            if (this.namespacePolicy.qualifyAttributes) {
                String string5 = DOMElementWriter.getNamespaceURI(attr);
                string2 = (String)this.nsPrefixMap.get(string5);
                if (string2 == null) {
                    string2 = NS + this.nextPrefix++;
                    this.nsPrefixMap.put(string5, string2);
                    this.addNSDefinition(element, string5);
                }
                writer.write(string2);
                writer.write(":");
            }
            writer.write(attr.getName());
            writer.write("=\"");
            writer.write(this.encode(attr.getValue()));
            writer.write("\"");
        }
        ArrayList arrayList = (ArrayList)this.nsURIByElement.get(element);
        if (arrayList != null) {
            for (String string5 : arrayList) {
                string2 = (String)this.nsPrefixMap.get(string5);
                writer.write(" xmlns");
                if (!"".equals(string2)) {
                    writer.write(":");
                    writer.write(string2);
                }
                writer.write("=\"");
                writer.write(string5);
                writer.write("\"");
            }
        }
        if (bl) {
            writer.write(">");
        } else {
            this.removeNSDefinitions(element);
            writer.write(" />");
            writer.write(lSep);
            writer.flush();
        }
    }

    public void closeElement(Element element, Writer writer, int n, String string, boolean bl) throws IOException {
        if (bl) {
            for (int i = 0; i < n; ++i) {
                writer.write(string);
            }
        }
        writer.write("</");
        if (this.namespacePolicy.qualifyElements) {
            String string2 = DOMElementWriter.getNamespaceURI(element);
            String string3 = (String)this.nsPrefixMap.get(string2);
            if (string3 != null && !"".equals(string3)) {
                writer.write(string3);
                writer.write(":");
            }
            this.removeNSDefinitions(element);
        }
        writer.write(element.getTagName());
        writer.write(">");
        writer.write(lSep);
        writer.flush();
    }

    public String encode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        block7: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block7;
                }
                case '\'': {
                    stringBuffer.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block7;
                }
                case '&': {
                    int n2 = string.indexOf(";", i);
                    if (n2 < 0 || !this.isReference(string.substring(i, n2 + 1))) {
                        stringBuffer.append("&amp;");
                        continue block7;
                    }
                    stringBuffer.append('&');
                    continue block7;
                }
                default: {
                    if (!this.isLegalCharacter(c)) continue block7;
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.substring(0);
    }

    public String encodedata(String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            n = string.charAt(i);
            if (!this.isLegalCharacter((char)n)) continue;
            stringBuffer.append((char)n);
        }
        String string2 = stringBuffer.substring(0);
        n = string2.indexOf("]]>");
        while (n != -1) {
            stringBuffer.setLength(n);
            stringBuffer.append("&#x5d;&#x5d;&gt;").append(string2.substring(n + 3));
            string2 = stringBuffer.substring(0);
            n = string2.indexOf("]]>");
        }
        return string2;
    }

    public boolean isReference(String string) {
        if (string.charAt(0) != '&' || !string.endsWith(";")) {
            return false;
        }
        if (string.charAt(1) == '#') {
            if (string.charAt(2) == 'x') {
                try {
                    Integer.parseInt(string.substring(3, string.length() - 1), 16);
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            try {
                Integer.parseInt(string.substring(2, string.length() - 1));
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        String string2 = string.substring(1, string.length() - 1);
        for (int i = 0; i < this.knownEntities.length; ++i) {
            if (!string2.equals(this.knownEntities[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isLegalCharacter(char c) {
        if (c == '\t' || c == '\n' || c == '\r') {
            return true;
        }
        if (c < ' ') {
            return false;
        }
        if (c <= '\ud7ff') {
            return true;
        }
        if (c < '\ue000') {
            return false;
        }
        return c <= '\ufffd';
    }

    private void removeNSDefinitions(Element element) {
        ArrayList arrayList = (ArrayList)this.nsURIByElement.get(element);
        if (arrayList != null) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                this.nsPrefixMap.remove(iterator.next());
            }
            this.nsURIByElement.remove(element);
        }
    }

    private void addNSDefinition(Element element, String string) {
        ArrayList<String> arrayList = (ArrayList<String>)this.nsURIByElement.get(element);
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
            this.nsURIByElement.put(element, arrayList);
        }
        arrayList.add(string);
    }

    private static String getNamespaceURI(Node node) {
        String string = node.getNamespaceURI();
        if (string == null) {
            string = "";
        }
        return string;
    }

    public static class XmlNamespacePolicy {
        private boolean qualifyElements;
        private boolean qualifyAttributes;
        public static final XmlNamespacePolicy IGNORE = new XmlNamespacePolicy(false, false);
        public static final XmlNamespacePolicy ONLY_QUALIFY_ELEMENTS = new XmlNamespacePolicy(true, false);
        public static final XmlNamespacePolicy QUALIFY_ALL = new XmlNamespacePolicy(true, true);

        public XmlNamespacePolicy(boolean bl, boolean bl2) {
            this.qualifyElements = bl;
            this.qualifyAttributes = bl2;
        }
    }
}

