/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.util.FileUtils;

public class ConcatResourceInputStream
extends InputStream {
    private static final int EOF = -1;
    private boolean eof = false;
    private Iterator iter;
    private InputStream currentStream;
    private ProjectComponent managingPc;
    private boolean ignoreErrors = false;

    public ConcatResourceInputStream(ResourceCollection resourceCollection) {
        this.iter = resourceCollection.iterator();
    }

    public void setIgnoreErrors(boolean bl) {
        this.ignoreErrors = bl;
    }

    public boolean isIgnoreErrors() {
        return this.ignoreErrors;
    }

    @Override
    public void close() throws IOException {
        this.closeCurrent();
        this.eof = true;
    }

    @Override
    public int read() throws IOException {
        if (this.eof) {
            return -1;
        }
        int n = this.readCurrent();
        if (n == -1) {
            this.nextResource();
            n = this.readCurrent();
        }
        return n;
    }

    public void setManagingComponent(ProjectComponent projectComponent) {
        this.managingPc = projectComponent;
    }

    public void log(String string, int n) {
        if (this.managingPc != null) {
            this.managingPc.log(string, n);
        } else {
            (n > 1 ? System.out : System.err).println(string);
        }
    }

    private int readCurrent() throws IOException {
        return this.eof || this.currentStream == null ? -1 : this.currentStream.read();
    }

    private void nextResource() throws IOException {
        this.closeCurrent();
        while (this.iter.hasNext()) {
            Resource resource = (Resource)this.iter.next();
            if (!resource.isExists()) continue;
            this.log("Concating " + resource.toLongString(), 3);
            try {
                this.currentStream = new BufferedInputStream(resource.getInputStream());
                return;
            }
            catch (IOException iOException) {
                if (this.ignoreErrors) continue;
                this.log("Failed to get input stream for " + resource, 0);
                throw iOException;
            }
        }
        this.eof = true;
    }

    private void closeCurrent() {
        FileUtils.close(this.currentStream);
        this.currentStream = null;
    }
}

