/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;

public class CollectionUtils {
    public static boolean equals(Vector vector, Vector vector2) {
        if (vector == vector2) {
            return true;
        }
        if (vector == null || vector2 == null) {
            return false;
        }
        return vector.equals(vector2);
    }

    public static boolean equals(Dictionary dictionary, Dictionary dictionary2) {
        if (dictionary == dictionary2) {
            return true;
        }
        if (dictionary == null || dictionary2 == null) {
            return false;
        }
        if (dictionary.size() != dictionary2.size()) {
            return false;
        }
        Enumeration enumeration = dictionary.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object v = dictionary.get(k);
            Object v2 = dictionary2.get(k);
            if (v2 != null && v.equals(v2)) continue;
            return false;
        }
        return true;
    }

    public static void putAll(Dictionary dictionary, Dictionary dictionary2) {
        Enumeration enumeration = dictionary2.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            dictionary.put(k, dictionary2.get(k));
        }
    }

    public static Enumeration append(Enumeration enumeration, Enumeration enumeration2) {
        return new CompoundEnumeration(enumeration, enumeration2);
    }

    public static Enumeration asEnumeration(final Iterator iterator) {
        return new Enumeration(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            public Object nextElement() {
                return iterator.next();
            }
        };
    }

    public static Iterator asIterator(final Enumeration enumeration) {
        return new Iterator(){

            @Override
            public boolean hasNext() {
                return enumeration.hasMoreElements();
            }

            public Object next() {
                return enumeration.nextElement();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static final class CompoundEnumeration
    implements Enumeration {
        private final Enumeration e1;
        private final Enumeration e2;

        public CompoundEnumeration(Enumeration enumeration, Enumeration enumeration2) {
            this.e1 = enumeration;
            this.e2 = enumeration2;
        }

        @Override
        public boolean hasMoreElements() {
            return this.e1.hasMoreElements() || this.e2.hasMoreElements();
        }

        public Object nextElement() throws NoSuchElementException {
            if (this.e1.hasMoreElements()) {
                return this.e1.nextElement();
            }
            return this.e2.nextElement();
        }
    }

    public static final class EmptyEnumeration
    implements Enumeration {
        @Override
        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() throws NoSuchElementException {
            throw new NoSuchElementException();
        }
    }
}

