/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class ClasspathUtils {
    public static final String REUSE_LOADER_REF = "ant.reuse.loader";

    public static ClassLoader getClassLoaderForPath(Project project, Reference reference) {
        return ClasspathUtils.getClassLoaderForPath(project, reference, false);
    }

    public static ClassLoader getClassLoaderForPath(Project project, Reference reference, boolean bl) {
        String string = reference.getRefId();
        Object object = project.getReference(string);
        if (!(object instanceof Path)) {
            throw new BuildException("The specified classpathref " + string + " does not reference a Path.");
        }
        String string2 = "ant.loader." + string;
        return ClasspathUtils.getClassLoaderForPath(project, (Path)object, string2, bl);
    }

    public static ClassLoader getClassLoaderForPath(Project project, Path path, String string) {
        return ClasspathUtils.getClassLoaderForPath(project, path, string, false);
    }

    public static ClassLoader getClassLoaderForPath(Project project, Path path, String string, boolean bl) {
        return ClasspathUtils.getClassLoaderForPath(project, path, string, bl, ClasspathUtils.isMagicPropertySet(project));
    }

    public static ClassLoader getClassLoaderForPath(Project project, Path path, String string, boolean bl, boolean bl2) {
        ClassLoader classLoader = null;
        if (string != null && bl2) {
            Object object = project.getReference(string);
            if (object != null && !(object instanceof ClassLoader)) {
                throw new BuildException("The specified loader id " + string + " does not reference a class loader");
            }
            classLoader = (ClassLoader)object;
        }
        if (classLoader == null) {
            classLoader = ClasspathUtils.getUniqueClassLoaderForPath(project, path, bl);
            if (string != null && bl2) {
                project.addReference(string, classLoader);
            }
        }
        return classLoader;
    }

    public static ClassLoader getUniqueClassLoaderForPath(Project project, Path path, boolean bl) {
        AntClassLoader antClassLoader = project.createClassLoader(path);
        if (bl) {
            antClassLoader.setParentFirst(false);
            antClassLoader.addJavaLibraries();
        }
        return antClassLoader;
    }

    public static Object newInstance(String string, ClassLoader classLoader) {
        return ClasspathUtils.newInstance(string, classLoader, Object.class);
    }

    public static Object newInstance(String string, ClassLoader classLoader, Class clazz) {
        try {
            Class<?> clazz2 = Class.forName(string, true, classLoader);
            Object obj = clazz2.newInstance();
            if (!clazz.isInstance(obj)) {
                throw new BuildException("Class of unexpected Type: " + string + " expected :" + clazz);
            }
            return obj;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new BuildException("Class not found: " + string, classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new BuildException("Could not instantiate " + string + ". Specified class should have a no " + "argument constructor.", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new BuildException("Could not instantiate " + string + ". Specified class should have a " + "public constructor.", illegalAccessException);
        }
        catch (LinkageError linkageError) {
            throw new BuildException("Class " + string + " could not be loaded because of an invalid dependency.", linkageError);
        }
    }

    public static Delegate getDelegate(ProjectComponent projectComponent) {
        return new Delegate(projectComponent);
    }

    private static boolean isMagicPropertySet(Project project) {
        return project.getProperty(REUSE_LOADER_REF) != null;
    }

    public static class Delegate {
        private final ProjectComponent component;
        private Path classpath;
        private String classpathId;
        private String className;
        private String loaderId;
        private boolean reverseLoader = false;

        Delegate(ProjectComponent projectComponent) {
            this.component = projectComponent;
        }

        public void setClasspath(Path path) {
            if (this.classpath == null) {
                this.classpath = path;
            } else {
                this.classpath.append(path);
            }
        }

        public Path createClasspath() {
            if (this.classpath == null) {
                this.classpath = new Path(this.component.getProject());
            }
            return this.classpath.createPath();
        }

        public void setClassname(String string) {
            this.className = string;
        }

        public void setClasspathref(Reference reference) {
            this.classpathId = reference.getRefId();
            this.createClasspath().setRefid(reference);
        }

        public void setReverseLoader(boolean bl) {
            this.reverseLoader = bl;
        }

        public void setLoaderRef(Reference reference) {
            this.loaderId = reference.getRefId();
        }

        public ClassLoader getClassLoader() {
            return ClasspathUtils.getClassLoaderForPath(this.getContextProject(), this.classpath, this.getClassLoadId(), this.reverseLoader, this.loaderId != null || ClasspathUtils.isMagicPropertySet(this.getContextProject()));
        }

        private Project getContextProject() {
            return this.component.getProject();
        }

        public String getClassLoadId() {
            return this.loaderId == null && this.classpathId != null ? "ant.loader." + this.classpathId : this.loaderId;
        }

        public Object newInstance() {
            return ClasspathUtils.newInstance(this.className, this.getClassLoader());
        }

        public Path getClasspath() {
            return this.classpath;
        }

        public boolean isReverseLoader() {
            return this.reverseLoader;
        }
    }
}

