/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.selectors.modifiedselector;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.security.NoSuchAlgorithmException;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.Checksum;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.selectors.modifiedselector.Algorithm;

public class ChecksumAlgorithm
implements Algorithm {
    private String algorithm = "CRC";
    private Checksum checksum = null;

    public void setAlgorithm(String string) {
        this.algorithm = string;
    }

    public void initChecksum() {
        if (this.checksum != null) {
            return;
        }
        if ("CRC".equalsIgnoreCase(this.algorithm)) {
            this.checksum = new CRC32();
        } else if ("ADLER".equalsIgnoreCase(this.algorithm)) {
            this.checksum = new Adler32();
        } else {
            throw new BuildException(new NoSuchAlgorithmException());
        }
    }

    @Override
    public boolean isValid() {
        return "CRC".equalsIgnoreCase(this.algorithm) || "ADLER".equalsIgnoreCase(this.algorithm);
    }

    @Override
    public String getValue(File file) {
        this.initChecksum();
        String string = null;
        try {
            if (file.canRead()) {
                this.checksum.reset();
                FileInputStream fileInputStream = new FileInputStream(file);
                CheckedInputStream checkedInputStream = new CheckedInputStream(fileInputStream, this.checksum);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(checkedInputStream);
                while (bufferedInputStream.read() != -1) {
                }
                string = Long.toString(checkedInputStream.getChecksum().getValue());
                bufferedInputStream.close();
            }
        }
        catch (Exception exception) {
            string = null;
        }
        return string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<ChecksumAlgorithm:");
        stringBuffer.append("algorithm=").append(this.algorithm);
        stringBuffer.append(">");
        return stringBuffer.toString();
    }
}

