/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.selectors;

import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Parameter;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.selectors.BaseSelector;
import org.apache.tools.ant.types.selectors.ExtendFileSelector;
import org.apache.tools.ant.types.selectors.FileSelector;

public class ExtendSelector
extends BaseSelector {
    private String classname = null;
    private FileSelector dynselector = null;
    private Vector paramVec = new Vector();
    private Path classpath = null;

    public void setClassname(String string) {
        this.classname = string;
    }

    public void selectorCreate() {
        if (this.classname != null && this.classname.length() > 0) {
            try {
                Object object;
                Class<?> clazz = null;
                if (this.classpath == null) {
                    clazz = Class.forName(this.classname);
                } else {
                    object = this.getProject().createClassLoader(this.classpath);
                    clazz = Class.forName(this.classname, true, (ClassLoader)object);
                }
                this.dynselector = (FileSelector)clazz.newInstance();
                object = this.getProject();
                if (object != null) {
                    ((Project)object).setProjectReference(this.dynselector);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.setError("Selector " + this.classname + " not initialized, no such class");
            }
            catch (InstantiationException instantiationException) {
                this.setError("Selector " + this.classname + " not initialized, could not create class");
            }
            catch (IllegalAccessException illegalAccessException) {
                this.setError("Selector " + this.classname + " not initialized, class not accessible");
            }
        } else {
            this.setError("There is no classname specified");
        }
    }

    public void addParam(Parameter parameter) {
        this.paramVec.addElement(parameter);
    }

    public final void setClasspath(Path path) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (this.classpath == null) {
            this.classpath = path;
        } else {
            this.classpath.append(path);
        }
    }

    public final Path createClasspath() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public final Path getClasspath() {
        return this.classpath;
    }

    public void setClasspathref(Reference reference) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.createClasspath().setRefid(reference);
    }

    @Override
    public void verifySettings() {
        if (this.dynselector == null) {
            this.selectorCreate();
        }
        if (this.classname == null || this.classname.length() < 1) {
            this.setError("The classname attribute is required");
        } else if (this.dynselector == null) {
            this.setError("Internal Error: The custom selector was not created");
        } else if (!(this.dynselector instanceof ExtendFileSelector) && this.paramVec.size() > 0) {
            this.setError("Cannot set parameters on custom selector that does not implement ExtendFileSelector");
        }
    }

    @Override
    public boolean isSelected(File file, String string, File file2) throws BuildException {
        this.validate();
        if (this.paramVec.size() > 0 && this.dynselector instanceof ExtendFileSelector) {
            Object[] objectArray = new Parameter[this.paramVec.size()];
            this.paramVec.copyInto(objectArray);
            ((ExtendFileSelector)this.dynselector).setParameters((Parameter[])objectArray);
        }
        return this.dynselector.isSelected(file, string, file2);
    }
}

