/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.selectors;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.selectors.MappingSelector;
import org.apache.tools.ant.util.FileUtils;

public class DifferentSelector
extends MappingSelector {
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private boolean ignoreFileTimes = true;
    private boolean ignoreContents = false;

    public void setIgnoreFileTimes(boolean bl) {
        this.ignoreFileTimes = bl;
    }

    public void setIgnoreContents(boolean bl) {
        this.ignoreContents = bl;
    }

    @Override
    protected boolean selectionTest(File file, File file2) {
        if (file.exists() != file2.exists()) {
            return true;
        }
        if (file.length() != file2.length()) {
            return true;
        }
        if (!this.ignoreFileTimes) {
            boolean bl;
            boolean bl2 = bl = file2.lastModified() >= file.lastModified() - (long)this.granularity && file2.lastModified() <= file.lastModified() + (long)this.granularity;
            if (!bl) {
                return true;
            }
        }
        if (!this.ignoreContents) {
            try {
                return !FILE_UTILS.contentEquals(file, file2);
            }
            catch (IOException iOException) {
                throw new BuildException("while comparing " + file + " and " + file2, iOException);
            }
        }
        return false;
    }
}

