/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.selectors;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Parameter;
import org.apache.tools.ant.types.RegularExpression;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.selectors.ResourceSelector;
import org.apache.tools.ant.types.selectors.BaseExtendSelector;
import org.apache.tools.ant.util.regexp.Regexp;

public class ContainsRegexpSelector
extends BaseExtendSelector
implements ResourceSelector {
    private String userProvidedExpression = null;
    private RegularExpression myRegExp = null;
    private Regexp myExpression = null;
    public static final String EXPRESSION_KEY = "expression";

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{containsregexpselector expression: ");
        stringBuffer.append(this.userProvidedExpression);
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public void setExpression(String string) {
        this.userProvidedExpression = string;
    }

    @Override
    public void setParameters(Parameter[] parameterArray) {
        super.setParameters(parameterArray);
        if (parameterArray != null) {
            for (int i = 0; i < parameterArray.length; ++i) {
                String string = parameterArray[i].getName();
                if (EXPRESSION_KEY.equalsIgnoreCase(string)) {
                    this.setExpression(parameterArray[i].getValue());
                    continue;
                }
                this.setError("Invalid parameter " + string);
            }
        }
    }

    @Override
    public void verifySettings() {
        if (this.userProvidedExpression == null) {
            this.setError("The expression attribute is required");
        }
    }

    @Override
    public boolean isSelected(File file, String string, File file2) {
        return this.isSelected(new FileResource(file2));
    }

    @Override
    public boolean isSelected(Resource resource) {
        String string = null;
        BufferedReader bufferedReader = null;
        this.validate();
        if (resource.isDirectory()) {
            return true;
        }
        if (this.myRegExp == null) {
            this.myRegExp = new RegularExpression();
            this.myRegExp.setPattern(this.userProvidedExpression);
            this.myExpression = this.myRegExp.getRegexp(this.getProject());
        }
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(resource.getInputStream()));
        }
        catch (Exception exception) {
            throw new BuildException("Could not get InputStream from " + resource.toLongString(), exception);
        }
        try {
            string = bufferedReader.readLine();
            while (string != null) {
                if (this.myExpression.matches(string)) {
                    boolean bl = true;
                    return bl;
                }
                string = bufferedReader.readLine();
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            throw new BuildException("Could not read " + resource.toLongString());
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {
                throw new BuildException("Could not close " + resource.toLongString());
            }
        }
    }
}

