/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.resources.selectors;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.selectors.ResourceSelector;

public class Type
implements ResourceSelector {
    private static final String FILE_ATTR = "file";
    private static final String DIR_ATTR = "dir";
    public static final Type FILE = new Type(new FileDir("file"));
    public static final Type DIR = new Type(new FileDir("dir"));
    private FileDir type = null;

    public Type() {
    }

    public Type(FileDir fileDir) {
        this.setType(fileDir);
    }

    public void setType(FileDir fileDir) {
        this.type = fileDir;
    }

    @Override
    public boolean isSelected(Resource resource) {
        if (this.type == null) {
            throw new BuildException("The type attribute is required.");
        }
        int n = this.type.getIndex();
        return resource.isDirectory() ? n == 1 : n == 0;
    }

    public static class FileDir
    extends EnumeratedAttribute {
        private static final String[] VALUES = new String[]{"file", "dir"};

        public FileDir() {
        }

        public FileDir(String string) {
            this.setValue(string);
        }

        @Override
        public String[] getValues() {
            return VALUES;
        }
    }
}

