/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.resources.selectors;

import java.util.Collections;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.resources.selectors.ResourceSelector;

public class ResourceSelectorContainer
extends DataType {
    private Vector v = new Vector();

    public ResourceSelectorContainer() {
    }

    public ResourceSelectorContainer(ResourceSelector[] resourceSelectorArray) {
        for (int i = 0; i < resourceSelectorArray.length; ++i) {
            this.add(resourceSelectorArray[i]);
        }
    }

    public void add(ResourceSelector resourceSelector) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        if (resourceSelector == null) {
            return;
        }
        this.v.add(resourceSelector);
        this.setChecked(false);
    }

    public boolean hasSelectors() {
        if (this.isReference()) {
            return ((ResourceSelectorContainer)this.getCheckedRef()).hasSelectors();
        }
        this.dieOnCircularReference();
        return !this.v.isEmpty();
    }

    public int selectorCount() {
        if (this.isReference()) {
            return ((ResourceSelectorContainer)this.getCheckedRef()).selectorCount();
        }
        this.dieOnCircularReference();
        return this.v.size();
    }

    public Iterator getSelectors() {
        if (this.isReference()) {
            return ((ResourceSelectorContainer)this.getCheckedRef()).getSelectors();
        }
        this.dieOnCircularReference();
        return Collections.unmodifiableList(this.v).iterator();
    }

    @Override
    protected void dieOnCircularReference(Stack stack, Project project) throws BuildException {
        if (this.isChecked()) {
            return;
        }
        if (this.isReference()) {
            super.dieOnCircularReference(stack, project);
        } else {
            for (Object e : this.v) {
                if (!(e instanceof DataType)) continue;
                stack.push(e);
                ResourceSelectorContainer.invokeCircularReferenceCheck((DataType)e, stack, project);
            }
            this.setChecked(true);
        }
    }
}

