/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.resources.comparators;

import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.comparators.ResourceComparator;

public class DelegatedResourceComparator
extends ResourceComparator {
    private Vector v = null;

    public synchronized void add(ResourceComparator resourceComparator) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        if (resourceComparator == null) {
            return;
        }
        this.v = this.v == null ? new Vector() : this.v;
        this.v.add(resourceComparator);
    }

    @Override
    public synchronized boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (this.isReference()) {
            return this.getCheckedRef().equals(object);
        }
        if (!(object instanceof DelegatedResourceComparator)) {
            return false;
        }
        Vector vector = ((DelegatedResourceComparator)object).v;
        return this.v == null ? vector == null : this.v.equals(vector);
    }

    @Override
    public synchronized int hashCode() {
        if (this.isReference()) {
            return this.getCheckedRef().hashCode();
        }
        return this.v == null ? 0 : this.v.hashCode();
    }

    @Override
    protected synchronized int resourceCompare(Resource resource, Resource resource2) {
        if (this.v == null || this.v.isEmpty()) {
            return resource.compareTo(resource2);
        }
        int n = 0;
        Iterator iterator = this.v.iterator();
        while (n == 0 && iterator.hasNext()) {
            n = ((ResourceComparator)iterator.next()).resourceCompare(resource, resource2);
        }
        return n;
    }

    @Override
    protected void dieOnCircularReference(Stack stack, Project project) throws BuildException {
        if (this.isChecked()) {
            return;
        }
        if (this.isReference()) {
            super.dieOnCircularReference(stack, project);
        } else {
            if (this.v != null && !this.v.isEmpty()) {
                for (Object e : this.v) {
                    if (!(e instanceof DataType)) continue;
                    stack.push(e);
                    DelegatedResourceComparator.invokeCircularReferenceCheck((DataType)e, stack, project);
                }
            }
            this.setChecked(true);
        }
    }
}

