/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.resources;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Stack;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.BaseResourceCollectionWrapper;
import org.apache.tools.ant.types.resources.StringResource;
import org.apache.tools.ant.util.ConcatResourceInputStream;
import org.apache.tools.ant.util.LineTokenizer;
import org.apache.tools.ant.util.Tokenizer;

public class Tokens
extends BaseResourceCollectionWrapper {
    private Tokenizer tokenizer;
    private String encoding;

    @Override
    protected synchronized Collection getCollection() {
        ResourceCollection resourceCollection = this.getResourceCollection();
        if (resourceCollection.size() == 0) {
            return Collections.EMPTY_SET;
        }
        if (this.tokenizer == null) {
            this.tokenizer = new LineTokenizer();
        }
        ConcatResourceInputStream concatResourceInputStream = new ConcatResourceInputStream(resourceCollection);
        concatResourceInputStream.setManagingComponent(this);
        InputStreamReader inputStreamReader = null;
        if (this.encoding == null) {
            inputStreamReader = new InputStreamReader(concatResourceInputStream);
        } else {
            try {
                inputStreamReader = new InputStreamReader((InputStream)concatResourceInputStream, this.encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new BuildException(unsupportedEncodingException);
            }
        }
        ArrayList<StringResource> arrayList = new ArrayList<StringResource>();
        try {
            String string = this.tokenizer.getToken(inputStreamReader);
            while (string != null) {
                StringResource stringResource = new StringResource(string);
                stringResource.setProject(this.getProject());
                arrayList.add(stringResource);
                string = this.tokenizer.getToken(inputStreamReader);
            }
        }
        catch (IOException iOException) {
            throw new BuildException("Error reading tokens", iOException);
        }
        return arrayList;
    }

    public synchronized void setEncoding(String string) {
        this.encoding = string;
    }

    public synchronized void add(Tokenizer tokenizer) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        if (this.tokenizer != null) {
            throw new BuildException("Only one nested tokenizer allowed.");
        }
        this.tokenizer = tokenizer;
    }

    @Override
    protected synchronized void dieOnCircularReference(Stack stack, Project project) throws BuildException {
        if (this.isChecked()) {
            return;
        }
        if (this.isReference()) {
            super.dieOnCircularReference(stack, project);
        } else {
            if (this.tokenizer instanceof DataType) {
                stack.push(this.tokenizer);
                Tokens.invokeCircularReferenceCheck((DataType)((Object)this.tokenizer), stack, project);
            }
            this.setChecked(true);
        }
    }
}

