/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.resources;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.ArchiveResource;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;

public class TarResource
extends ArchiveResource {
    private String userName = "";
    private String groupName = "";
    private int uid;
    private int gid;

    public TarResource() {
    }

    public TarResource(File file, TarEntry tarEntry) {
        super(file, true);
        this.setEntry(tarEntry);
    }

    public TarResource(Resource resource, TarEntry tarEntry) {
        super(resource, true);
        this.setEntry(tarEntry);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).getInputStream();
        }
        Resource resource = this.getArchive();
        TarInputStream tarInputStream = new TarInputStream(resource.getInputStream());
        TarEntry tarEntry = null;
        while ((tarEntry = tarInputStream.getNextEntry()) != null) {
            if (!tarEntry.getName().equals(this.getName())) continue;
            return tarInputStream;
        }
        FileUtils.close(tarInputStream);
        throw new BuildException("no entry " + this.getName() + " in " + this.getArchive());
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).getOutputStream();
        }
        throw new UnsupportedOperationException("Use the tar task for tar output.");
    }

    public String getUserName() {
        if (this.isReference()) {
            return ((TarResource)this.getCheckedRef()).getUserName();
        }
        return this.userName;
    }

    public String getGroup() {
        if (this.isReference()) {
            return ((TarResource)this.getCheckedRef()).getGroup();
        }
        return this.groupName;
    }

    public int getUid() {
        if (this.isReference()) {
            return ((TarResource)this.getCheckedRef()).getUid();
        }
        return this.uid;
    }

    public int getGid() {
        if (this.isReference()) {
            return ((TarResource)this.getCheckedRef()).getGid();
        }
        return this.uid;
    }

    @Override
    protected void fetchEntry() {
        Resource resource = this.getArchive();
        TarInputStream tarInputStream = null;
        try {
            tarInputStream = new TarInputStream(resource.getInputStream());
            TarEntry tarEntry = null;
            while ((tarEntry = tarInputStream.getNextEntry()) != null) {
                if (!tarEntry.getName().equals(this.getName())) continue;
                this.setEntry(tarEntry);
                return;
            }
        }
        catch (IOException iOException) {
            this.log(iOException.getMessage(), 4);
            throw new BuildException(iOException);
        }
        finally {
            if (tarInputStream != null) {
                FileUtils.close(tarInputStream);
            }
        }
        this.setEntry(null);
    }

    private void setEntry(TarEntry tarEntry) {
        if (tarEntry == null) {
            this.setExists(false);
            return;
        }
        this.setName(tarEntry.getName());
        this.setExists(true);
        this.setLastModified(tarEntry.getModTime().getTime());
        this.setDirectory(tarEntry.isDirectory());
        this.setSize(tarEntry.getSize());
        this.setMode(tarEntry.getMode());
        this.userName = tarEntry.getUserName();
        this.groupName = tarEntry.getGroupName();
        this.uid = tarEntry.getUserId();
        this.gid = tarEntry.getGroupId();
    }
}

