/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.resources;

import java.io.File;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FailFast;

public class Resources
extends DataType
implements ResourceCollection {
    public static final ResourceCollection NONE = new ResourceCollection(){

        @Override
        public boolean isFilesystemOnly() {
            return true;
        }

        @Override
        public Iterator iterator() {
            return EMPTY_ITERATOR;
        }

        @Override
        public int size() {
            return 0;
        }
    };
    public static final Iterator EMPTY_ITERATOR = new Iterator(){

        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    };
    private Vector rc;
    private Collection coll;

    public synchronized void add(ResourceCollection resourceCollection) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        if (resourceCollection == null) {
            return;
        }
        if (this.rc == null) {
            this.rc = new Vector();
        }
        this.rc.add(resourceCollection);
        FailFast.invalidate(this);
        this.coll = null;
        this.setChecked(false);
    }

    @Override
    public synchronized Iterator iterator() {
        if (this.isReference()) {
            return this.getRef().iterator();
        }
        this.validate();
        return new FailFast(this, this.coll.iterator());
    }

    @Override
    public synchronized int size() {
        if (this.isReference()) {
            return this.getRef().size();
        }
        this.validate();
        return this.coll.size();
    }

    @Override
    public boolean isFilesystemOnly() {
        if (this.isReference()) {
            return this.getRef().isFilesystemOnly();
        }
        this.validate();
        Iterator iterator = this.getNested().iterator();
        while (iterator.hasNext()) {
            if (((ResourceCollection)iterator.next()).isFilesystemOnly()) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized String toString() {
        if (this.isReference()) {
            return this.getCheckedRef().toString();
        }
        if (this.coll == null || this.coll.isEmpty()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.coll.iterator();
        while (iterator.hasNext()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(File.pathSeparatorChar);
            }
            stringBuffer.append(iterator.next());
        }
        return stringBuffer.toString();
    }

    @Override
    protected void dieOnCircularReference(Stack stack, Project project) throws BuildException {
        if (this.isChecked()) {
            return;
        }
        if (this.isReference()) {
            super.dieOnCircularReference(stack, project);
        } else {
            for (Object e : this.getNested()) {
                if (!(e instanceof DataType)) continue;
                Resources.invokeCircularReferenceCheck((DataType)e, stack, project);
            }
            this.setChecked(true);
        }
    }

    private ResourceCollection getRef() {
        return (ResourceCollection)this.getCheckedRef(ResourceCollection.class, "ResourceCollection");
    }

    private synchronized void validate() {
        this.dieOnCircularReference();
        this.coll = this.coll == null ? new MyCollection() : this.coll;
    }

    private synchronized List getNested() {
        return this.rc == null ? Collections.EMPTY_LIST : this.rc;
    }

    private class MyCollection
    extends AbstractCollection {
        private int size = 0;

        MyCollection() {
            Iterator iterator = Resources.this.getNested().iterator();
            while (iterator.hasNext()) {
                this.size += ((ResourceCollection)iterator.next()).size();
            }
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public Iterator iterator() {
            return new MyIterator();
        }

        private class MyIterator
        implements Iterator {
            private Iterator rci;
            private Iterator ri;

            private MyIterator() {
                this.rci = Resources.this.getNested().iterator();
                this.ri = null;
            }

            @Override
            public boolean hasNext() {
                boolean bl;
                boolean bl2 = bl = this.ri != null && this.ri.hasNext();
                while (!bl && this.rci.hasNext()) {
                    this.ri = ((ResourceCollection)this.rci.next()).iterator();
                    bl = this.ri.hasNext();
                }
                return bl;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.ri.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

