/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.resources;

import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResourceIterator;
import org.apache.tools.ant.types.selectors.AbstractSelectorContainer;
import org.apache.tools.ant.types.selectors.FileSelector;

public class Files
extends AbstractSelectorContainer
implements Cloneable,
ResourceCollection {
    private static final Iterator EMPTY_ITERATOR = Collections.EMPTY_SET.iterator();
    private PatternSet defaultPatterns = new PatternSet();
    private Vector additionalPatterns = new Vector();
    private Vector selectors = new Vector();
    private boolean useDefaultExcludes = true;
    private boolean caseSensitive = true;
    private boolean followSymlinks = true;
    private DirectoryScanner ds = null;

    public Files() {
    }

    protected Files(Files files) {
        this.defaultPatterns = files.defaultPatterns;
        this.additionalPatterns = files.additionalPatterns;
        this.selectors = files.selectors;
        this.useDefaultExcludes = files.useDefaultExcludes;
        this.caseSensitive = files.caseSensitive;
        this.followSymlinks = files.followSymlinks;
        this.ds = files.ds;
        this.setProject(files.getProject());
    }

    @Override
    public void setRefid(Reference reference) throws BuildException {
        if (this.hasPatterns(this.defaultPatterns)) {
            throw this.tooManyAttributes();
        }
        if (!this.additionalPatterns.isEmpty()) {
            throw this.noChildrenAllowed();
        }
        if (!this.selectors.isEmpty()) {
            throw this.noChildrenAllowed();
        }
        super.setRefid(reference);
    }

    public synchronized PatternSet createPatternSet() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        PatternSet patternSet = new PatternSet();
        this.additionalPatterns.addElement(patternSet);
        this.ds = null;
        return patternSet;
    }

    public synchronized PatternSet.NameEntry createInclude() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.ds = null;
        return this.defaultPatterns.createInclude();
    }

    public synchronized PatternSet.NameEntry createIncludesFile() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.ds = null;
        return this.defaultPatterns.createIncludesFile();
    }

    public synchronized PatternSet.NameEntry createExclude() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.ds = null;
        return this.defaultPatterns.createExclude();
    }

    public synchronized PatternSet.NameEntry createExcludesFile() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.ds = null;
        return this.defaultPatterns.createExcludesFile();
    }

    public synchronized void setIncludes(String string) {
        this.checkAttributesAllowed();
        this.defaultPatterns.setIncludes(string);
        this.ds = null;
    }

    public synchronized void appendIncludes(String[] stringArray) {
        this.checkAttributesAllowed();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.defaultPatterns.createInclude().setName(stringArray[i]);
            }
            this.ds = null;
        }
    }

    public synchronized void setExcludes(String string) {
        this.checkAttributesAllowed();
        this.defaultPatterns.setExcludes(string);
        this.ds = null;
    }

    public synchronized void appendExcludes(String[] stringArray) {
        this.checkAttributesAllowed();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.defaultPatterns.createExclude().setName(stringArray[i]);
            }
            this.ds = null;
        }
    }

    public synchronized void setIncludesfile(File file) throws BuildException {
        this.checkAttributesAllowed();
        this.defaultPatterns.setIncludesfile(file);
        this.ds = null;
    }

    public synchronized void setExcludesfile(File file) throws BuildException {
        this.checkAttributesAllowed();
        this.defaultPatterns.setExcludesfile(file);
        this.ds = null;
    }

    public synchronized void setDefaultexcludes(boolean bl) {
        this.checkAttributesAllowed();
        this.useDefaultExcludes = bl;
        this.ds = null;
    }

    public synchronized boolean getDefaultexcludes() {
        return this.isReference() ? this.getRef().getDefaultexcludes() : this.useDefaultExcludes;
    }

    public synchronized void setCaseSensitive(boolean bl) {
        this.checkAttributesAllowed();
        this.caseSensitive = bl;
        this.ds = null;
    }

    public synchronized boolean isCaseSensitive() {
        return this.isReference() ? this.getRef().isCaseSensitive() : this.caseSensitive;
    }

    public synchronized void setFollowSymlinks(boolean bl) {
        this.checkAttributesAllowed();
        this.followSymlinks = bl;
        this.ds = null;
    }

    public synchronized boolean isFollowSymlinks() {
        return this.isReference() ? this.getRef().isFollowSymlinks() : this.followSymlinks;
    }

    @Override
    public synchronized Iterator iterator() {
        if (this.isReference()) {
            return this.getRef().iterator();
        }
        this.ensureDirectoryScannerSetup();
        this.ds.scan();
        int n = this.ds.getIncludedFilesCount();
        int n2 = this.ds.getIncludedDirsCount();
        if (n + n2 == 0) {
            return EMPTY_ITERATOR;
        }
        FileResourceIterator fileResourceIterator = new FileResourceIterator();
        if (n > 0) {
            fileResourceIterator.addFiles(this.ds.getIncludedFiles());
        }
        if (n2 > 0) {
            fileResourceIterator.addFiles(this.ds.getIncludedDirectories());
        }
        return fileResourceIterator;
    }

    @Override
    public synchronized int size() {
        if (this.isReference()) {
            return this.getRef().size();
        }
        this.ensureDirectoryScannerSetup();
        this.ds.scan();
        return this.ds.getIncludedFilesCount() + this.ds.getIncludedDirsCount();
    }

    public synchronized boolean hasPatterns() {
        if (this.isReference()) {
            return this.getRef().hasPatterns();
        }
        if (this.hasPatterns(this.defaultPatterns)) {
            return true;
        }
        Iterator iterator = this.additionalPatterns.iterator();
        while (iterator.hasNext()) {
            if (!this.hasPatterns((PatternSet)iterator.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized void appendSelector(FileSelector fileSelector) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        super.appendSelector(fileSelector);
        this.ds = null;
    }

    @Override
    public String toString() {
        if (this.isReference()) {
            return this.getRef().toString();
        }
        Iterator iterator = this.iterator();
        if (!iterator.hasNext()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(File.pathSeparatorChar);
            }
            stringBuffer.append(iterator.next());
        }
        return stringBuffer.toString();
    }

    @Override
    public synchronized Object clone() {
        if (this.isReference()) {
            return this.getRef().clone();
        }
        try {
            Files files = (Files)super.clone();
            files.defaultPatterns = (PatternSet)this.defaultPatterns.clone();
            files.additionalPatterns = new Vector(this.additionalPatterns.size());
            for (PatternSet patternSet : this.additionalPatterns) {
                files.additionalPatterns.add(patternSet.clone());
            }
            files.selectors = new Vector(this.selectors);
            return files;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new BuildException(cloneNotSupportedException);
        }
    }

    public String[] mergeIncludes(Project project) {
        return this.mergePatterns(project).getIncludePatterns(project);
    }

    public String[] mergeExcludes(Project project) {
        return this.mergePatterns(project).getExcludePatterns(project);
    }

    public synchronized PatternSet mergePatterns(Project project) {
        if (this.isReference()) {
            return this.getRef().mergePatterns(project);
        }
        PatternSet patternSet = new PatternSet();
        patternSet.append(this.defaultPatterns, project);
        int n = this.additionalPatterns.size();
        for (int i = 0; i < n; ++i) {
            Object e = this.additionalPatterns.elementAt(i);
            patternSet.append((PatternSet)e, project);
        }
        return patternSet;
    }

    @Override
    public boolean isFilesystemOnly() {
        return true;
    }

    protected Files getRef() {
        return (Files)this.getCheckedRef();
    }

    private synchronized void ensureDirectoryScannerSetup() {
        if (this.ds == null) {
            this.ds = new DirectoryScanner();
            PatternSet patternSet = this.mergePatterns(this.getProject());
            this.ds.setIncludes(patternSet.getIncludePatterns(this.getProject()));
            this.ds.setExcludes(patternSet.getExcludePatterns(this.getProject()));
            this.ds.setSelectors(this.getSelectors(this.getProject()));
            if (this.useDefaultExcludes) {
                this.ds.addDefaultExcludes();
            }
            this.ds.setCaseSensitive(this.caseSensitive);
            this.ds.setFollowSymlinks(this.followSymlinks);
        }
    }

    private boolean hasPatterns(PatternSet patternSet) {
        String[] stringArray = patternSet.getIncludePatterns(this.getProject());
        String[] stringArray2 = patternSet.getExcludePatterns(this.getProject());
        return stringArray != null && stringArray.length > 0 || stringArray != null && stringArray2.length > 0;
    }
}

