/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.resources;

import java.io.File;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.tools.ant.types.resources.FileResource;

public class FileResourceIterator
implements Iterator {
    private File basedir;
    private String[] files;
    private int pos = 0;

    public FileResourceIterator() {
    }

    public FileResourceIterator(File file) {
        this.basedir = file;
    }

    public FileResourceIterator(File file, String[] stringArray) {
        this(file);
        this.addFiles(stringArray);
    }

    public void addFiles(String[] stringArray) {
        int n = this.files == null ? 0 : this.files.length;
        String[] stringArray2 = new String[n + stringArray.length];
        if (n > 0) {
            System.arraycopy(this.files, 0, stringArray2, 0, n);
        }
        this.files = stringArray2;
        System.arraycopy(stringArray, 0, this.files, n, stringArray.length);
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.files.length;
    }

    public Object next() {
        return this.nextResource();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public FileResource nextResource() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return new FileResource(this.basedir, this.files[this.pos++]);
    }
}

