/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.Touchable;
import org.apache.tools.ant.util.FileUtils;

public class FileResource
extends Resource
implements Touchable {
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private static final int NULL_FILE = Resource.getMagicNumber("null file".getBytes());
    private File file;
    private File baseDir;

    public FileResource() {
    }

    public FileResource(File file, String string) {
        this.setFile(FILE_UTILS.resolveFile(file, string));
        this.setBaseDir(file);
    }

    public FileResource(File file) {
        this.setFile(file);
    }

    public FileResource(Project project, String string) {
        this(project.resolveFile(string));
        this.setProject(project);
    }

    public void setFile(File file) {
        this.checkAttributesAllowed();
        this.file = file;
    }

    public File getFile() {
        return this.isReference() ? ((FileResource)this.getCheckedRef()).getFile() : this.file;
    }

    public void setBaseDir(File file) {
        this.checkAttributesAllowed();
        this.baseDir = file;
    }

    public File getBaseDir() {
        return this.isReference() ? ((FileResource)this.getCheckedRef()).getBaseDir() : this.baseDir;
    }

    @Override
    public void setRefid(Reference reference) {
        if (this.file != null || this.baseDir != null) {
            throw this.tooManyAttributes();
        }
        super.setRefid(reference);
    }

    @Override
    public String getName() {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).getName();
        }
        File file = this.getBaseDir();
        return file == null ? this.getNotNullFile().getName() : FILE_UTILS.removeLeadingPath(file, this.getNotNullFile());
    }

    @Override
    public boolean isExists() {
        return this.isReference() ? ((Resource)this.getCheckedRef()).isExists() : this.getNotNullFile().exists();
    }

    @Override
    public long getLastModified() {
        return this.isReference() ? ((Resource)this.getCheckedRef()).getLastModified() : this.getNotNullFile().lastModified();
    }

    @Override
    public boolean isDirectory() {
        return this.isReference() ? ((Resource)this.getCheckedRef()).isDirectory() : this.getNotNullFile().isDirectory();
    }

    @Override
    public long getSize() {
        return this.isReference() ? ((Resource)this.getCheckedRef()).getSize() : this.getNotNullFile().length();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.isReference() ? ((Resource)this.getCheckedRef()).getInputStream() : new FileInputStream(this.getNotNullFile());
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).getOutputStream();
        }
        File file = this.getNotNullFile();
        if (file.exists()) {
            if (file.isFile()) {
                file.delete();
            }
        } else {
            File file2 = file.getParentFile();
            if (file2 != null && !file2.exists()) {
                file2.mkdirs();
            }
        }
        return new FileOutputStream(file);
    }

    @Override
    public int compareTo(Object object) {
        if (this.isReference()) {
            return ((Comparable)this.getCheckedRef()).compareTo(object);
        }
        if (this.equals(object)) {
            return 0;
        }
        if (object.getClass().equals(this.getClass())) {
            FileResource fileResource = (FileResource)object;
            File file = this.getFile();
            if (file == null) {
                return -1;
            }
            File file2 = fileResource.getFile();
            if (file2 == null) {
                return 1;
            }
            return file.compareTo(file2);
        }
        return super.compareTo(object);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (this.isReference()) {
            return this.getCheckedRef().equals(object);
        }
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        FileResource fileResource = (FileResource)object;
        return this.getFile() == null ? fileResource.getFile() == null : this.getFile().equals(fileResource.getFile());
    }

    @Override
    public int hashCode() {
        if (this.isReference()) {
            return this.getCheckedRef().hashCode();
        }
        return MAGIC * (this.getFile() == null ? NULL_FILE : this.getFile().hashCode());
    }

    @Override
    public String toString() {
        if (this.isReference()) {
            return this.getCheckedRef().toString();
        }
        if (this.file == null) {
            return "(unbound file resource)";
        }
        String string = this.file.getAbsolutePath();
        return FILE_UTILS.normalize(string).getAbsolutePath();
    }

    @Override
    public boolean isFilesystemOnly() {
        return !this.isReference() || ((FileResource)this.getCheckedRef()).isFilesystemOnly();
    }

    @Override
    public void touch(long l) {
        if (this.isReference()) {
            ((FileResource)this.getCheckedRef()).touch(l);
            return;
        }
        this.getNotNullFile().setLastModified(l);
    }

    protected File getNotNullFile() {
        if (this.getFile() == null) {
            throw new BuildException("file attribute is null!");
        }
        return this.getFile();
    }
}

