/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.resources;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.Stack;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.BaseResourceCollectionContainer;
import org.apache.tools.ant.types.resources.FailFast;
import org.apache.tools.ant.types.resources.FileResource;

public abstract class BaseResourceCollectionWrapper
extends DataType
implements ResourceCollection,
Cloneable {
    private static final String ONE_NESTED_MESSAGE = " expects exactly one nested resource collection.";
    private ResourceCollection rc;
    private Collection coll = null;
    private boolean cache = true;

    public synchronized void setCache(boolean bl) {
        this.cache = bl;
    }

    public synchronized boolean isCache() {
        return this.cache;
    }

    public synchronized void add(ResourceCollection resourceCollection) throws BuildException {
        Project project;
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        if (resourceCollection == null) {
            return;
        }
        if (this.rc != null) {
            throw this.oneNested();
        }
        this.rc = resourceCollection;
        if (Project.getProject(this.rc) == null && (project = this.getProject()) != null) {
            project.setProjectReference(this.rc);
        }
        this.setChecked(false);
    }

    @Override
    public final synchronized Iterator iterator() {
        if (this.isReference()) {
            return ((BaseResourceCollectionWrapper)this.getCheckedRef()).iterator();
        }
        this.dieOnCircularReference();
        return new FailFast(this, this.cacheCollection().iterator());
    }

    @Override
    public synchronized int size() {
        if (this.isReference()) {
            return ((BaseResourceCollectionWrapper)this.getCheckedRef()).size();
        }
        this.dieOnCircularReference();
        return this.cacheCollection().size();
    }

    @Override
    public synchronized boolean isFilesystemOnly() {
        if (this.isReference()) {
            return ((BaseResourceCollectionContainer)this.getCheckedRef()).isFilesystemOnly();
        }
        this.dieOnCircularReference();
        if (this.rc == null || this.rc.isFilesystemOnly()) {
            return true;
        }
        Iterator iterator = this.cacheCollection().iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof FileResource) continue;
            return false;
        }
        return true;
    }

    @Override
    protected synchronized void dieOnCircularReference(Stack stack, Project project) throws BuildException {
        if (this.isChecked()) {
            return;
        }
        if (this.isReference()) {
            super.dieOnCircularReference(stack, project);
        } else {
            if (this.rc instanceof DataType) {
                stack.push(this.rc);
                BaseResourceCollectionWrapper.invokeCircularReferenceCheck((DataType)((Object)this.rc), stack, project);
                stack.pop();
            }
            this.setChecked(true);
        }
    }

    protected final synchronized ResourceCollection getResourceCollection() {
        this.dieOnCircularReference();
        if (this.rc == null) {
            throw this.oneNested();
        }
        return this.rc;
    }

    protected abstract Collection getCollection();

    @Override
    public synchronized String toString() {
        if (this.isReference()) {
            return this.getCheckedRef().toString();
        }
        if (this.cacheCollection().size() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.coll.iterator();
        while (iterator.hasNext()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(File.pathSeparatorChar);
            }
            stringBuffer.append(iterator.next());
        }
        return stringBuffer.toString();
    }

    private synchronized Collection cacheCollection() {
        if (this.coll == null || !this.isCache()) {
            this.coll = this.getCollection();
        }
        return this.coll;
    }

    private BuildException oneNested() {
        return new BuildException(super.toString() + ONE_NESTED_MESSAGE);
    }
}

