/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.resources;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;

public abstract class ArchiveResource
extends Resource {
    private static final int NULL_ARCHIVE = Resource.getMagicNumber("null archive".getBytes());
    private Resource archive;
    private boolean haveEntry = false;
    private boolean modeSet = false;
    private int mode = 0;

    public ArchiveResource() {
    }

    public ArchiveResource(File file) {
        this(file, false);
    }

    public ArchiveResource(File file, boolean bl) {
        this.setArchive(file);
        this.haveEntry = bl;
    }

    public ArchiveResource(Resource resource, boolean bl) {
        this.addConfigured(resource);
        this.haveEntry = bl;
    }

    public void setArchive(File file) {
        this.checkAttributesAllowed();
        this.archive = new FileResource(file);
    }

    public void setMode(int n) {
        this.checkAttributesAllowed();
        this.mode = n;
        this.modeSet = true;
    }

    public void addConfigured(ResourceCollection resourceCollection) {
        this.checkChildrenAllowed();
        if (this.archive != null) {
            throw new BuildException("you must not specify more than one archive");
        }
        if (resourceCollection.size() != 1) {
            throw new BuildException("only single argument resource collections are supported as archives");
        }
        this.archive = (Resource)resourceCollection.iterator().next();
    }

    public Resource getArchive() {
        return this.isReference() ? ((ArchiveResource)this.getCheckedRef()).getArchive() : this.archive;
    }

    @Override
    public long getLastModified() {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).getLastModified();
        }
        this.checkEntry();
        return super.getLastModified();
    }

    @Override
    public long getSize() {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).getSize();
        }
        this.checkEntry();
        return super.getSize();
    }

    @Override
    public boolean isDirectory() {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).isDirectory();
        }
        this.checkEntry();
        return super.isDirectory();
    }

    @Override
    public boolean isExists() {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).isExists();
        }
        this.checkEntry();
        return super.isExists();
    }

    public int getMode() {
        if (this.isReference()) {
            return ((ArchiveResource)this.getCheckedRef()).getMode();
        }
        this.checkEntry();
        return this.mode;
    }

    @Override
    public void setRefid(Reference reference) {
        if (this.archive != null || this.modeSet) {
            throw this.tooManyAttributes();
        }
        super.setRefid(reference);
    }

    @Override
    public int compareTo(Object object) {
        return this.equals(object) ? 0 : super.compareTo(object);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (this.isReference()) {
            return this.getCheckedRef().equals(object);
        }
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        ArchiveResource archiveResource = (ArchiveResource)object;
        return this.getArchive().equals(archiveResource.getArchive()) && this.getName().equals(archiveResource.getName());
    }

    @Override
    public int hashCode() {
        return super.hashCode() * (this.getArchive() == null ? NULL_ARCHIVE : this.getArchive().hashCode());
    }

    @Override
    public String toString() {
        return this.isReference() ? this.getCheckedRef().toString() : this.getArchive().toString() + ':' + this.getName();
    }

    private synchronized void checkEntry() throws BuildException {
        if (this.haveEntry) {
            return;
        }
        String string = this.getName();
        if (string == null) {
            throw new BuildException("entry name not set");
        }
        Resource resource = this.getArchive();
        if (resource == null) {
            throw new BuildException("archive attribute not set");
        }
        if (!resource.isExists()) {
            throw new BuildException(resource.toString() + " does not exist.");
        }
        if (resource.isDirectory()) {
            throw new BuildException(resource + " denotes a directory.");
        }
        this.fetchEntry();
        this.haveEntry = true;
    }

    protected abstract void fetchEntry();
}

