/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.util.FileUtils;

public class TimeComparison
extends EnumeratedAttribute {
    private static final String[] VALUES = new String[]{"before", "after", "equal"};
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    public static final TimeComparison BEFORE = new TimeComparison("before");
    public static final TimeComparison AFTER = new TimeComparison("after");
    public static final TimeComparison EQUAL = new TimeComparison("equal");

    public TimeComparison() {
    }

    public TimeComparison(String string) {
        this.setValue(string);
    }

    @Override
    public String[] getValues() {
        return VALUES;
    }

    public boolean evaluate(long l, long l2) {
        return this.evaluate(l, l2, FILE_UTILS.getFileTimestampGranularity());
    }

    public boolean evaluate(long l, long l2, long l3) {
        int n = this.getIndex();
        if (n == -1) {
            throw new BuildException("TimeComparison value not set.");
        }
        if (n == 0) {
            return l - l3 < l2;
        }
        if (n == 1) {
            return l + l3 > l2;
        }
        return Math.abs(l - l2) <= l3;
    }

    public static int compare(long l, long l2) {
        return TimeComparison.compare(l, l2, FILE_UTILS.getFileTimestampGranularity());
    }

    public static int compare(long l, long l2, long l3) {
        long l4 = l - l2;
        long l5 = Math.abs(l4);
        return l5 > Math.abs(l3) ? (int)(l4 / l5) : 0;
    }
}

