/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.AbstractFileSet;
import org.apache.tools.ant.types.ArchiveFileSet;
import org.apache.tools.ant.types.ArchiveScanner;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.TarScanner;

public class TarFileSet
extends ArchiveFileSet {
    private boolean userNameSet;
    private boolean groupNameSet;
    private boolean userIdSet;
    private boolean groupIdSet;
    private String userName = "";
    private String groupName = "";
    private int uid;
    private int gid;

    public TarFileSet() {
    }

    protected TarFileSet(FileSet fileSet) {
        super(fileSet);
    }

    protected TarFileSet(TarFileSet tarFileSet) {
        super(tarFileSet);
    }

    public void setUserName(String string) {
        this.checkTarFileSetAttributesAllowed();
        this.userNameSet = true;
        this.userName = string;
    }

    public String getUserName() {
        if (this.isReference()) {
            return ((TarFileSet)this.getCheckedRef()).getUserName();
        }
        return this.userName;
    }

    public boolean hasUserNameBeenSet() {
        return this.userNameSet;
    }

    public void setUid(int n) {
        this.checkTarFileSetAttributesAllowed();
        this.userIdSet = true;
        this.uid = n;
    }

    public int getUid() {
        if (this.isReference()) {
            return ((TarFileSet)this.getCheckedRef()).getUid();
        }
        return this.uid;
    }

    public boolean hasUserIdBeenSet() {
        return this.userIdSet;
    }

    public void setGroup(String string) {
        this.checkTarFileSetAttributesAllowed();
        this.groupNameSet = true;
        this.groupName = string;
    }

    public String getGroup() {
        if (this.isReference()) {
            return ((TarFileSet)this.getCheckedRef()).getGroup();
        }
        return this.groupName;
    }

    public boolean hasGroupBeenSet() {
        return this.groupNameSet;
    }

    public void setGid(int n) {
        this.checkTarFileSetAttributesAllowed();
        this.groupIdSet = true;
        this.gid = n;
    }

    public int getGid() {
        if (this.isReference()) {
            return ((TarFileSet)this.getCheckedRef()).getGid();
        }
        return this.gid;
    }

    public boolean hasGroupIdBeenSet() {
        return this.groupIdSet;
    }

    @Override
    protected ArchiveScanner newArchiveScanner() {
        TarScanner tarScanner = new TarScanner();
        return tarScanner;
    }

    @Override
    public void setRefid(Reference reference) throws BuildException {
        if (this.userNameSet || this.userIdSet || this.groupNameSet || this.groupIdSet) {
            throw this.tooManyAttributes();
        }
        super.setRefid(reference);
    }

    @Override
    protected AbstractFileSet getRef(Project project) {
        this.dieOnCircularReference(project);
        Object object = this.getRefid().getReferencedObject(project);
        if (object instanceof TarFileSet) {
            return (AbstractFileSet)object;
        }
        if (object instanceof FileSet) {
            TarFileSet tarFileSet = new TarFileSet((FileSet)object);
            this.configureFileSet(tarFileSet);
            return tarFileSet;
        }
        String string = this.getRefid().getRefId() + " doesn't denote a tarfileset or a fileset";
        throw new BuildException(string);
    }

    @Override
    protected void configureFileSet(ArchiveFileSet archiveFileSet) {
        super.configureFileSet(archiveFileSet);
        if (archiveFileSet instanceof TarFileSet) {
            TarFileSet tarFileSet = (TarFileSet)archiveFileSet;
            tarFileSet.setUserName(this.userName);
            tarFileSet.setGroup(this.groupName);
            tarFileSet.setUid(this.uid);
            tarFileSet.setGid(this.gid);
        }
    }

    @Override
    public Object clone() {
        if (this.isReference()) {
            return ((TarFileSet)this.getRef(this.getProject())).clone();
        }
        return super.clone();
    }

    private void checkTarFileSetAttributesAllowed() {
        if (this.getProject() == null || this.isReference() && this.getRefid().getReferencedObject(this.getProject()) instanceof TarFileSet) {
            this.checkAttributesAllowed();
        }
    }
}

