/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.ResourceCollection;

public class Resource
extends DataType
implements Cloneable,
Comparable,
ResourceCollection {
    public static final long UNKNOWN_SIZE = -1L;
    public static final long UNKNOWN_DATETIME = 0L;
    protected static final int MAGIC = Resource.getMagicNumber("Resource".getBytes());
    private static final int NULL_NAME = Resource.getMagicNumber("null name".getBytes());
    private String name = null;
    private Boolean exists = null;
    private Long lastmodified = null;
    private Boolean directory = null;
    private Long size = null;

    protected static int getMagicNumber(byte[] byArray) {
        return new BigInteger(byArray).intValue();
    }

    public Resource() {
    }

    public Resource(String string) {
        this(string, false, 0L, false);
    }

    public Resource(String string, boolean bl, long l) {
        this(string, bl, l, false);
    }

    public Resource(String string, boolean bl, long l, boolean bl2) {
        this(string, bl, l, bl2, -1L);
    }

    public Resource(String string, boolean bl, long l, boolean bl2, long l2) {
        this.name = string;
        this.setName(string);
        this.setExists(bl);
        this.setLastModified(l);
        this.setDirectory(bl2);
        this.setSize(l2);
    }

    public String getName() {
        return this.isReference() ? ((Resource)this.getCheckedRef()).getName() : this.name;
    }

    public void setName(String string) {
        this.checkAttributesAllowed();
        this.name = string;
    }

    public boolean isExists() {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).isExists();
        }
        return this.exists == null || this.exists != false;
    }

    public void setExists(boolean bl) {
        this.checkAttributesAllowed();
        this.exists = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public long getLastModified() {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).getLastModified();
        }
        if (!this.isExists() || this.lastmodified == null) {
            return 0L;
        }
        long l = this.lastmodified;
        return l < 0L ? 0L : l;
    }

    public void setLastModified(long l) {
        this.checkAttributesAllowed();
        this.lastmodified = new Long(l);
    }

    public boolean isDirectory() {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).isDirectory();
        }
        return this.directory != null && this.directory != false;
    }

    public void setDirectory(boolean bl) {
        this.checkAttributesAllowed();
        this.directory = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setSize(long l) {
        this.checkAttributesAllowed();
        this.size = new Long(l > -1L ? l : -1L);
    }

    public long getSize() {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).getSize();
        }
        return this.isExists() ? (this.size != null ? this.size : -1L) : 0L;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new UnsupportedOperationException("CloneNotSupportedException for a Resource caught. Derived classes must support cloning.");
        }
    }

    public int compareTo(Object object) {
        if (this.isReference()) {
            return ((Comparable)this.getCheckedRef()).compareTo(object);
        }
        if (!(object instanceof Resource)) {
            throw new IllegalArgumentException("Can only be compared with Resources");
        }
        return this.toString().compareTo(object.toString());
    }

    public boolean equals(Object object) {
        if (this.isReference()) {
            return this.getCheckedRef().equals(object);
        }
        return object.getClass().equals(this.getClass()) && this.compareTo(object) == 0;
    }

    public int hashCode() {
        if (this.isReference()) {
            return this.getCheckedRef().hashCode();
        }
        String string = this.getName();
        return MAGIC * (string == null ? NULL_NAME : string.hashCode());
    }

    public InputStream getInputStream() throws IOException {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).getInputStream();
        }
        throw new UnsupportedOperationException();
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).getOutputStream();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator iterator() {
        return this.isReference() ? ((Resource)this.getCheckedRef()).iterator() : new Iterator(){
            private boolean done = false;

            @Override
            public boolean hasNext() {
                return !this.done;
            }

            public Object next() {
                if (this.done) {
                    throw new NoSuchElementException();
                }
                this.done = true;
                return Resource.this;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int size() {
        return this.isReference() ? ((Resource)this.getCheckedRef()).size() : 1;
    }

    @Override
    public boolean isFilesystemOnly() {
        return this.isReference() && ((Resource)this.getCheckedRef()).isFilesystemOnly();
    }

    @Override
    public String toString() {
        if (this.isReference()) {
            return this.getCheckedRef().toString();
        }
        String string = this.getName();
        return string == null ? "(anonymous)" : string;
    }

    public final String toLongString() {
        return this.isReference() ? ((Resource)this.getCheckedRef()).toLongString() : this.getDataTypeName() + " \"" + this.toString() + '\"';
    }

    @Override
    public void setRefid(Reference reference) {
        if (this.name != null || this.exists != null || this.lastmodified != null || this.directory != null || this.size != null) {
            throw this.tooManyAttributes();
        }
        super.setRefid(reference);
    }
}

