/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.EnumeratedAttribute;

public class Quantifier
extends EnumeratedAttribute {
    private static final String[] VALUES = new String[]{"all", "each", "every", "any", "some", "one", "majority", "most", "none"};
    public static final Quantifier ALL = new Quantifier("all");
    public static final Quantifier ANY = new Quantifier("any");
    public static final Quantifier ONE = new Quantifier("one");
    public static final Quantifier MAJORITY = new Quantifier("majority");
    public static final Quantifier NONE = new Quantifier("none");
    private static final Predicate ALL_PRED = new Predicate(){

        @Override
        boolean eval(int n, int n2) {
            return n2 == 0;
        }
    };
    private static final Predicate ANY_PRED = new Predicate(){

        @Override
        boolean eval(int n, int n2) {
            return n > 0;
        }
    };
    private static final Predicate ONE_PRED = new Predicate(){

        @Override
        boolean eval(int n, int n2) {
            return n == 1;
        }
    };
    private static final Predicate MAJORITY_PRED = new Predicate(){

        @Override
        boolean eval(int n, int n2) {
            return n > n2;
        }
    };
    private static final Predicate NONE_PRED = new Predicate(){

        @Override
        boolean eval(int n, int n2) {
            return n == 0;
        }
    };
    private static final Predicate[] PREDS = new Predicate[VALUES.length];

    public Quantifier() {
    }

    public Quantifier(String string) {
        this.setValue(string);
    }

    @Override
    public String[] getValues() {
        return VALUES;
    }

    public boolean evaluate(boolean[] blArray) {
        int n = 0;
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            ++n;
        }
        return this.evaluate(n, blArray.length - n);
    }

    public boolean evaluate(int n, int n2) {
        int n3 = this.getIndex();
        if (n3 == -1) {
            throw new BuildException("Quantifier value not set.");
        }
        return PREDS[n3].eval(n, n2);
    }

    static {
        Quantifier.PREDS[0] = ALL_PRED;
        Quantifier.PREDS[1] = ALL_PRED;
        Quantifier.PREDS[2] = ALL_PRED;
        Quantifier.PREDS[3] = ANY_PRED;
        Quantifier.PREDS[4] = ANY_PRED;
        Quantifier.PREDS[5] = ONE_PRED;
        Quantifier.PREDS[6] = MAJORITY_PRED;
        Quantifier.PREDS[7] = MAJORITY_PRED;
        Quantifier.PREDS[8] = NONE_PRED;
    }

    private static abstract class Predicate {
        private Predicate() {
        }

        abstract boolean eval(int var1, int var2);
    }
}

