/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.PropertyResource;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.regexp.RegexpMatcherFactory;

public class PropertySet
extends DataType
implements ResourceCollection {
    private boolean dynamic = true;
    private boolean negate = false;
    private Set cachedNames;
    private Vector ptyRefs = new Vector();
    private Vector setRefs = new Vector();
    private Mapper mapper;
    private boolean noAttributeSet = true;

    public void appendName(String string) {
        PropertyRef propertyRef = new PropertyRef();
        propertyRef.setName(string);
        this.addPropertyref(propertyRef);
    }

    public void appendRegex(String string) {
        PropertyRef propertyRef = new PropertyRef();
        propertyRef.setRegex(string);
        this.addPropertyref(propertyRef);
    }

    public void appendPrefix(String string) {
        PropertyRef propertyRef = new PropertyRef();
        propertyRef.setPrefix(string);
        this.addPropertyref(propertyRef);
    }

    public void appendBuiltin(BuiltinPropertySetName builtinPropertySetName) {
        PropertyRef propertyRef = new PropertyRef();
        propertyRef.setBuiltin(builtinPropertySetName);
        this.addPropertyref(propertyRef);
    }

    public void setMapper(String string, String string2, String string3) {
        Mapper mapper = this.createMapper();
        Mapper.MapperType mapperType = new Mapper.MapperType();
        mapperType.setValue(string);
        mapper.setType(mapperType);
        mapper.setFrom(string2);
        mapper.setTo(string3);
    }

    public void addPropertyref(PropertyRef propertyRef) {
        this.assertNotReference();
        this.ptyRefs.addElement(propertyRef);
    }

    public void addPropertyset(PropertySet propertySet) {
        this.assertNotReference();
        this.setRefs.addElement(propertySet);
    }

    public Mapper createMapper() {
        this.assertNotReference();
        if (this.mapper != null) {
            throw new BuildException("Too many <mapper>s!");
        }
        this.mapper = new Mapper(this.getProject());
        return this.mapper;
    }

    public void add(FileNameMapper fileNameMapper) {
        this.createMapper().add(fileNameMapper);
    }

    public void setDynamic(boolean bl) {
        this.assertNotReference();
        this.dynamic = bl;
    }

    public void setNegate(boolean bl) {
        this.assertNotReference();
        this.negate = bl;
    }

    public boolean getDynamic() {
        return this.isReference() ? this.getRef().dynamic : this.dynamic;
    }

    public Mapper getMapper() {
        return this.isReference() ? this.getRef().mapper : this.mapper;
    }

    private Hashtable getAllSystemProperties() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Enumeration<?> enumeration = System.getProperties().propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            hashtable.put(string, System.getProperties().getProperty(string));
        }
        return hashtable;
    }

    /*
     * WARNING - void declaration
     */
    public Properties getProperties() {
        DataType dataType;
        if (this.isReference()) {
            return this.getRef().getProperties();
        }
        Set<Object> set = null;
        Project project = this.getProject();
        Hashtable hashtable = project == null ? this.getAllSystemProperties() : project.getProperties();
        HashSet hashSet = this.setRefs.elements();
        while (hashSet.hasMoreElements()) {
            dataType = (PropertySet)hashSet.nextElement();
            hashtable.putAll(((PropertySet)dataType).getProperties());
        }
        if (this.getDynamic() || this.cachedNames == null) {
            set = new HashSet();
            this.addPropertyNames(set, hashtable);
            hashSet = this.setRefs.elements();
            while (hashSet.hasMoreElements()) {
                dataType = (PropertySet)hashSet.nextElement();
                set.addAll(((PropertySet)dataType).getProperties().keySet());
            }
            if (this.negate) {
                hashSet = new HashSet(hashtable.keySet());
                hashSet.removeAll(set);
                set = hashSet;
            }
            if (!this.getDynamic()) {
                this.cachedNames = set;
            }
        } else {
            set = this.cachedNames;
        }
        hashSet = null;
        dataType = this.getMapper();
        if (dataType != null) {
            hashSet = ((Mapper)dataType).getImplementation();
        }
        Properties properties = new Properties();
        for (String string : set) {
            void string2;
            String[] stringArray;
            String string3 = (String)hashtable.get(string);
            if (string3 == null) continue;
            if (hashSet != null && (stringArray = hashSet.mapFileName(string)) != null) {
                String string4 = stringArray[0];
            }
            properties.setProperty((String)string2, string3);
        }
        return properties;
    }

    private void addPropertyNames(Set set, Hashtable hashtable) {
        Enumeration enumeration = this.ptyRefs.elements();
        while (enumeration.hasMoreElements()) {
            Object object;
            Object object2;
            PropertyRef propertyRef = (PropertyRef)enumeration.nextElement();
            if (propertyRef.name != null) {
                if (hashtable.get(propertyRef.name) == null) continue;
                set.add(propertyRef.name);
                continue;
            }
            if (propertyRef.prefix != null) {
                object2 = hashtable.keys();
                while (object2.hasMoreElements()) {
                    object = (String)object2.nextElement();
                    if (!((String)object).startsWith(propertyRef.prefix)) continue;
                    set.add(object);
                }
                continue;
            }
            if (propertyRef.regex != null) {
                object2 = new RegexpMatcherFactory();
                object = ((RegexpMatcherFactory)object2).newRegexpMatcher();
                object.setPattern(propertyRef.regex);
                Enumeration enumeration2 = hashtable.keys();
                while (enumeration2.hasMoreElements()) {
                    String string = (String)enumeration2.nextElement();
                    if (!object.matches(string)) continue;
                    set.add(string);
                }
                continue;
            }
            if (propertyRef.builtin != null) {
                if (propertyRef.builtin.equals("all")) {
                    set.addAll(hashtable.keySet());
                    continue;
                }
                if (propertyRef.builtin.equals("system")) {
                    set.addAll(System.getProperties().keySet());
                    continue;
                }
                if (propertyRef.builtin.equals("commandline")) {
                    set.addAll(this.getProject().getUserProperties().keySet());
                    continue;
                }
                throw new BuildException("Impossible: Invalid builtin attribute!");
            }
            throw new BuildException("Impossible: Invalid PropertyRef!");
        }
    }

    protected PropertySet getRef() {
        return (PropertySet)this.getCheckedRef(PropertySet.class, "propertyset");
    }

    @Override
    public final void setRefid(Reference reference) {
        if (!this.noAttributeSet) {
            throw this.tooManyAttributes();
        }
        super.setRefid(reference);
    }

    protected final void assertNotReference() {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.noAttributeSet = false;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        TreeMap<Object, Object> treeMap = new TreeMap<Object, Object>(this.getProperties());
        for (Map.Entry<Object, Object> entry : treeMap.entrySet()) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(entry.getKey().toString());
            stringBuffer.append("=");
            stringBuffer.append(entry.getValue().toString());
        }
        return stringBuffer.toString();
    }

    @Override
    public Iterator iterator() {
        final Enumeration<?> enumeration = this.getProperties().propertyNames();
        return new Iterator(){

            @Override
            public boolean hasNext() {
                return enumeration.hasMoreElements();
            }

            public Object next() {
                return new PropertyResource(PropertySet.this.getProject(), (String)enumeration.nextElement());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int size() {
        return this.isReference() ? this.getRef().size() : this.getProperties().size();
    }

    @Override
    public boolean isFilesystemOnly() {
        return this.isReference() && this.getRef().isFilesystemOnly();
    }

    public static class BuiltinPropertySetName
    extends EnumeratedAttribute {
        static final String ALL = "all";
        static final String SYSTEM = "system";
        static final String COMMANDLINE = "commandline";

        @Override
        public String[] getValues() {
            return new String[]{ALL, SYSTEM, COMMANDLINE};
        }
    }

    public static class PropertyRef {
        private int count;
        private String name;
        private String regex;
        private String prefix;
        private String builtin;

        public void setName(String string) {
            this.assertValid("name", string);
            this.name = string;
        }

        public void setRegex(String string) {
            this.assertValid("regex", string);
            this.regex = string;
        }

        public void setPrefix(String string) {
            this.assertValid("prefix", string);
            this.prefix = string;
        }

        public void setBuiltin(BuiltinPropertySetName builtinPropertySetName) {
            String string = builtinPropertySetName.getValue();
            this.assertValid("builtin", string);
            this.builtin = string;
        }

        private void assertValid(String string, String string2) {
            if (string2 == null || string2.length() < 1) {
                throw new BuildException("Invalid attribute: " + string);
            }
            if (++this.count != 1) {
                throw new BuildException("Attributes name, regex, and prefix are mutually exclusive");
            }
        }

        public String toString() {
            return "name=" + this.name + ", regex=" + this.regex + ", prefix=" + this.prefix + ", builtin=" + this.builtin;
        }
    }
}

