/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.util.Stack;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ComponentHelper;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.IdentityStack;

public abstract class DataType
extends ProjectComponent
implements Cloneable {
    protected Reference ref;
    protected boolean checked = true;

    public boolean isReference() {
        return this.ref != null;
    }

    public void setRefid(Reference reference) {
        this.ref = reference;
        this.checked = false;
    }

    protected String getDataTypeName() {
        return ComponentHelper.getElementName(this.getProject(), this, true);
    }

    protected void dieOnCircularReference() {
        this.dieOnCircularReference(this.getProject());
    }

    protected void dieOnCircularReference(Project project) {
        if (this.checked || !this.isReference()) {
            return;
        }
        this.dieOnCircularReference(new IdentityStack(this), project);
    }

    protected void dieOnCircularReference(Stack stack, Project project) throws BuildException {
        if (this.checked || !this.isReference()) {
            return;
        }
        Object object = this.ref.getReferencedObject(project);
        if (object instanceof DataType) {
            IdentityStack identityStack = IdentityStack.getInstance(stack);
            if (identityStack.contains(object)) {
                throw this.circularReference();
            }
            identityStack.push(object);
            ((DataType)object).dieOnCircularReference(identityStack, project);
            identityStack.pop();
        }
        this.checked = true;
    }

    public static void invokeCircularReferenceCheck(DataType dataType, Stack stack, Project project) {
        dataType.dieOnCircularReference(stack, project);
    }

    protected Object getCheckedRef() {
        return this.getCheckedRef(this.getProject());
    }

    protected Object getCheckedRef(Project project) {
        return this.getCheckedRef(this.getClass(), this.getDataTypeName(), project);
    }

    protected Object getCheckedRef(Class clazz, String string) {
        return this.getCheckedRef(clazz, string, this.getProject());
    }

    protected Object getCheckedRef(Class clazz, String string, Project project) {
        if (project == null) {
            throw new BuildException("No Project specified");
        }
        this.dieOnCircularReference(project);
        Object object = this.ref.getReferencedObject(project);
        if (!clazz.isAssignableFrom(object.getClass())) {
            this.log("Class " + object.getClass() + " is not a subclass of " + clazz, 3);
            String string2 = this.ref.getRefId() + " doesn't denote a " + string;
            throw new BuildException(string2);
        }
        return object;
    }

    protected BuildException tooManyAttributes() {
        return new BuildException("You must not specify more than one attribute when using refid");
    }

    protected BuildException noChildrenAllowed() {
        return new BuildException("You must not specify nested elements when using refid");
    }

    protected BuildException circularReference() {
        return new BuildException("This data type contains a circular reference.");
    }

    protected boolean isChecked() {
        return this.checked;
    }

    protected void setChecked(boolean bl) {
        this.checked = bl;
    }

    public Reference getRefid() {
        return this.ref;
    }

    protected void checkAttributesAllowed() {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
    }

    protected void checkChildrenAllowed() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
    }

    public String toString() {
        String string = this.getDescription();
        return string == null ? this.getDataTypeName() : this.getDataTypeName() + " " + string;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DataType dataType = (DataType)super.clone();
        dataType.setDescription(this.getDescription());
        if (this.getRefid() != null) {
            dataType.setRefid(this.getRefid());
        }
        dataType.setChecked(this.isChecked());
        return dataType;
    }
}

